; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;

(define (script-fu-sg-layer-decomp-RGB image drawable)
  (let* ((black (car (gimp-image-get-active-layer image)))
         (layer-name (car (gimp-drawable-get-name black)))
         (red 0)
         (green 0)
         (blue 0)
         (mask 0)
         (selection 0)
         )
    (gimp-image-undo-group-start image)
    (gimp-context-push)
    (set! selection (car (gimp-selection-save image)))
    (gimp-selection-none image)
    (gimp-image-set-active-layer image black)
    (set! red (car (gimp-layer-new-from-drawable black image)))
    (set! green (car (gimp-layer-new-from-drawable black image)))
    (set! blue (car (gimp-layer-new-from-drawable black image)))
    (gimp-image-add-layer image blue -1)
    (gimp-image-add-layer image green -1)
    (gimp-image-add-layer image red -1)
    (gimp-drawable-set-name red (string-append layer-name " - RED"))
    (gimp-drawable-set-name green (string-append layer-name " - GREEN"))
    (gimp-drawable-set-name blue (string-append layer-name " - BLUE"))
    (plug-in-colors-channel-mixer RUN-NONINTERACTIVE image red FALSE
                                  1 0 0
                                  1 0 0
                                  1 0 0)
    (plug-in-colors-channel-mixer RUN-NONINTERACTIVE image green FALSE
                                  0 1 0
                                  0 1 0
                                  0 1 0)
    (plug-in-colors-channel-mixer RUN-NONINTERACTIVE image blue FALSE
                                  0 0 1
                                  0 0 1
                                  0 0 1)
    (set! mask (car (gimp-layer-create-mask red ADD-MASK-COPY)))
    (gimp-layer-add-mask red mask)
    (set! mask (car (gimp-layer-create-mask green ADD-MASK-COPY)))
    (gimp-layer-add-mask green mask)
    (set! mask (car (gimp-layer-create-mask blue ADD-MASK-COPY)))
    (gimp-layer-add-mask blue mask)
    (gimp-context-set-foreground '(255 0 0))
    (gimp-drawable-fill red FILL-FOREGROUND)
    (gimp-context-set-foreground '(0 255 0))
    (gimp-drawable-fill green FILL-FOREGROUND)
    (gimp-context-set-foreground '(0 0 255))
    (gimp-drawable-fill blue FILL-FOREGROUND)
    (gimp-context-set-foreground '(0 0 0))
    (gimp-edit-fill black FILL-FOREGROUND)
    (gimp-layer-set-mode red LAYER-MODE-LIGHTEN-ONLY-LEGACY)
    (gimp-layer-set-mode green LAYER-MODE-LIGHTEN-ONLY-LEGACY)
    (gimp-layer-set-mode blue LAYER-MODE-LIGHTEN-ONLY-LEGACY)
    (gimp-selection-load selection)
    (gimp-image-remove-channel image selection)
    (gimp-context-pop)
    (gimp-displays-flush)
    (gimp-image-undo-group-end image)
    )
  )

(define (script-fu-sg-layer-decomp-CMY image drawable)
  (let* ((white (car (gimp-image-get-active-layer image)))
         (layer-name (car (gimp-drawable-get-name white)))
         (cyan 0)
         (magenta 0)
         (yellow 0)
         (mask 0)
         (selection 0)
         )
    (gimp-image-undo-group-start image)
    (set! selection (car (gimp-selection-save image)))
    (gimp-selection-none image)
    (gimp-image-set-active-layer image white)
    (gimp-invert white)
    (set! cyan (car (gimp-layer-new-from-drawable white image)))
    (set! magenta (car (gimp-layer-new-from-drawable white image)))
    (set! yellow (car (gimp-layer-new-from-drawable white image)))
    (gimp-image-add-layer image yellow -1)
    (gimp-image-add-layer image magenta -1)
    (gimp-image-add-layer image cyan -1)
    (gimp-drawable-set-name cyan (string-append layer-name " - CYAN"))
    (gimp-drawable-set-name magenta (string-append layer-name " - MAGENTA"))
    (gimp-drawable-set-name yellow (string-append layer-name " - YELLOW"))
    (plug-in-colors-channel-mixer RUN-NONINTERACTIVE image cyan FALSE
                                  1 0 0
                                  1 0 0
                                  1 0 0)
    (plug-in-colors-channel-mixer RUN-NONINTERACTIVE image magenta FALSE
                                  0 1 0
                                  0 1 0
                                  0 1 0)
    (plug-in-colors-channel-mixer RUN-NONINTERACTIVE image yellow FALSE
                                  0 0 1
                                  0 0 1
                                  0 0 1)
    (set! mask (car (gimp-layer-create-mask cyan ADD-MASK-COPY)))
    (gimp-layer-add-mask cyan mask)
    (set! mask (car (gimp-layer-create-mask magenta ADD-MASK-COPY)))
    (gimp-layer-add-mask magenta mask)
    (set! mask (car (gimp-layer-create-mask yellow ADD-MASK-COPY)))
    (gimp-layer-add-mask yellow mask)
    (gimp-context-set-foreground '(0 255 255))
    (gimp-drawable-fill cyan FILL-FOREGROUND)
    (gimp-context-set-foreground '(255 0 255))
    (gimp-drawable-fill magenta FILL-FOREGROUND)
    (gimp-context-set-foreground '(255 255 0))
    (gimp-drawable-fill yellow FILL-FOREGROUND)
    (gimp-edit-fill white FILL-WHITE)
    (gimp-layer-set-mode cyan LAYER-MODE-DARKEN-ONLY-LEGACY)
    (gimp-layer-set-mode magenta LAYER-MODE-DARKEN-ONLY-LEGACY)
    (gimp-layer-set-mode yellow LAYER-MODE-DARKEN-ONLY-LEGACY)
    (gimp-selection-load selection)
    (gimp-image-remove-channel image selection)
    (gimp-displays-flush)
    (gimp-image-undo-group-end image)
    )
  )

(script-fu-register "script-fu-sg-layer-decomp-RGB"
        "Decompose RGB"
        _"Decompose layer to its RGB components"
        "saulgoode"
        "2006, saulgoode"
        ""
        "RGB*"
        SF-IMAGE "Image" 0
        SF-DRAWABLE "Drawable" 0
        )

(script-fu-menu-register "script-fu-sg-layer-decomp-RGB"
        "<Image>/Layer/"
 )

(script-fu-register "script-fu-sg-layer-decomp-CMY"
        "Decompose CMY"
        _"Decompose layer to its CMY components"
        "saulgoode"
        "2006, saulgoode"
        ""
        "RGB*"
        SF-IMAGE "Image" 0
        SF-DRAWABLE "Drawable" 0
        )

(script-fu-menu-register "script-fu-sg-layer-decomp-CMY"
 "<Image>/Layer/"
 )
