#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os,sys,time,traceback
from gimpfu import *

import numpy as np

operations=[('Average',np.mean),('Median',np.median)]

# Returns NP array (N,bpp) (single vector ot triplets)
def channelData(layer):
    w,h=layer.width,layer.height
    region=layer.get_pixel_rgn(0, 0, w,h)
    pixChars=region[:,:]
    bpp=region.bpp
    return np.frombuffer(pixChars,dtype=np.uint8).reshape(w,h,bpp)

def createResultLayer(image,name,result):
    rlBytes=np.uint8(result).tobytes();
    rl=gimp.Layer(image,name,image.width,image.height,image.active_layer.type,100,NORMAL_MODE)
    region=rl.get_pixel_rgn(0, 0, rl.width,rl.height,True)
    region[:,:]=rlBytes
    image.add_layer(rl,0)
    gimp.displays_flush()
    
def numpyOps(image,opix):
    image.undo_group_start()
    #print '*******************************************'
    ts=time.time()
    try:
        npLayers=[]
        for l in image.layers:
            if l.visible:
                npLayers.append(channelData(l));
        stacked=np.stack(npLayers)
        print "Stacked:",stacked.shape
        result=operations[opix][1](stacked,axis=0)
        print "Result:",result.shape
        createResultLayer(image,"Numpy Ops",result)

    except Exception as e:
        print e
        traceback.print_exc()

    te=time.time()
    print "Elapsed time:",te-ts
    image.undo_group_end()

def numpyLuminosity(image,drawable):
    image.undo_group_start()
    print '*******************************************'
    ts=time.time()
    try:
        layer=channelData(drawable)
        print "Layer in:",layer.shape
        luminosity=layer[:,:,0]*0.21+layer[:,:,1]*0.72+layer[:,:,2]*0.07 # gray value
        print "Luminosity:",luminosity.shape
        # 3 equal RGB channels plus perhaps the original alpha channel
        channels=[luminosity,luminosity,luminosity] 
        if layer.shape[-1]==4:
            channels.append(layer[:,:,3]) 
        channels=np.stack(channels,axis=-1)
        print "Channels:",channels.shape
        createResultLayer(image,"Numpy Luminosity",channels)

    except Exception as e:
        print e
        traceback.print_exc()

    te=time.time()
    print "Elapsed time:",te-ts
    image.undo_group_end()

### Registrations
whoiam='\n'+os.path.abspath(sys.argv[0])
    
register(
    "numpy-ops","numpy-ops","numpy-ops",
    "Ofnuts","Ofnuts","2017",
    "Average/Median of visible layers",
    "*",
    [
            (PF_IMAGE, "image", "Input image", None),
            (PF_OPTION, "operation", "Operation", 0,[op[0] for op in operations])
    ],
    [],
    numpyOps,
    menu="<Image>/Numpy/",
)
 
register(
    "numpy-luminosity","numpy-luminosity","numpy-luminosity",
    "Ofnuts","Ofnuts","2017",
    "Luminosity on layer",
    "*",
    [
            (PF_IMAGE,    "image", "Input image", None),
            (PF_DRAWABLE, "layer", "Input layer", None)
    ],
    [],
    numpyLuminosity,
    menu="<Image>/Numpy/",
)
 
main()       
