#!/usr/bin/env python

# freaky_details_dm.py
#
# License: GPLv3
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# To view a copy of the GNU General Public License
# visit: http://www.gnu.org/licenses/gpl.html
#
#
# ------------
#| Change Log |
# ------------
# Version 1 05/12/2023
# 
#
#
#import Image
from gimpfu import *
def python_freaky_details_dm(image, layer) :
	pdb.gimp_image_undo_group_start(image)
	pdb.gimp_context_push()
	
	layer_group = pdb.gimp_layer_group_new(image)
	pdb.gimp_image_insert_layer(image, layer_group, None, 0)
	pdb.gimp_layer_set_mode(layer_group, LAYER_MODE_OVERLAY)
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image, layer_copy, layer_group, 0)
	pdb.gimp_drawable_invert(layer_copy, FALSE)
	pdb.gimp_layer_set_mode(layer_copy, LAYER_MODE_VIVID_LIGHT)
	layer_copy1 = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image, layer_copy1, layer_group, 1)
	pdb.gimp_image_set_active_layer(image, layer_copy)
		
	pdb.gimp_context_pop()
	pdb.gimp_image_undo_group_end(image)
	pdb.gimp_displays_flush()


register(
	"python_freaky_details_dm",
	"Freaky_Details_DM",
	"Freaky_Details_DM",
	"David Marsden",
	"David Marsden",
	"December 2023",
	"<Image>/Python-Fu/Freaky_Details_DM...",             #Menu path
	"RGB*, GRAY*", 
	[],
	[],
	python_freaky_details_dm)

main()
