#!/usr/bin/env python
#
from gimpfu import *


def quick_save(image, layer, outputFolder, save_webp):

    gimp.progress_init("Saving to '" + outputFolder + "'...")
    
    try:
 
        if save_webp == 1:
                gimp.pdb.file_webp_save(image, layer, outputFolder + "/" + layer.name + ".webp", "raw_filename",
                    0,                   #preset default=0 Picture=1 Photo=2 Drawing=3 Icon=4 Text=5
                    0,                   #lossless 0 / 1
                    50.0,                #quality 0.0 to 100.0
                    100.0,               #alpha-uality 0.0 to 100.0
                    0,0,0,0,0,0,0,0,0)   #animation / metadata

        else:
                gimp.pdb.file_png_save(image, layer,outputFolder + "/" + layer.name + ".png","raw_filename",0,9,0,0,0,0,0)
        
        gimp.pdb.gimp_image_clean_all(image)

    except Exception as err:
        gimp.message("Unexpected error: " + str(err))
    
register(
    "python_fu_test_save_to_png",
    "Save to files",
    "Save the current layer into a webp/png file",
    "RG",
    "Open source",
    "2013",
    "<Image>/Tools/Quick_Save",
    "*",
    [
        (PF_DIRNAME, "outputFolder", "Output directory", ""),
        (PF_TOGGLE,   "save_webp",   "save_webp",   True),
    ],
    [],
    quick_save)

main()
