;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; This program is free software; you
; can redistribute it and/or modify
; it under the terms of the GNU
; General Public License as published
; by the Free Software Foundation;
; either version 2 of the License, or
; (at your option) any later version.
; This program is distributed in the
; hope that it will be useful,
; but WITHOUT ANY WARRANTY;
; without even the implied warranty of
; MERCHANTABILITY or FITNESS
; FOR A PARTICULAR PURPOSE.
; See the GNU General Public License
;  for more details
; added section for webp - rich 2023/08/06
;;;;;;;;;;;;;;;;;;;;;;;;;;PixLab;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; changed numbers of numbering to higger numbering  line 50 (substring "00000" (string-length
; and line 104 (list 0 0 9000 1 100 0 SF-SPINNER) 
; changed menu entry line 94 "<Image>/File/Save ALL As" added line 106 (script-fu-menu-register "script-fu-save-all-images" "<Image>/File/E_xport")
; changed description in line 96 for a better understanding about which layer will be selected > Do a new from visible and select it
; PixLab 2023/08/10

(define (script-fu-save-all-images inDir inSaveType
inFileName inFileNumber)
  (let* (
          (i (car (gimp-image-list)))
          (ii (car (gimp-image-list)))
          (image)
          (newFileName "")
          (saveString "")
          (pathchar (if (equal?
                 (substring gimp-dir 0 1) "/") "/" "\\"))
        )
    (set! saveString
      (cond
        (( equal? inSaveType 0 ) ".webp" )
        (( equal? inSaveType 1 ) ".jpg" )
        (( equal? inSaveType 2 ) ".png" )
        (( equal? inSaveType 3 ) ".tif" )
        (( equal? inSaveType 4 ) ".bmp" )
      )
    )


    (while (> i 0)
      (set! image (vector-ref (cadr (gimp-image-list)) (- i 1)))
      (set! newFileName (string-append inDir
              pathchar inFileName
              (substring "0000000" (string-length
              (number->string (+ inFileNumber i))))
              (number->string (+ inFileNumber i)) saveString))

      (cond
        ((equal? saveString ".webp")

           (file-webp-save RUN-NONINTERACTIVE
                      image
                      (car (gimp-image-get-active-layer image))
                      newFileName
                      newFileName
                      1    ;preset 0=default 1=pic 2=photo 3=drawing 4=icon 5=text
                      0    ;lossless 0/1
                      90   ; quality 0<>100
                      90   ; alpha-quality  0<>100
                      0
                      0
                      0
                      0   
                      0   ; save exif data ?
                      0   ; save IPTC  > works only if "save XMP data" is also checked
                      0   ; save XMP data ?
                      0   ; save color profile ? 
                      0   ; save thumbnail ?

          ))
        (else

          (gimp-file-save RUN-NONINTERACTIVE
                      image
                      (car (gimp-image-get-active-layer image))
                      newFileName
                      newFileName
          ))
      )

      (gimp-image-clean-all image)
      (set! i (- i 1))


 )))

(script-fu-register "script-fu-save-all-images"
 "Export All Images As..."
 "Save all opened images as webp, jpg, png, tif or bmp\nIf multiple layers save the selected layer in an image"
 "Lauchlin Wilkinson (& Saul Goode)"
 "Lauchlin Wilkinson (& Saul Goode)"
 "2014/04/21"
 ""
 SF-DIRNAME    "Save Directory" "Desktop"
 SF-OPTION     "Save File Type" (list "webp" "jpg" "png" "tif" "bmp")
 SF-STRING     "Save File Base Name" "IMAGE-"
 SF-ADJUSTMENT "Save File Start Number"
      (list 0 0 999999 1 100 0 SF-SPINNER)
 )
 (script-fu-menu-register "script-fu-save-all-images" "<Image>/File/E_xport")
