; Multiple Layer Actions rel 5.2
; Created by Graechan
; Comments directed to http://gimpchat.com or http://gimpscripts.com
;
; License: GPLv3
;    This program is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation, either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;    GNU General Public License for more details.
;
;    To view a copy of the GNU General Public License
;    visit: http://www.gnu.org/licenses/gpl.html
;
;
; ------------
;| Change Log |
; ------------ 
; Rel 0.01 - Initial Release
; Rel 0.02 - Bugfix for Layers with Locked Pixels, Added additional actions 'Clear Selection' and 'Layer to Image Size'
; Rel 0.03 - Enabled layer group functionality
; Rel 0.04 - Added Additional Actions
; Rel 0.05 - Added Actions for Color: Desaturate, Colorify and Color Balance
; Rel 05.1 - Added Additional Actions
;
(define (get-all-real-layers image)
    (define (get-children group)
      (let loop ((children (vector->list (cadr (gimp-item-get-children group))))
                 (sub-layers '()) )
        (if (null? children)
          (reverse sub-layers)
          (loop (cdr children)
                (if (zero? (car (gimp-item-is-group (car children))))
                  (cons (car children) sub-layers)
                  (append sub-layers (get-children (car children))) )))))
    (let loop ((top-layers (vector->list (cadr (gimp-image-get-layers image))))
               (all-layers '()) )
      (if (null? top-layers)
        all-layers
        (loop (cdr top-layers)
              (if (zero? (car (gimp-item-is-group (car top-layers))))
                (append all-layers (list (car top-layers)))
                (append all-layers (get-children (car top-layers)))) ))))
;
(define lists-menu 
                  '("All layers" 
                    "Linked Layers" 
					"Non-Linked Layers"
					))
;
(define actions-menu 
                  '("Set Invisible" 
                    "Set Visible"
					"Invert"
					"Clear Selection"
					"Layer to Image Size"
					"Semi-Flatten"
					"Flatten"
					"Add Alpha"
					"Remove Layers from Image"
					"Desaturate"
					"Colorify"
					"Color Balance(settings below)"
					"AutoCrop Layers"
					"Center All Layers"
					))
;					
(define (script-fu-multiple-layer-actions image drawable
                                               listType
							                   exclude
							                   sf-color
											   actionType
											   range
											   cyan-red 
											   magenta-green 
											   yellow-blue
											   preserve-lum 
							                   )	
				
	(gimp-image-undo-group-start image)						  

 (let* (
        
		(layerList 0)
		(lockList 0)
		(layerId 0)
        )
	

	
;;-------------------------------
;;set the pre-conditions
    (set! lockList (let loop ((layers (vector->list (cadr (gimp-image-get-layers image))))
                           (layerList '()) )
                  (if (null? layers)
                    (reverse layerList)
                    (loop (cdr layers)
                          (if (zero? (car (gimp-item-get-lock-content (car layers))))
                            layerList
                            (cons (car layers) lockList) )))))
							
	(map (lambda (x) (gimp-item-set-lock-content x FALSE)) lockList)

    (if (or (= actionType 5) (= actionType 6)) (gimp-context-set-background sf-color))
	(if (and (= actionType 8) (= listType 0)) (set! exclude TRUE))	
;;-----------------------------------------------------------------------
;;set the List Types	
	(cond
	((= listType 0) ;All Layers
	(set! layerList (get-all-real-layers image))
	(if (= exclude TRUE) (set! layerList (delq drawable layerList)))    ;remove the drawable from the 'layerList'
	) ;end All Layers
	
	((= listType 1) ;Linked Layers
	(set! layerList (let loop ((layers (get-all-real-layers image))
                           (layerList '()) )
                  (if (null? layers)
                    (reverse layerList)
                    (loop (cdr layers)
                          (if (zero? (car (gimp-drawable-get-linked (car layers))))
                            layerList
                            (cons (car layers) layerList) )))))
	(if (= exclude TRUE) (set! layerList (delq drawable layerList)))    ;remove the drawable from the 'layerList'
	) ;end Linked Layers
	
	((= listType 2) ;Non Linked Layers
	(set! layerList (let loop ((layers (get-all-real-layers image))
                           (layerList '()) )
                  (if (null? layers)
                    (reverse layerList)
                    (loop (cdr layers)
                          (if (not(zero? (car (gimp-drawable-get-linked (car layers)))))
                            layerList
                            (cons (car layers) layerList) )))))
	(if (= exclude TRUE) (set! layerList (delq drawable layerList)))    ;remove the drawable from the 'layerList'
	) ;end Non Linked Layers
	) ;endcond

;;--------------------------------------------------------------------------------------------------------------------
				
;;------------------------------------------------------------------------------------------------------------------------	
;;Actions to perform	
	(cond
    ((= actionType 0 ) (map (lambda (x) (gimp-drawable-set-visible x FALSE)) layerList))			
	((= actionType 1 ) (map (lambda (x) (gimp-drawable-set-visible x TRUE)) layerList))
	((= actionType 2 ) (map (lambda (x) (gimp-invert x)) layerList))
	((= actionType 3 ) (map (lambda (x) (gimp-edit-clear x)) layerList))
	((= actionType 4 ) (map (lambda (x) (gimp-layer-resize-to-image-size x)) layerList))
	((= actionType 5 ) (map (lambda (x) (plug-in-semiflatten 1 image x)) layerList))
	((= actionType 6 ) (map (lambda (x) (gimp-layer-flatten x)) layerList))
	((= actionType 7 ) (map (lambda (x) (gimp-layer-add-alpha x)) layerList))
	((= actionType 8 ) 
	(map (lambda (x) (gimp-image-remove-layer image x)) layerList)
	(set! layerList (vector->list (cadr (gimp-image-get-layers image))))
	(if (= exclude TRUE) (set! layerList (delq drawable layerList)))
	(cond 
	((= listType 0)
	(map (lambda (x) (gimp-image-remove-layer image x)) layerList))
	((> listType 0)
	(while (not (null? layerList))
          (set! layerId (car layerList))
		  (cond ((= (car (gimp-item-is-group layerId)) TRUE)
		  (if (= (car (gimp-item-get-children layerId)) 0) (gimp-image-remove-layer image layerId))))
		  (set! layerList (cdr layerList))))))
	((= actionType 9) (map (lambda (x) (gimp-desaturate x)) layerList))	
	((= actionType 10) (map (lambda (x) (plug-in-colorify 1 image x sf-color)) layerList))
	((= actionType 11) (map (lambda (x) (gimp-color-balance x range preserve-lum cyan-red magenta-green yellow-blue)) layerList))
	((= actionType 12) 
	(let* (
	(activeList layerList)
	(layerId 0)
	(visible 0)
	)
	(while (not (null? activeList))
          (set! layerId (car activeList))
		  (gimp-image-set-active-layer image layerId)
		  (set! visible (car (gimp-item-get-visible layerId))) 		  
		  (gimp-drawable-set-visible layerId TRUE)
		  (plug-in-autocrop-layer 1 image layerId)
		  (if (= visible FALSE) (begin 
		  (gimp-drawable-set-visible layerId FALSE))) 
		  (set! activeList (cdr activeList))
		  ) ;enwhile
		  ) ;end actionVariables		  
		  ) ;end actionType 12
	((= actionType 13)
	(let* (
	(activeList layerList)
	(img-width (car (gimp-image-width image)))
	(img-height (car (gimp-image-height image)))
	(width 0)
	(height 0) 
	(layerId 0)
	(offx 0)
    (offy 0)
	)
	      (while (not (null? activeList))
          (set! layerId (car activeList))
		  (set! width (car (gimp-drawable-width layerId)))
		  (set! height (car (gimp-drawable-height layerId)))
		  (set! offx (/ (- img-width width) 2))
          (set! offy (/ (- img-height height) 2))    
          (gimp-layer-set-offsets layerId offx offy)
		  (set! activeList (cdr activeList))
		  ) ;enwhile
		  ) ;end actionVariables		  
		  ) ;end actionType 13
	) ;end actions cond 
		
;;------------------------------------------------------------------------------------------------------	
;;reset pre-conditions
    (map (lambda (x) (gimp-item-set-lock-content x TRUE)) lockList)
;;---------------------------------------------------------------------------------------------------
	(gimp-displays-flush)
	(gimp-image-undo-group-end image);preserve-lum cyan-red magenta-green yellow-blue
	
 )
)

(script-fu-register "script-fu-multiple-layer-actions"        		    
  "Muliple Layer Actions..."
  "Set the type of Layers to Effect and wether to exclude the active Layer then the action you want done"
  "Graechan"
  "Graechan - http://gimpchat.com"
  "Feb 2015"
  "RGB*"
  SF-IMAGE      "image"      0
  SF-DRAWABLE   "drawable"   0
  SF-OPTION "Layers to Affect" lists-menu
  SF-TOGGLE     "Exclude Active Layer"    FALSE
  SF-COLOR "Effect Color 
  (Only used if Actions Semi-Flatten, Flatten or Colorify Chosen)" '(255 255 255)
  SF-OPTION "Actions" actions-menu
  SF-ENUM _"Select Range to Adjust" '("TransferMode" "midtones")
  SF-ADJUSTMENT _"cyan-red" '(0 -100 100 1 10 0 0)
  SF-ADJUSTMENT _"magenta-green" '(0 -100 100 1 10 0 0)
  SF-ADJUSTMENT _"yellow-blue" '(0 -100 100 1 10 0 0)
  SF-TOGGLE     _"Preserve luminosity "    TRUE
)

(script-fu-menu-register "script-fu-multiple-layer-actions" "<Image>/Layer/")


