#!/usr/bin/env python
# -*- coding: utf-8 -*-

import gimp, gimpplugin, math
pdb = gimp.pdb
import gtk, gimpui
import os, sys, gettext

def defIndex(arr,index,alt=None):
	if len(arr)>index:
		return arr[index]
	else:
		return alt

class drawUi(object):
	def __init__(self):
		self.ttips = gtk.Tooltips()
		pass

	def addTip(self, obj, tip):
		self.ttips.set_tip(obj,tip)
	
	def addRows(self, obj, table, col1,col2, row1,row2,cnn="",function=None):
		table.attach(obj, col1, col2, row1, row2)
		obj.show()
		if cnn!="": obj.connect(cnn, function)
		return obj

	def addObjs(self, arrobj, table):
		objs=[]
		for data in arrobj:
			if type(data) is list:
				obj=data[0]
				if type(obj) is str or type(obj) is unicode:
					obj=self.addLabel(obj)
				col1=defIndex(data,1)
				col2=defIndex(data,2)
				row1=defIndex(data,3)
				row2=defIndex(data,4)
				cnn =defIndex(data,5,'')
				fn  =defIndex(data,6)
				objs.append(self.addRows(obj, table, col1,col2, row1,row2,cnn,fn))
			if type(data) is int:
				objs.append(data)
		return objs

	def addProps(self,obj,props):
		for Key,Value in props:
			obj.set_property(Key, Value)

	def addLabel(self,tx,alignx=1.0,aligny=0.5):
		lb = gtk.Label(tx)
		lb.set_alignment(alignx,aligny)
		return lb
	
	def fillCombo(self, Store, combobox):
		st = combobox.get_model()
		st.clear()
		for n in Store: st.append(n)
		combobox.set_model(st)
		combobox.set_active(0)
	
	def fillCombo2(self, Store, combobox):
		st = combobox.get_model()
		st.clear()
		for n in Store: st.append([Store[n]['tit'],n])
		combobox.set_model(st)
		combobox.set_active(0)
	
	def makeCombo(self, Store):
		st = gtk.ListStore(str, int)
		self.cmb = gtk.ComboBox(st)
		cell = gtk.CellRendererText()
		self.fillCombo(Store,self.cmb)
		self.cmb.pack_start(cell, True)
		self.cmb.add_attribute(cell, 'text', 0)
		self.cmb.set_active(0)
		return self.cmb

	def makeCombo2(self, Store):
		st = gtk.ListStore(str, str)
		self.cmb = gtk.ComboBox(st)
		cell = gtk.CellRendererText()
		self.fillCombo2(Store,self.cmb)
		self.cmb.pack_start(cell, True)
		self.cmb.add_attribute(cell, 'text', 0)
		self.cmb.set_active(0)
		return self.cmb

	def table(self, rows=1, columns=1, homogeneous=False, row_s=2,col_s=2):
		tab= gtk.Table(rows,columns, homogeneous)
		tab.set_row_spacings(row_s)
		tab.set_col_spacings(col_s)
		tab.show()
		return tab

	def getValues(self,arrFields):
		return (n.get_value() for n in arrFields)
	
	def getModelVal(self, widget):
		iter = widget.get_active_iter()
		model = widget.get_model()
		lP = model.get_value(iter,1)
		return lP
