#!/usr/bin/env python
# -*- coding: utf-8 -*-

import gimp, gimpplugin, math
from gimpenums import *
pdb = gimp.pdb
import gtk, gimpui

import os, sys, gettext, imp

thisPth = os.path.dirname(sys.argv[0]) + os.sep
drawUI = imp.load_source('drawUI', thisPth + 'drawUI.py')
gettext.install("arakne-guide-lab", thisPth + 'locales', unicode=True)

def debug(val):
	gimp.message(str(val))

def Between(Num,Max):
	if Num < 0: return 0
	if Num > Max: return Max
	return Num

def debugErr(e):
	exc_type, exc_obj, exc_tb = sys.exc_info()
	fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
	debug(fname+'\n'+str(exc_tb.tb_lineno)+'\n'+str(e))

class gLabUtls(object):
	titDel=_("Delete")
	newG=_("Add new")
	tabs=[]
	ui = drawUI.drawUi()
	tabTits     = [_('Add/Edit'),_('Help')]
	tipPos      = _("Position of the current guide, double click on the value to edit")
	tipPrev     = _("Distance between this guide and the previous. If this guide is the 1st then this will be the distance to the start of the image.")
	tipNext     = _("Distance between this guide and the next. If this guide is the last then this will be distance to the end of the image.")
	tipDel      = _("Double click to delete the current guide.")
	newGuideTip = _("Write the position for the new guide\nLook what operations and replacements you can use in the help tab")
	
	REPEAT = [[_('None'),0],[_('Mirror'),1],[_('Perimeter'),2]]
	newAt = _('New guide at')
	addOpposite = _("Add an aditional guide on the oposite side")
	measures = [['px',0],['%',1],['cm',2],['mm',3],['in',4]]

	def __init__(self, runmode, img):
		self.img = img
		if runmode == RUN_INTERACTIVE:
			self.showDialog()
		elif runmode == RUN_WITH_LAST_VALS:
			self.showDialog()
		elif runmode == RUN_NONINTERACTIVE:
			return

	def tabHelp(self, tab):
		row = 0
		msgs = [
			_("Double click on the <b>Delete</b> cell for delete the guide.")+"\n",
			_("Use negative values to add guides on the oposite side.")+"\n",
			"<b>"+_("In the text fields you can use the following shortcuts:")+"</b>",
			_("<b>Width</b>, <b>width</b>, <b>W</b> or <b>w</b>:\n\tReplaced by the width of the current selected image"),
			_("<b>Height</b>, <b>height</b>, <b>H</b> or <b>h</b>:\n\tReplaced by the height of the current selected image")+"\n",
			"<b>"+_("SAMPLES OF USAGE:")+"</b>",
			"\t"+_("For add a guide on the vertical center:")+"<span foreground='blue' background='white'> <tt>h/2</tt> </span>",
			"\t"+_("For add a guide at 10 pixels of the bottom:")+"<span foreground='blue' background='white'> <tt>H-10</tt></span>",
			"\t"+_("For add a guide at 10 pixels of the center")+":<span foreground='blue' background='white'>  <tt>height/2+10</tt></span>"
		]
		tx=""
		for line in msgs:
			tx += line+"\n"
		lb = self.ui.addRows(self.ui.addLabel(tx,0,0),tab, 2, 4, row, row+1)
		lb.set_use_markup(True)

	def parseVal(self,val):
		s = val
		if s == self.newG: s = '0'
		for nn in ['Width','width','W','w']:   s = s.replace(nn,str(self.img.width))
		for nn in ['Height','height','H','h']: s = s.replace(nn,str(self.img.height))
		return eval(s)

	def guideExists(self, v, direction):
		i = self.img
		g = i.find_next_guide(0)
		dir = 0 if direction == 'h' else 1
		while (g > 0):
			if i.get_guide_orientation(g)==dir:
				pos = i.get_guide_position(g)
				if pos == v: return True
			g = i.find_next_guide(g)
		return False

	def addG(self, v, hv):
		v = int(v)
		if self.guideExists(v, hv): return
		if hv == 'h' :
			hid = self.img.add_hguide(v)
			tree = self.tsH
		else :
			hid = self.img.add_vguide(v)
			tree = self.tsV
		tree.append([v, hid, 0, 0, 0, 0, 0])
		self.printNext(tree)

	def toPX(self, unit, v, hw):
		#['px',0],['%',1],['cm',2],['mm',3],['pt',4]
		res = pdb.gimp_image_get_resolution(self.img)[0]
		if unit==1: v = hw / 100.0 * v # ##############
		if unit==2: v = int( v / 2.54 * res )
		if unit==3: v = int( v / 25.4 * res )
		if unit==4: v = int( v * res )
		if v < 0.0 :  v = hw + v # ################
		return v

	def addH(self, widget):
		val, h, w, unit = (float(self.parseVal(self.newH.get_text())), self.img.height, self.img.width, self.newHunit.get_active())
		v = self.toPX(unit, val, h)
		self.addG(Between(v,h),'h')
		repli = self.cbH.get_active()
		if repli > 0:
			center = h / 2.0
			if v != center: self.addG(Between(h - v,h),'h')
		if repli == 2:
			val = self.toPX(unit, abs(val), w)
			self.addG(Between(val,     w),'v')
			self.addG(Between(w - val, w),'v')

	def addV(self, widget):
		val, w, h, unit = (float(self.parseVal(self.newV.get_text())), self.img.width, self.img.height, self.newVunit.get_active())
		v = self.toPX(unit, val, w)
		self.addG(Between(v,w),'v')
		repli = self.cbV.get_active()
		if repli > 0:
			center = w / 2.0
			if v != center: self.addG(Between(w - v,w),'v')
		if repli==2:
			val = self.toPX(unit, abs(val), h)
			self.addG(Between(val,     h),'h')
			self.addG(Between(h - val, h),'h')

	def evalSpin(self, widget, data=None):
		widget.set_value(self.parseVal(widget.get_text()))

	def onEditGuide(self, widget, path, value, treeSt, name):
		v = int(self.parseVal(value))
		ts = treeSt
		if int(ts[path][0]) == int(v): return
		self.img.delete_guide(ts[path][1])
		if name == "h":
			hid = self.img.add_hguide(min(v, self.img.height))
		else:
			hid = self.img.add_vguide(min(v, self.img.width))
		ts[path][1] = hid
		ts[path][0] = v
		self.printNext(ts)

	def printNext(self,ts):
		if len(ts)==0 : return
		iH, iW = (self.img.height, self.img.width)
		res = pdb.gimp_image_get_resolution(self.img)[0]
		ts.set_sort_column_id (0, gtk.SORT_ASCENDING)
		name = ts.get_name()
		for n in range(0,len(ts)):
			ts[n][2] = round((100.0 / (iH if name == "ts_h" else iW)) * ts[n][0],2)
			ts[n][3] = round(ts[n][0] * 25.4 / res ,2)
			ts[n][4] = round(ts[n][0] * 2.54 / res ,2)
			ts[n][5] = round(ts[n][0] / res ,2)

	def delGuide(self, widget, row, col):
		tit = col.get_title()
		treeSt = widget.get_model()
		if tit == self.titDel:
			id, gPos, i = (treeSt[row][1],treeSt[row][0], self.img)
			# comprobar que existe, puede haber sido borrada manualmente
			dir = 0 if treeSt.get_name()=='ts_h' else 1
			g = i.find_next_guide(0)
			existe = False
			while (g > 0):
				if (i.get_guide_orientation(g) == dir and i.get_guide_position(g) == gPos):
					existe = True
					break
				g = i.find_next_guide(g)
			if existe==True: self.img.delete_guide(id)
			for fila in treeSt:
				if fila[1] == id:
					treeSt.remove(fila.iter)
					self.printNext(treeSt)
					break

	def addObj(self, obj, props, show=False):
		o = obj
		for n in props:
			o.set_property(n,props[n])
		if show==True:
			o.show()
		return o

	def addCol(self,tv,title,renderer,pos,postx,tip,sortCol=None):
		col = gtk.TreeViewColumn(title, renderer, text=postx)
		label = gtk.Label(title)
		col.set_widget(label)
		label.show()
		self.ui.addTip(label, tip)
		tv.insert_column(col, pos)
		if sortCol != None : col.set_sort_column_id(sortCol)

	def addTV(self,name):
		tS = gtk.ListStore(int,int,str,str,str,str,float)
		tS.set_name("ts_"+name)
		tv = self.addObj(gtk.TreeView(tS),{"name":name, "rules-hint":True, "show-expanders":False},True)
		rendImg = self.addObj(gtk.CellRendererPixbuf(),{'stock-id':gtk.STOCK_DELETE})
		rendSpin = gtk.CellRendererSpin()
		rendSpin.connect("edited", self.onEditGuide, tS, name)
		maxVal=self.img.height if name=='h' else self.img.width
		self.ui.addProps(rendSpin,[("editable",True),("adjustment",gtk.Adjustment(0,0,maxVal,1,10,0))])
		rendTx = self.addObj(gtk.CellRendererText(),{"editable":False})
		self.addCol(tv,"px",rendSpin,0,0, self.tipPos,0)
		self.addCol(tv,"%", rendTx,  1,2, self.tipPrev)
		self.addCol(tv,"mm",rendTx,  2,3, self.tipNext)
		self.addCol(tv,"cm",rendTx,  3,4, self.tipNext)
		self.addCol(tv,"in",rendTx,  4,5, self.tipNext)
		self.addCol(tv,self.titDel,rendImg,5,-1,self.tipDel)
		tv.set_grid_lines(gtk.TREE_VIEW_GRID_LINES_BOTH)
		tv.connect('row-activated',self.delGuide)
		selection = tv.get_selection()
		selection.set_mode(gtk.SELECTION_SINGLE)
		sW = self.addObj(gtk.ScrolledWindow(hadjustment=None, vadjustment=None),{"shadow-type":gtk.SHADOW_ETCHED_IN,"vscrollbar-policy":gtk.POLICY_AUTOMATIC,"hscrollbar-policy":gtk.POLICY_AUTOMATIC})
		sW.add(tv)
		#tv.show()
		sW.show()
		return (tS,tv,sW)
	
	def getGuides(self, widget=None):
		i=self.img
		lH=[]
		lV=[]
		TSs = [self.tsH, self.tsV]
		for n in TSs: n.clear()
		g = i.find_next_guide(0)
		while (g>0):
			lst = lH if i.get_guide_orientation(g)==0 else lV
			lst.append([i.get_guide_position(g),g,0,0,0,0,0])
			g = i.find_next_guide(g)
		lH.sort(key=lambda tup: tup[0])
		lV.sort(key=lambda tup: tup[0])
		for n in lH: self.tsH.append(n)
		for n in lV: self.tsV.append(n)
		for n in TSs: self.printNext(n)

	def delGuides(self,widget=None):
		i = self.img
		all = []
		g = i.find_next_guide(0)
		while (g>0):
			all.append(g)
			g = i.find_next_guide(g)
		for i in reversed(all): self.img.delete_guide(i)
		self.getGuides()

	def tt(self,w, data=None):
		s = w.get_text()
		v = self.parseVal(s)
		w.set_value(v)

	def tabOne(self):
		try:
			row = 0
			tab0 = self.tabs[0]
			self.ui.addRows(self.ui.addLabel(_(' H \n O \n R \n I \n Z \n O \n N \n T\n A \n L ')), tab0, 0, 1, row, row+1)
			self.ui.addRows(self.ui.addLabel(_(' V \n E \n R \n T \n I \n C \n A \n L ')),          tab0, 5, 6, row, row+1)

			self.tsH, tvh, sWh = self.addTV('h')
			self.tsV, tvv, sWv = self.addTV('v')
			self.ui.addRows(sWh, tab0, 1, 5 , row, row + 1)
			self.ui.addRows(sWv, tab0, 6, 10, row, row + 1)
			row += 1
			# horizontal
			self.ui.addRows(self.ui.addLabel(self.newAt), tab0, 1, 2, row, row+1)
			self.newH = self.ui.addRows(gtk.SpinButton(gtk.Adjustment(0, -self.img.height, self.img.height, 1), 0.0, 2), tab0, 2, 3, row, row+1,"activate",self.evalSpin)
			self.newH.connect("focus-out-event", self.tt)
			self.newHunit=self.ui.addRows(self.ui.makeCombo(self.measures), tab0, 3, 4, row, row+1)
			self.ui.addTip(self.newH, self.newGuideTip)

			self.ui.addRows(self.ui.addLabel("Replicate"), tab0, 1, 2, row+1, row+2)
			self.cbH=self.ui.addRows(self.ui.makeCombo(self.REPEAT), tab0, 2, 4, row+1, row+2)
			self.newHB=self.ui.addRows(gtk.Button('',gtk.STOCK_ADD), tab0, 4, 5, row, row+2, "clicked", self.addH)

			self.ui.addRows(self.ui.addLabel(self.newAt), tab0, 6, 7, row, row+1)
			self.newV = self.ui.addRows(gtk.SpinButton(gtk.Adjustment(0, -self.img.width, self.img.width, 1), 0.0, 2), tab0, 7, 8, row, row+1,"activate",self.evalSpin)
			self.newV.connect("focus-out-event",self.tt)
			self.newVunit = self.ui.addRows(self.ui.makeCombo(self.measures), tab0, 8, 9, row, row+1)

			self.ui.addRows(self.ui.addLabel("Replicate"), tab0, 6, 7, row+1, row+2)
			self.cbV=self.ui.addRows(self.ui.makeCombo(self.REPEAT), tab0, 7, 9, row+1, row+2)
			self.newVB=self.ui.addRows(gtk.Button('',gtk.STOCK_ADD), tab0, 9, 10, row, row+2,"clicked",self.addV)
			row += 2
			self.getGuides()
			self.ui.addRows(gtk.Button(_('Update manual changes')), tab0, 1, 5, row, row+1,'clicked',self.getGuides)
			self.ui.addRows(gtk.Button(_('Delete all guides')), tab0, 6, 10, row, row+1,'clicked',self.delGuides)
		except Exception,e:
			debug(e)

	def addRbGroup(self,table,rbs):
		grp=0
		for n in rbs:
			grp=None if grp==0 else rb
			rb = self.ui.addRows(gtk.RadioButton(grp,n['label']),table,n['col1'],n['col2'],n['row1'], n['row2'])

	def showDialog(self):
		self.dialog = gimpui.Dialog("Guide lab", "rotdlg")
		self.dialog.set_position(gtk.WIN_POS_CENTER)
		self.table = self.addObj(gtk.Table(3, 1, False),{"homogeneous":False, "column-spacing":1, "row-spacing":1 }, True)
		self.nB = gtk.Notebook()
		self.ui.addRows(self.nB, self.table, 0, 1, 0, 1)
		for n in range(0,len(self.tabTits)):
			t = self.addObj(gtk.Table(6, 2, False),{"homogeneous":False, "column-spacing":2,"row-spacing":1}, True)
			self.tabs.append(t)
			self.nB.append_page(self.tabs[n], gtk.Label(self.tabTits[n]))
		self.tabOne()
		self.tabHelp(self.tabs[1])
		self.dialog.vbox.hbox1 = gtk.HBox(False, 1)
		self.dialog.vbox.hbox1.show()
		self.dialog.vbox.pack_start(self.dialog.vbox.hbox1, True, True, 1)
		self.dialog.vbox.hbox1.pack_start(self.table, True, True, 1)
		cancel_button = self.dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
		cancel_button.connect("clicked", self.kobtn)
		self.dialog.connect("expose-event",self.expose)
		self.dialog.show()
		self.dialog.set_keep_above(True)
		self.dialog.run()
	
	def expose(self,widget, otro):
		return
	
	def createGuides(self):
		self.range.connect('clicked',self.createGuides)

	def kobtn(self, widget):
		return

class arakneguideLab(gimpplugin.plugin):
	def start(self):
		gimp.main(self.init, self.quit, self.query, self._run)
	def init(self):
		pass
	def quit(self):
		pass
	def query(self):
		cright = "jfgarcia"
		date = "2013-2018"
		plug_descr = _("Admin")
		plug_params = [(PDB_INT32, "run_mode", "Run mode"), (PDB_IMAGE, "image", "Input image"),]
		gimp.install_procedure("arakne_guide_lab", plug_descr, plug_descr, "jfgarcia", cright, date, "<Image>/Image/Guides/Guides lab...", "RGB*, GRAY*", PLUGIN, plug_params,[])

	def arakne_guide_lab(self, runmode, img):
		gLabUtls(runmode, img)

if __name__ == '__main__':
	arakneguideLab().start()
#308 393 369