#!/usr/bin/env python
# -*- coding: utf-8 -*-


# Open Source fx_stencil 0.1,30,100,5,0,0,0,50,50

# License: GPLv3
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# To view a copy of the GNU General Public License
# visit: http://www.gnu.org/licenses/gpl.html


# About Autotrace older version: Plugin-autotrace.py https://www.gimpscripts.net/2020/09/plugin-autotracepy-ver-05.html
# Live Preview (gtk2) according to the idea of Tin Tran http://gimpchat.com/viewtopic.php?f=9&t=9586#p284974
# ------------
#  Change Log 
# ------------
# Rel 1.0: /23-02-2024/ Initial release 
# Rel 1.1: /24-02-2024/ added: procedure pdb.gimp_image_resize_to_layers(image) - useful when layers have different sizes and also the ability to save an svg file under a selected name has been restored.
# Rel 1.2: /26-02-2024/ change GUI, fix bug related to using "Cancel" button when plugin was not used.
# Rel 1.3: /29-02-2024/ change: Replace transparency (if alpha channel exists) to BG color (on added copy).
# Rel 1.4: /02-03-2024/ added Ignore (remove) color option

from gimpfu import *
import gtk, gimpui
gimpui.gimp_ui_init ()  # add MrQ

import subprocess
import sys, os, gettext


def sys_file(f_name):
  sys_encoded = sys.getfilesystemencoding()
  if os.name == 'nt': coded = f_name.encode(sys_encoded)
  else: coded = f_name
  return(coded)
  
whoiam = os.path.abspath(sys.argv[0])
# initialize internationalisation in a user-locale (by rob_brz1)
locale_directory = os.path.join(os.path.dirname(whoiam), 'locale')
gettext.install( "plugin-autotrace", locale_directory, unicode=True )

def rgb_to_hex(rgb_color):
  r = rgb_color[0]
  g = rgb_color[1]
  b = rgb_color[2]
  return '%02x%02x%02x' % (r,g,b)

def colorArg(colorR):
  if colorR==1:
    return " --background-color 000000"
    #return " --background-color " + str(colorParam)
  else:
    return " " 
def colorcountArgs(colorcountParam):
  '''
  Color count must be reduced from 1-256.
  Value 0 means 256 to autotrace.  It does NOT mean: don't reduce colors!!!.
  IE autotrace uses 8-bit color and must reduce color to that range.
  I decided not to futz with recoding 256 to zero.
  The user only sees 1-255.
  1 doesn't always make sense (outlines with 1 color?), but works.
  '''
  return " --color-count " + str(colorcountParam) + " "

def tracetypeArgs(tracetypeParam):
  '''
  User choice of type of tracing (outline and centerline).
  !!! Note that preserve-width is NOT a parameter of centerline tracing, as some docs suggest:
  --centerline --preserve-width --width-weight-factor 8.0 " # trace varying width centerline
  '''
  if tracetypeParam == 1:
    return "--centerline " # trace thin centerline
  else:
    return " "  # autotrace defaults to trace outline

def despeckleArgs(despeckleParam):
  '''
  Note autotrace enforces range 1-20 on despeckle-level, 0.0-8.0 on despeckle-tightness.
  
  Note despeckle-level is NOT a radius, but the power of 2 for the speckle size:
  1 gives some size block (say 2) and 2 gives twice as many pixels (say 4)
  and 3 gives twice again (say 8).
  See despeckle.c: despeckle() in autotrace package.
  
  !!! Most importantly, despeckle-level and despeckle-tightness are coupled.
  Level stipulates the size of feature.
  Level and tightness stipulate the color difference of features.
  Color difference to despeckle = 256/(1+ tightness*level.)
  Note below that level increases but tightness increases then decreases
  because it multiplies level.
  
  Tightness 0 means that every color difference can be despeckled,
  ie a black speckle can go to white (difference of 256).
  '''
  if despeckleParam == 0:   # Less: 2**3 = 8 pixels = 3 pixel diameter
    return "--despeckle-level 3 --despeckle-tightness 0.0 "
  elif despeckleParam == 1: # Moderate: 2**5 = 32 pixels = 6 pixel diameter
    return "--despeckle-level 5 --despeckle-tightness 2.0 "  
  else:                     # Most: 2**8 = 256 pixels = 16 pixel diameter
    return "--despeckle-level 8 --despeckle-tightness 0.0 "

def smoothingArgs(smoothingParam):
  params = " --remove-adjacent-corners " + "--corner-threshold " + str(smoothingParam)
  return params
  
'''
These are unadulterated autotrace parameters.
Experiments show that these are mostly useless or hard to use.
'''
def cornersArgs(cornerthresholdParam):
  '''
  Always remove adjacent corners.
  I assume that the alternative is only useful for rare cases.
  TBD understand the other parameters and use them if defaults are not appropriate.
  '''
  return "--corner-threshold " + str(cornerthresholdParam) + " --remove-adjacent-corners "

def fittingArgs(fittingParam):
  '''
  The args that affect fitting of splines.
  
  This is the param that determines when a fitted spline is close enough.
  A float, in pixel units, of the max orthogonal distance between fitted spline and original curve.
  TBD other parameters for this.
  '''
  return "--error-threshold " + str(fittingParam) + " "

def iterationArgs(iterationParam):
  '''
  Smoothing iterations before spline fitting.
  Smoothing is done in the pixel domain??
  '''
  return "--filter-iterations " + str(iterationParam) + " "


def autotrace_LP(image, layer, filename, colorR,reduce, colorcountParam,
     tracetypeParam, despeckleParam, smoothingParam, pathParam, ege_w, ege_c, bg):  # , fittingParam, iterationParam):
	 

  colorParam = rgb_to_hex(reduce)	
  #pdb.gimp_image_resize_to_layers(image)
  pdb.gimp_layer_resize_to_image_size(layer)
  #pdb.gimp_image_resize_to_layers(image)	
  pdb.gimp_image_set_active_layer(image, layer)
  
  outputFolder=gimp.directory + os.sep + "tmp"
	
  if os.access(sys_file(outputFolder), os.W_OK): 

    tempfilename = outputFolder + os.sep + filename + ".bmp"

    tempsvgfilename = outputFolder + os.sep + filename + ".svg"

  # Save in temporary.  Note: empty user entered file name
 
  tempdrawable = pdb.gimp_image_get_active_drawable(image)
  
  pdb.gimp_progress_set_text ("Saving a copy")
  layer.name = layer.name.decode("utf-8")
 
  #empsvgfilename = pdb.gimp_temp_name("svg")    
  #if saveas==0:
 
  xchange_utf = tempfilename
  pdb.file_bmp_save2(image, tempdrawable, xchange_utf, xchange_utf,0, 1,1)
	
  '''
  Open the temporary svg file.  
  1) to catch possible os errors early
  2) to redirect stdout of the command to this file descriptor
  '''
  try:
    outfile = open(tempsvgfilename, 'w')
  except:
    raise RuntimeError, "Could not open temporary svg file: " + tempsvgfilename
    
  '''
  Cat command string for autotrace.
  Autotrace out defaults to stdout, we later connect stdout to outfile
  (instead of using an arg to autotrace -output-file foo).
  !!! Note spaces are important, between args and before file name
  '''
  xchange_sys = sys_file(xchange_utf)
  
  if os.name == 'nt':
    binDir="autotrace.exe"
  else:
    binDir="/usr/bin/autotrace"
	
  command = binDir \
  + colorArg(colorR) \
  + colorcountArgs(colorcountParam) \
  + tracetypeArgs(tracetypeParam) \
  + despeckleArgs(despeckleParam) \
  + smoothingArgs(smoothingParam) \
  + " " + "-output-format svg -output-file" \
  + " " + tempsvgfilename \
  + " " + xchange_sys

  print command, tempsvgfilename
  
  '''
  Invoke autotrace.
  Child process proceeds independently. Then wait for its completion, so we can kill it if it hangs.
  autotrace can hang if user enters parameters too aggressive (eg many colors, fine grained tracing)
  shell=False : we don't need shell (filename globbing or redirection) but args are a sequence, not a string
  shell=True: use a string
  '''
  pdb.gimp_progress_set_text ("Tracing")
  pdb.gimp_progress_pulse()

  child = subprocess.Popen(command, shell=True, stdout=outfile)
  child.communicate() # wait for child to terminate

  '''
  Limitation of gimp: seems to hang on importing thousands of paths from large SVG.  See Bugzilla 604175.
  So rather than hang Gimp, preclude user from continuing if SVG file too large
  AND user wants to import paths.
  '''
  if os.path.getsize(tempsvgfilename) > 600100 and pathParam == 1:  
    # Magic number, wag for file size as of 2009, my computer, etc.
    pdb.gimp_message("Trace plugin error: SVG file has too many individual paths to import.")
    return  # Leaves files in gimp/tmp, to get cleaned later
    
  resolutionx, resolutiony = pdb.gimp_image_get_resolution(image) # Same resolution as original

  pdb.gimp_progress_set_text ("Rendering")
	
  #active_layer.name = active_layer.name.replace("Wyrenderowany plik SVG", filename)
  if pathParam==1:
      trace=pdb.gimp_vectors_import_from_file(image, tempsvgfilename, 0, 1) #, run_mode=RUN_INTERACTIVE)
  if pathParam==2:	  
      trace=pdb.gimp_vectors_import_from_file(image, tempsvgfilename, 1, 1)	  
  trace=pdb.gimp_file_load_layer(image, tempsvgfilename)
  pdb.gimp_image_insert_layer(image, trace, None, 0)
  
  trace.name = "Autotrace"
   
  image.vectors[0].name= "Autotrace"	
  #active_layer = pdb.gimp_image_get_active_layer(image)
  #trace.name = trace.name.replace(_("Autotrace.svg"), "Autotrace")  
  pdb.gimp_displays_flush()
  #if rem_bmp==1:
  os.remove(xchange_utf)
	 

  if ege_w == 0:	
    for vector in image.vectors:
      pdb.gimp_vectors_set_visible(vector, True)

  if ege_w > 0:
	
    pdb.gimp_context_set_stroke_method(0) 
    pdb.gimp_context_set_line_width(ege_w)
    pdb.gimp_context_set_foreground(ege_c)
    pdb.gimp_drawable_edit_stroke_item(trace, image.vectors[0])  
  
  #gimp.Display(svgimage)
  gimp.displays_flush()


###########################################################################################################################################################
###########################################################################################################################################################

pattern_ = "filename" 
proceed_with_changes = False
proceed_with_changes_c = False
image = 0 #we'll set these when dialog() is called so that we can access them later
drawable = 0
has_preview = False
preview_layer = 0

global_param1 = 5 # colorcountParam
global_param3 = 100
global_param7 = 0

ege_c=0
bg=0
reduce=0

def apply_effect(layer): #function to do work on either preview layer or actual drawable when user clicks OK
    global image


    colorcountParam = global_param1
    ege_w = global_param7
    colorR=proceed_with_changes_c

    for layer in image.layers:
        if layer.name=="Copy for flaten":
            pdb.gimp_image_remove_layer(image,pdb.gimp_image_get_layer_by_name(image,"Copy for flaten"))	
	
    for layer in image.layers:
        if layer.name=="Autotrace":
            pdb.gimp_image_remove_layer(image,pdb.gimp_image_get_layer_by_name(image,"Autotrace"))	
    for vector in image.vectors:
        if vector.name=="Autotrace":
            pdb.gimp_image_remove_vectors(image,pdb.gimp_image_get_vectors_by_name(image,"Autotrace"))
		
    active_layer = pdb.gimp_image_get_active_layer(image)
    pdb.gimp_image_raise_layer_to_top(image, active_layer)	
    pdb.gimp_image_resize_to_layers(image)
    pdb.gimp_layer_resize_to_image_size(active_layer)
    if selected_option== "Outlines" :
        tracetypeParam=0	
    if selected_option== "Centerlines" :
        tracetypeParam=1
		
    if selected_option_2== "Speckly" :
        despeckleParam=0	
    if selected_option_2== "Some Despeckling" :
        despeckleParam=1
    if selected_option_2== "More Despeckling" :
        despeckleParam=2
		
    if pdb.gimp_drawable_has_alpha(layer)==1:
        pdb.gimp_context_set_background(bg)  
        tempdrawable = pdb.gimp_layer_copy(active_layer, 0)

        pdb.gimp_image_insert_layer(image, tempdrawable, None, -1)
        pdb.gimp_layer_resize_to_image_size(tempdrawable)		
        tempdrawable.name = "Copy for flaten"		
        pdb.gimp_layer_flatten(tempdrawable)
        active_layer = tempdrawable		
    if proceed_with_changes == 1:
        autotrace_LP(image, active_layer, str(pattern_),  colorR, reduce, global_param1, tracetypeParam, despeckleParam, global_param3, 2, global_param7, ege_c, bg)
    #autotrace_LP(image, layer, filename, colorcountParam, tracetypeParam, despeckleParam, smoothingParam, pathParam,stroke, vis)

    if colorR==1:
        for layer in image.layers:
            #pdb.gimp_image_set_active_layer(img,layer)
            pdb.gimp_item_set_visible(layer, 0)
        pdb.gimp_item_set_visible(image.layers[0], 1)
	
    pdb.gimp_displays_flush()
def apply_final(layer): #wrapper to apply effect on final and remove preview_layer meant to be called by on_ok_button_clicked

    gimp.displays_flush()

# Function to update the live preview
		
def update_live_preview(): #this is called everytime some parameter changes
    global  global_param1, global_param2, global_param3, global_param4, global_param5, global_param6, global_param7, global_param8, global_param9
    global image,drawable, vector
    global has_preview,preview_layer #deal with preview layer
 
    if proceed_with_changes==1:
       apply_effect(image.layers[0])
    else: pass	
	
    gimp.displays_flush()	

   
def dialog(image_, drawable_):
    global image, drawable
    #save these for updates
    image = image_
    #pdb.gimp_image_undo_disable(image) #for speed and also when user undo it doesn't see our preview creations/deletions
    drawable = drawable_ 

    dialog = gtk.Dialog("Autotrace with Live Preview. Ver.1.4.", None, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT)
    dialog.set_default_size(300, 100)
    if ege_c==0:
        global ege_c
        ege_c = (30,30,230)  # Set default color
    if bg==0:
        global bg
        bg = (255,255,255)  # Set default color
		
    if reduce==0:
        global reduce
        reduce = (0,0,0)  # Set default color			
    #------------------------------------------------------------
	
    hbox100 = gtk.HBox()
    dialog.vbox.pack_start(hbox100, expand=True, fill=True)
    pattern_label = gtk.Label("     Create new layer from active layer with fewer colors\n   and outline or centerline paths. Requires autotrace file\n       which must be installed in the bin Gimp directory.\n SvG file (for name do not use spaces & special characters)\n      is saved in your home directory in the 'tmp' folder.\n Changes transparency (alpha) to BG color (on added copy)\n")	
    hbox100.pack_start(pattern_label, expand=True, fill=True, padding=1)
	
    #-------------------------------------------------------------

    hbox40 = gtk.HBox()
    dialog.vbox.pack_start(hbox40, expand=False, fill=False)
    pattern_label = gtk.Label("          Name SVG file:                              Ignored color?")	
    hbox40.pack_start(pattern_label, expand=False, fill=False, padding=1)
	
    #------------------------------------------------------------

    hbox5 = gtk.HBox()
    dialog.vbox.pack_start(hbox5, expand=True, fill=True)

    # Create a label for the integer input
    label5 = gtk.Label("")
    hbox5.pack_start(label5, expand=False, fill=False, padding=5)

    # Create a text entry for the integer input
    entry5 = gtk.Entry()
    entry5.set_text("filename")
    entry5.set_width_chars(20)  # Adjust the width of input box as needed
    entry5.connect("changed", on_pattern_changed)
    hbox5.pack_start(entry5, expand=False, fill=False, padding=5)
	
    #------------------------------------------------------------

    hbox40 = gtk.HBox()
    dialog.vbox.pack_start(hbox40, expand=True, fill=True)
    pattern_label = gtk.Label("Reduce color count to:")	
    hbox40.pack_start(pattern_label, expand=True, fill=True, padding=1)
	
    #-------------------------------------------------------------	

    hbox40 = gtk.HBox()
    dialog.vbox.pack_start(hbox40, expand=True, fill=True)
    pattern_label = gtk.Label("     ")	
    hbox5.pack_start(pattern_label, expand=True, fill=True, padding=1)
	
    #-------------------------------------------------------------
	
    toggle_button = gtk.ToggleButton()
    #dialog.action_area.add(toggle_button)	
    update_toggle_button_label_c(toggle_button)
    toggle_button.connect("toggled", on_toggle_button_toggled_c)
    hbox5.pack_start(toggle_button, expand=False, fill=False, padding=5) 

    #-------------------------------------------------------------
	
    # Create a label for the color picker
    labe25 = gtk.Label("")
    hbox5.pack_start(labe25, expand=False, fill=False, padding=1)

    # Create a color picker button
    color_button = gtk.ColorButton()
    color_button.set_use_alpha(False)  # Set to True if you want to include alpha channel
    color_button.set_color(gtk.gdk.Color(reduce[0]*256, reduce[1]*256, reduce[2]*256))
    color_button.connect("color-set", on_color_changed_r)
    hbox5.pack_start(color_button, expand=False, fill=False, padding=5)	
	
    #------------------------------------------------------------
	
    hbox1 = gtk.HBox()
    dialog.vbox.pack_start(hbox1, expand=True, fill=True)
    label1 = gtk.Label("")
    hbox1.pack_start(label1, expand=False, fill=False, padding=5)
    adjustment1 = gtk.Adjustment(value=5, lower=2, upper=255, step_incr=1, page_incr=0)
    param1_scale = gtk.HScale(adjustment=adjustment1)
    param1_scale.set_digits(0)  # Display only integers
    hbox1.pack_start(param1_scale, expand=True, fill=True, padding=5)
    label1 = gtk.SpinButton(adjustment1,0, 0 )
    hbox1.pack_start(label1, expand=False, fill=False, padding=5)
    param1_scale.set_update_policy(gtk.UPDATE_DISCONTINUOUS) ######	
    param1_scale.connect("value-changed", on_param1_changed)

    #-------------------------------------------------------------

    hbox40 = gtk.HBox()
    dialog.vbox.pack_start(hbox40, expand=False, fill=False)
    pattern_label = gtk.Label("              Trace:                           Despeckling: ")	
    hbox40.pack_start(pattern_label, expand=False, fill=False, padding=1)
	
    #-------------------------------------------------------------
	
    hbox10 = gtk.HBox()
    dialog.vbox.pack_start(hbox10, expand=True, fill=True)
    label10 = gtk.Label("")
    hbox10.pack_start(label10, expand=False, fill=False, padding=5)   
    combo_box = gtk.ComboBox()
    hbox10.pack_start(combo_box, expand=False, fill=False, padding=5)

    # Create a ListStore model for ComboBox
    list_store = gtk.ListStore(str)
    options = [ "Outlines", "Centerlines"]  # Add your options here
    for option in options:
        list_store.append([option])

    # Set the model for ComboBox
    combo_box.set_model(list_store)

    # Create a CellRendererText to render the text in the ComboBox
    cell_renderer = gtk.CellRendererText()

    # Pack the CellRendererText into the ComboBox
    combo_box.pack_start(cell_renderer, True)
    combo_box.add_attribute(cell_renderer, 'text', 0)

    # Set up the "changed" signal handler   
    combo_box.connect("changed", on_combobox_changed)

    # Set the default option
    default_option = "Outlines"
    default_iter = list_store.get_iter_first()
    while default_iter is not None:
        if list_store.get_value(default_iter, 0) == default_option:
            combo_box.set_active_iter(default_iter)
            break
        default_iter = list_store.iter_next(default_iter)
				
    #-------------------------------------------------------------
	
    hbox11 = gtk.HBox()
    dialog.vbox.pack_start(hbox11, expand=True, fill=True)
    label11 = gtk.Label("        ")
    hbox10.pack_start(label11, expand=False, fill=False, padding=5)   
    combo_box = gtk.ComboBox()
    hbox10.pack_start(combo_box, expand=False, fill=False, padding=5)
	
    #-------------------------------------------------------------	

    # Create a ListStore model for ComboBox
    list_store = gtk.ListStore(str)
    options = [ "Speckly","Some Despeckling","More Despeckling"]  # Add your options here
    for option in options:
        list_store.append([option])

    # Set the model for ComboBox
    combo_box.set_model(list_store)

    # Create a CellRendererText to render the text in the ComboBox
    cell_renderer = gtk.CellRendererText()

    # Pack the CellRendererText into the ComboBox
    combo_box.pack_start(cell_renderer, True)
    combo_box.add_attribute(cell_renderer, 'text', 0)

    # Set up the "changed" signal handler   
    combo_box.connect("changed", on_combobox_changed_2)

    # Set the default option
    default_option = "Some Despeckling"
    default_iter = list_store.get_iter_first()
    while default_iter is not None:
        if list_store.get_value(default_iter, 0) == default_option:
            combo_box.set_active_iter(default_iter)
            break
        default_iter = list_store.iter_next(default_iter)

    #-------------------------------------------------------------

    hbox40 = gtk.HBox()
    dialog.vbox.pack_start(hbox40, expand=True, fill=True)
    pattern_label = gtk.Label("")	
    hbox40.pack_start(pattern_label, expand=True, fill=True, padding=1)
	
    #-------------------------------------------------------------

    hbox40 = gtk.HBox()
    dialog.vbox.pack_start(hbox40, expand=True, fill=True)
    pattern_label = gtk.Label("Corner-threshold (angle) Smooth <- | -> Jaggy:")	
    hbox40.pack_start(pattern_label, expand=True, fill=True, padding=1)
	
    #-------------------------------------------------------------		

    hbox3 = gtk.HBox()
    dialog.vbox.pack_start(hbox3, expand=True, fill=True)
    label3 = gtk.Label("")
    hbox3.pack_start(label3, expand=False, fill=False, padding=5)
    adjustment3 = gtk.Adjustment(value=100, lower=2, upper=180, step_incr=1, page_incr=0)
    param3_scale = gtk.HScale(adjustment=adjustment3)
    param3_scale.set_digits(0)  # Display only integers
    hbox3.pack_start(param3_scale, expand=True, fill=True, padding=5)
    label3 = gtk.SpinButton(adjustment3,0, 0 )
    hbox3.pack_start(label3, expand=False, fill=False, padding=5)
    param3_scale.set_update_policy(gtk.UPDATE_DISCONTINUOUS) ######		
    param3_scale.connect("value-changed", on_param3_changed)

    #-------------------------------------------------------------	
	
    hbox9 = gtk.HBox()
    dialog.vbox.pack_start(hbox9, expand=True, fill=True)	
    hbox2 = gtk.HBox()
    dialog.vbox.pack_start(hbox2, expand=True, fill=True)
    toggle_button = gtk.ToggleButton()
    dialog.action_area.add(toggle_button)	
    update_toggle_button_label(toggle_button)
    toggle_button.connect("toggled", on_toggle_button_toggled)
    hbox9.pack_start(toggle_button, expand=False, fill=False, padding=5)
	
    #-------------------------------------------------------------

    hbox40 = gtk.HBox()
    dialog.vbox.pack_start(hbox40, expand=True, fill=True)
    pattern_label = gtk.Label("")	
    hbox40.pack_start(pattern_label, expand=True, fill=True, padding=1)
	
    #-------------------------------------------------------------

    hbox40 = gtk.HBox()
    dialog.vbox.pack_start(hbox40, expand=False, fill=False)
    pattern_label = gtk.Label(" Stroke Path Width:      Stroke Color:            BG Color:")	
    hbox40.pack_start(pattern_label, expand=False, fill=False, padding=1)
	
    #-------------------------------------------------------------

    hbox7 = gtk.HBox()
    dialog.vbox.pack_start(hbox7, expand=True, fill=True)
    label7 = gtk.Label("")
    hbox7.pack_start(label7, expand=False, fill=False, padding=5)
    adjustment7 = gtk.Adjustment(value=0, lower=0, upper=5, step_incr=1, page_incr=0)
    param7_scale = gtk.HScale(adjustment=adjustment7)
    param7_scale.set_digits(0)  # Display only integers
    #hbox7.pack_start(param7_scale, expand=True, fill=True, padding=5)
    label7 = gtk.SpinButton(adjustment7,0, 0 )
    hbox7.pack_start(label7, expand=False, fill=False, padding=5)
    param7_scale.set_update_policy(gtk.UPDATE_DISCONTINUOUS) ######		
    param7_scale.connect("value-changed", on_param7_changed)

    #-------------------------------------------------------------		
    # Create a label for the color picker
    label5 = gtk.Label("                     ")
    hbox7.pack_start(label5, expand=False, fill=False, padding=1)

    # Create a color picker button
    color_button = gtk.ColorButton()
    color_button.set_use_alpha(False)  # Set to True if you want to include alpha channel
    color_button.set_color(gtk.gdk.Color(ege_c[0]*256, ege_c[1]*256, ege_c[2]*256))
    color_button.connect("color-set", on_color_changed_c)
    hbox7.pack_start(color_button, expand=False, fill=False, padding=5)	
	
    #===========================================================================
	
    # Create a label for the color picker
    labe25 = gtk.Label("               ")
    hbox7.pack_start(labe25, expand=False, fill=False, padding=1)

    # Create a color picker button
    color_button = gtk.ColorButton()
    color_button.set_use_alpha(False)  # Set to True if you want to include alpha channel
    color_button.set_color(gtk.gdk.Color(bg[0]*256, bg[1]*256, bg[2]*256))
    color_button.connect("color-set", on_color_changed_b)
    hbox7.pack_start(color_button, expand=False, fill=False, padding=5)	
	
    #===========================================================================	
    # Add an CANCEL button
    cancel_buton = dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
    cancel_buton.connect("clicked", cancel)
	
    # Add an OK button
    ok_button = dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
    ok_button.connect("clicked", on_ok_button_clicked)

	
    dialog.show_all()
    dialog.run()
    pdb.gimp_displays_flush()



def on_color_changed_r(widget, data=None):
    global reduce
    color = widget.get_color()
    reduce = (int(color.red/256), int(color.green/256), int(color.blue/256))
    update_live_preview()
    pdb.gimp_displays_flush()

    #-------------------------------------------------------------
def on_toggle_button_toggled_c(button):
    global proceed_with_changes_c
    proceed_with_changes_c = not proceed_with_changes_c
    update_toggle_button_label_c(button)

def update_toggle_button_label_c(button):
    label = "Remove Color:" if proceed_with_changes_c else "   Don't Use     "
    button.set_label(label)	
    update_live_preview()	

    #-------------------------------------------------------------

def on_sample_integer_changed(entry):
    global sample_integer
    try:
        sample_integer = float(entry.get_text()) #int(entry.get_text())
        #pdb.gimp_message(sample_integer)
        update_live_preview()
    except ValueError:
        # Handle the case where the input is not a valid integer
        pass   

def on_pattern_changed(entry):
    global pattern_
    try:
        pattern_ = str(entry.get_text()) #int(entry.get_text())
        #pdb.gimp_message(pattern_)
        update_live_preview()
    except ValueError:
        # Handle the case where the input is not a valid integer
        pass 

	
def on_color_changed_c(widget, data=None):
    global ege_c
    color = widget.get_color()
    ege_c = (int(color.red/256), int(color.green/256), int(color.blue/256))
    update_live_preview()
    pdb.gimp_displays_flush()

def on_color_changed_b(widget, data=None):
    global bg
    color = widget.get_color()
    bg = (int(color.red/256), int(color.green/256), int(color.blue/256))
    update_live_preview()
    pdb.gimp_displays_flush()

def on_toggle_button_toggled(button):
    global proceed_with_changes
    proceed_with_changes = not proceed_with_changes
    update_toggle_button_label(button)

def update_toggle_button_label(button):
    label = "Preview = Yes\n*Click to Stop " if proceed_with_changes else "Preview = No \n*Click to Start"
    button.set_label(label)	
    update_live_preview()

def on_combobox_changed(combobox):
    global selected_option
    model = combobox.get_model()
    active_iter = combobox.get_active_iter()

    if active_iter:
        selected_option = model.get_value(active_iter, 0)
    update_live_preview()

def on_combobox_changed_2(combobox):
    global selected_option_2
    model = combobox.get_model()
    active_iter = combobox.get_active_iter()

    if active_iter:
        selected_option_2 = model.get_value(active_iter, 0)
    update_live_preview()
	
def cancel(cancel_buton, data=None):
    global preview_layer
    #pdb.gimp_image_remove_layer(image,preview_layer)
    for layer in image.layers:
        if layer.name=="Autotrace":
            pdb.gimp_image_remove_layer(image,pdb.gimp_image_get_layer_by_name(image,"Autotrace"))
    for vector in image.vectors:
        if vector.name=="Autotrace":			
            pdb.gimp_image_remove_vectors(image,pdb.gimp_image_get_vectors_by_name(image,"Autotrace"))			
    for layer in image.layers:
        if layer.name=="Copy for flaten":
            pdb.gimp_image_remove_layer(image,pdb.gimp_image_get_layer_by_name(image,"Copy for flaten"))
    pdb.gimp_item_set_visible(image.layers[0], 1)			
def on_param1_changed(scale):
    global global_param1
    global_param1 = scale.get_value()
    update_live_preview()
    gimp.displays_flush()

def on_param3_changed(scale):
    global global_param3
    global_param3 = scale.get_value()
    update_live_preview()
    gimp.displays_flush()
	
def on_param7_changed(scale):
    global global_param7
    global_param7 = scale.get_value()
    update_live_preview()
    gimp.displays_flush()
	
def on_ok_button_clicked(button, data=None):
    global drawable
    #apply_final(drawable)
    button.get_toplevel().destroy() #destroys the gtk dialog window
    for layer in image.layers:
        if layer.name=="Copy for flaten":
            pdb.gimp_image_remove_layer(image,pdb.gimp_image_get_layer_by_name(image,"Copy for flaten"))
#######################################################

register(
    "python_fu_autotrace_live_preview",
    "Live Preview Plugin",
    "Create a live preview of an effect autotrace",
    "Lloyd Konneker/TT/MrQ",
    "GPL3",
    "2023",
    "<Image>/Filters/Edge-Detect/Autotrace with Live Preview...",  # Menu location
    "*",  # Image type
    [],
    [],
    dialog
)

main()