#!/usr/bin/env python
# -*- coding: utf-8 -*-

import math,gimp

class pnt2d(object):
	def __init__(self,x=0.0,y=0.0):
		self.x = x
		self.y = y
		return
	def __eq__(self, other):
		if self is None or other is None:
			return False
		elif self.x==other.x and self.y==other.y:
			return True
		else:
			return False
	def translate(self,x,y):
		self.x += x
		self.y += y
		return self
	def scale(self,x=1.0,y=1.0):
		self.x *= x
		self.y *= y
		return self
	def rotate(self,rot,cX=0.0,cY=0.0):
		px = cX + (self.x-cX) * math.cos(rot) - (self.y-cY)*math.sin(rot)
		py = cY + (self.x-cX) * math.sin(rot) + (self.y-cY)*math.cos(rot)
		self.x=px
		self.y=py
		return self
	def rotdeg(self,rot,cX=0.0,cY=0.0):
		self.rotate(math.radians(rot),cX,cY)
		return self

	def skew(self,rotX,rotY,cX=0.0,cY=0.0):
		#P' = (x + (y  py)tanT, y + (x  px)tanF)
		x,y=(self.x + (self.y-cY)*math.tan(math.radians(rotX)), self.y + (self.x-cX)*math.tan(math.radians(rotY)))
		self.x=x
		self.y=y
		return self
	def copy(self,pnt):
		self.x=pnt.x
		self.y=pnt.y
		return self
	def arrXY(self,tot=1):
		return [self.x,self.y]*tot
	def xy(self,tot=1):
		return (self.x,self.y)
	def length(self):
		return math.sqrt(self.x * self.x + self.y * self.y)

class bezpnt(object):
	def __init__(self,pfixed=None,pprev=None,pnext=None):
		if isinstance(pfixed, list):
			self.fixed = pnt2d(pfixed[0],pfixed[1])
		else:
			self.fixed = pfixed
		if isinstance(pprev, list):
			self.prev = pnt2d(pprev[0],pprev[1])
		else:
			self.prev = pprev
		if isinstance(pnext, list):
			self.next = pnt2d(pnext[0],pnext[1])
		else:
			self.next = pnext
		return
	def translate(self,x,y):
		self.fixed.translate(x,y)
		if self.prev!=None:self.prev.translate(x,y)
		if self.next!=None:self.next.translate(x,y)
		return self
	def scale(self,x=1.0,y=1.0):
		self.fixed.scale(x,y)
		if self.prev!=None:self.prev.scale(x,y)
		if self.next!=None:self.next.scale(x,y)
		return self
	def rotate(self,rot,cX=0.0,cY=0.0):
		self.fixed.rotate(rot,cX,cY)
		if self.prev!=None:self.prev.rotate(rot,cX,cY)
		if self.next!=None:self.next.rotate(rot,cX,cY)
		return self
	def skew(self,rotx,roty,cX=0.0,cY=0.0):
		self.fixed.skew(rotx,roty,cX,cY)
		if self.prev!=None:self.prev.skew(rotx,roty,cX,cY)
		if self.next!=None:self.next.skew(rotx,roty,cX,cY)
		return self
	def copy(self,bez2):
		self.fixed=pnt2d().copy(bez2.fixed)
		if bez2.prev == None:
			self.prev = None
		else:
			self.prev = pnt2d().copy(bez2.prev)
		if  bez2.next == None:
			self.next = None
		else:
			self.next = pnt2d().copy(bez2.next)
		return self
	def arrXY(self):
		pts=[]
		if self.prev == None:
			pts+=self.fixed.arrXY(1)
		else:
			pts+=self.prev.arrXY(1)
		pts+=self.fixed.arrXY(1)
		if self.next==None:
			pts+=self.fixed.arrXY(1)
		else:
			pts+=self.next.arrXY(1)
		return pts
	def Prev(self):
		p = self.prev
		if p==None: p=self.fixed
		return p
	def Next(self):
		p = self.next
		if p==None: p=self.fixed
		return p
	def Fixed(self):
		return self.fixed

class gimppath(object):
	def __init__(self,pts=None):
		self.bpoints=[]
		if pts != None: self.bpoints=pts
		return
	def translate(self,x,y):
		for b in self.bpoints: b.translate(x,y)
		return self
	def scale(self,x=1.0,y=1.0):
		for b in self.bpoints: b.scale(x,y)
		return self
	def rotate(self,rot,cX=0.0,cY=0.0):
		for b in self.bpoints: b.rotate(rot, cX, cY)
		return self
	def skew(self,rotX,rotY,cX=0.0,cY=0.0):
		for b in self.bpoints: b.skew(rotX,rotY,cX,cY)
		return self
	def rotdeg(self,rot,cX=0.0,cY=0.0):
		self.rotate(math.radians(rot),cX,cY)
		return self
	def append(self,arr):
		self.bpoints.append(arr)
	def toGimpPath(self):
		arrG=[]
		for b in self.bpoints: arrG.extend(b.arrXY())
		return arrG
	def len(self):
		return len(self.bpoints)
	def getBezAt(self,num):
		return self.bpoints[num]
	def compact(self):
		bps=self.bpoints
		for n in range(self.len()-1,1,-1):
			# si este y el anterior comparten dos puntos los unimos y eliminamos este
			b2=bps[n]
			b1=bps[n-1]
			if b2.fixed==b1.fixed and b2.prev==b1.next:
				b3=pnt2d().copy(b2.next)
				b1.next=b3
				del bps[n]
		self.bpoints=bps
		return self
	def getFromStroke(self,st):
		#v[0].strokes[0].points
		for n in range(len(st)/6):
			nn=n*6
			bp=bezpnt(pnt2d(st[nn+2],st[nn+3]),pnt2d(st[nn],st[nn+1]),pnt2d(st[nn+4],st[nn+5]))
			self.append(bp)
		return self
