; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; revised December 2010 to honor layer visibility

;; Combine each layer of the image with a copy of the background layer

(define (script-fu-sg-anim-combine-background image)
  ; get visible layers (bottom-to-top)
  (define (get-visibles image)
    (let loop ((layers (vector->list (cadr (gimp-image-get-layers image))))
               (visibles '()) )
      (if (null? layers)
        visibles
        (loop (cdr layers) 
              (if (zero? (car (gimp-drawable-get-visible (car layers))))
                visibles
                (cons (car layers) visibles) ) ) ) ) )
                
  (gimp-image-undo-group-start image)
  (let* ((layers (vector->list (cadr (gimp-image-get-layers image))))
         (visibles (get-visibles image))
         (bg-layer (car (last layers)))
         (orig-sel (car (gimp-selection-save image))) )
    (gimp-selection-none image)
    (map (lambda (x) (gimp-drawable-set-visible x FALSE)) visibles)
    (when (= (car visibles) bg-layer)
      (set! visibles (cdr visibles))
      (gimp-drawable-set-visible bg-layer TRUE) )
    (while (pair? visibles)
      (let* ((layer (car visibles))
             (position (car (gimp-image-get-layer-position image layer))) 
             (base-layer 0)
             (layer-name "") )
        (gimp-drawable-set-visible (car visibles) TRUE)
        (set! layer-name (car (gimp-drawable-get-name layer)))
        (set! base-layer (car (gimp-layer-new-from-drawable bg-layer image)))
        (gimp-image-add-layer image base-layer (+ position 1))
        (gimp-drawable-set-visible base-layer TRUE)
        (set! base-layer (car (gimp-image-merge-down image layer CLIP-TO-BOTTOM-LAYER)))
        (gimp-drawable-set-name base-layer layer-name) )
      (set! visibles (cdr visibles)) )
    (gimp-selection-load orig-sel)
    (gimp-image-remove-channel image orig-sel) )
  (gimp-image-undo-group-end image)
  (gimp-displays-flush)
  )

(script-fu-register "script-fu-sg-anim-combine-background"
  "<Image>/Filters/Animation/_Combine background"
  "Combine each layer of the image with a copy of the background layer"
  "Saul Goode"
  "Saul Goode"
  "4/22/2007"
  "*"
  SF-IMAGE    "Image"    0
  )

;; Overlay each layer of the image with a copy of the background layer

(define (script-fu-sg-anim-overlay-background image)
  ; get visible layers (bottom-to-top)
  (define (get-visibles image)
    (let loop ((layers (vector->list (cadr (gimp-image-get-layers image))))
               (visibles '()) )
      (if (null? layers)
        visibles
        (loop (cdr layers) 
              (if (zero? (car (gimp-drawable-get-visible (car layers))))
                visibles
                (cons (car layers) visibles) ) ) ) ) )
  (gimp-image-undo-group-start image)
  (let* ((layers (vector->list (cadr (gimp-image-get-layers image))))
         (visibles (get-visibles image))
         (bg-layer (car (last layers)))
         (orig-sel (car (gimp-selection-save image))) )
    (gimp-selection-none image)
    (map (lambda (x) (gimp-drawable-set-visible x FALSE)) visibles)
    (when (= (car visibles) bg-layer)
      (set! visibles (cdr visibles))
      (gimp-drawable-set-visible bg-layer TRUE) )
    (while (pair? visibles)
      (let* ((layer (car visibles))
             (position (car (gimp-image-get-layer-position image layer))) 
             (over-layer 0) )
        (gimp-drawable-set-visible layer TRUE)
        (gimp-image-set-active-layer image layer)
        (set! over-layer (car (gimp-layer-new-from-drawable bg-layer image)))
        (gimp-image-add-layer image over-layer -1)
        (gimp-drawable-set-visible over-layer TRUE)
        (gimp-image-merge-down image over-layer EXPAND-AS-NECESSARY) )
      (set! visibles (cdr visibles)) )
    (gimp-selection-load orig-sel)
    (gimp-image-remove-channel image orig-sel) )
  (gimp-image-undo-group-end image)
  (gimp-displays-flush)
  )

(script-fu-register "script-fu-sg-anim-overlay-background"
  "<Image>/Filters/Animation/_Overlay background"
  "Overlay each layer of the image with a copy of the background layer"
  "Saul Goode"
  "Saul Goode"
  "4/22/2007"
  "*"
  SF-IMAGE    "Image"    0
  )
