#!/usr/bin/env python2
# -*- coding: utf-8 -*-

# V 0.6 First python port from original written in C.
# V 0.7 previously, bpp number was not valid anymore when images are converted to rgb.

import gimp
from gimpfu import*
import random
#import time

class row_segment:
    def __init__(self, x1, x2):
	self.x1 = x1
	self.x2 = x2
	self.color_data = None	# color_entry.

class color_entry():
    def __init__(self, a):
	self.next_color = None
	self.color = chr(int(random.random()*172)+47) + chr(int(random.random()*172)+47) + chr(int(random.random()*172)+47)
	if a:
	    self.color+="\xff"

def multifill(image, drawable):

    #starttime = time.time()

    image.undo_group_start()
    if not drawable.is_rgb:
	pdb.gimp_image_convert_rgb(image)
    else:
	pdb.gimp_brightness_contrast(drawable, 0, 0)	# Dummy operation to create a full undo buffer, since pixel region operations aren't undoable.
    image.undo_group_end()

    alpha = drawable.has_alpha
    bpp = drawable.bpp

    row_list = [[] for i in range(drawable.height)]

    # Collect row segments.
    for y in range(drawable.height):
	row = drawable.get_pixel_rgn(0, y, drawable.width, 1)
	rowchars = row[0:drawable.width, y]	# Read the whole line.
	is_white = [rowchars[i*bpp:i*bpp+3]=='\xff\xff\xff' for i in range(drawable.width)]

	active_segment = None;
	for x in range (drawable.width):
	    if is_white[x]:
		if active_segment:
		    active_segment.x2 = x
		else:
		    active_segment = row_segment(x,x)
		    row_list[y].append(active_segment)
	    else:
		active_segment = None

    # Initialize first row.
    for active_segment in row_list[0]:
	active_segment.color_data = color_entry(alpha)

    # Find color areas.
    for y in range(1, drawable.height):
	for active_segment in row_list[y]:
	    for upper_segment in row_list[y-1]:
		# Test wether segments above touch this one
		if (upper_segment.x2 >= active_segment.x1) and (upper_segment.x1 <= active_segment.x2):
		    if active_segment.color_data:		# Set if more than one segments above touch and this is not the first test.
		        if not active_segment.color_data == upper_segment.color_data:
			    color_item = upper_segment.color_data
			    while color_item.next_color:	# Does it point to something?
				color_item = color_item.next_color    # Reach end of chain.
			    # Prevent endless loop below.
			    current_data = active_segment.color_data
			    while current_data.next_color:
				if current_data == upper_segment.color_data:
				    color_item = None
				    break
				current_data = current_data.next_color
			    if color_item:
				if not color_item == current_data:
				    color_item.next_color = active_segment.color_data	# Merge two areas by linking at end of chain.
		    else:	# Use color from line above.
			active_segment.color_data = upper_segment.color_data
	    if not active_segment.color_data:	    # No contact
		active_segment.color_data = color_entry(alpha)

    black = '\x00\x00\x00'
    if alpha:
	black = '\x00\x00\x00\xff'

    # Fill
    for y in range(drawable.height):
	outbytes = [black for a in range(drawable.width)]

	for active_segment in row_list[y]:
	    color_item = active_segment.color_data
	    while color_item.next_color:
		color_item = color_item.next_color

	    for x in range(active_segment.x1, active_segment.x2+1):
		outbytes[x] = color_item.color

	outrow = drawable.get_pixel_rgn(0, y, drawable.width, 1)
	outrow[0:drawable.width, y] = ''.join(outbytes)

    drawable.update(0, 0, drawable.width, drawable.height)
    gimp.displays_flush()

    #gimp.message("%f"%(time.time()-starttime))

register(
	"multifill",
	"Python multifill plugin",
	"For an image with only pure black and white pixels, fill all white areas with random colors. Useful for color comics and illustrations.",
	"Inkdolls",
	"",
	"2013, 2024",
	"<Image>/Python-Fu/Flatting/Multifill",
	"RGB*, GRAY*, INDEXED*",
	[],
	[],
	multifill)

# Except for the feathering option, this part is taken from a script found on the old Gimp registry,
# because this approach is smarter than mine, which used selections.

def python_flatten(img, drawable):

    pdb.gimp_context_push()
    pdb.gimp_image_undo_group_start(img)

    pdb.gimp_by_color_select(drawable, (0, 0, 0), 0, CHANNEL_OP_REPLACE, False, False, 0, False)

    while not pdb.gimp_selection_is_empty(img):
	pdb.plug_in_dilate(img, drawable, 1, HISTOGRAM_VALUE, 1.0, 7, 0, 255)
	pdb.gimp_by_color_select(drawable, (0, 0, 0), 0, CHANNEL_OP_REPLACE, False, False, 0, False)

    pdb.gimp_image_undo_group_end(img)
    pdb.gimp_displays_flush()
    pdb.gimp_context_pop()

register(
	"flatten_colors",
	"Flatten colors",
	"Flattens an image that has been multicoloured",
	"Based on original by Rob Antonishen",
	"Based on original by Rob Antonishen",
	"2009, 2024",
	"<Image>/Python-Fu/Flatting/Flatten",
	"RGB*, GRAY*",
	[],
	[],
	python_flatten)

main()
