#!/usr/bin/env python

# website_photos1.py
#
# License: GPLv3
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# To view a copy of the GNU General Public License
# visit: http://www.gnu.org/licenses/gpl.html
#
# Program created to produce standard size images for my Lourdata Holidays website
# by copying to a new image, scaling and applying sharpening. The original image
# is left unchanged.
#
# ------------
#| Change Log |
# ------------
# Version 1 06/11/2024
# Version 2 19/11/2024
# Version 3 27/11/2024
# 
# 06/11/2024 Saves scaled image(s) to selected individual output folders.
#            Output sizes selectable.
#            Increments output file name suffix.
# 19/11/2024 Removed creation of unnecessary additional layers.
# 27/11/2024 Added option to select top-level directory.
#
#import Image
from gimpfu import *
import os

def python_website_photos1(image, layer,  outputFolder, subDir, nName, newWL, newWP, newWT) :
	pdb.gimp_image_undo_group_start(image)
	pdb.gimp_context_push()
	
	frozen = pdb.gimp_image_undo_freeze(image)																	# disable undo to increase speed and
																												# reduce memory requirements
			
	outputFolderF = outputFolder + "/" + subDir + "/Full-size"													# create folder & sub-folder
	if not os.path.exists(outputFolderF):																		# for full-size image
		os.makedirs(outputFolderF)
		
	nF = 1
	neWnameF = subDir + "_" + nName + '_' + str(nF) + "_f" + ".jpg"												# add 'n + 'f' + '.jpg' to fileName

	isFile = os.path.isfile(outputFolderF + "/" + neWnameF)														# test if file exists
	
	while isFile:																								# while file exist on disk

		nF = nF + 1

		neWnameF = subDir + "_" + nName + '_' + str(nF) + "_f" + ".jpg"											# neWname suffix incremented by 1

		isFile = os.path.isfile(outputFolderF + "/" + neWnameF)													# test if file already exists

	else:																										# if file with suffix does not exist
		pdb.file_jpeg_save(image, layer, outputFolderF + "/" + neWnameF, "", 0.9, 0, 0, 1, "", 2, 0, 0, 0)		# 90% quality, progressive, chroma sub-sampling
	
	width   = image.width																						# original image width
	height  = image.height																						# original image height	
		
	pdb.gimp_selection_all(image)																				# select what to copy
	pdb.gimp_edit_copy(layer)																					# copy layer to buffer
	
	neWimage = pdb.gimp_image_new(width, height, RGB)															# create a new image
	newLayer = pdb.gimp_layer_new(neWimage, width, height, RGB_IMAGE, "newLayer" , 100, LAYER_MODE_NORMAL)		# define new layer
	pdb.gimp_image_insert_layer(neWimage, newLayer, None, 0)													# insert layer
	display = pdb.gimp_display_new(neWimage)																	# make the new image visible
	
	floating_sel = pdb.gimp_edit_paste(newLayer, TRUE)															# define floating selection
	pdb.gimp_floating_sel_anchor(floating_sel)																	# anchor the floating selection
	
	if width > height:																							# if landscape
		new_width  = newWL																						# width large
		new_height = newWL * (float(height) / float(width))														# calculate new height
		pdb.gimp_image_scale(neWimage, new_width, new_height)													# scale image
		
	elif width <= height:																						# if portrait
		new_width  = newWP * (float(width) / float(height))														# calculate new width
		new_height = newWP																						# height large		
		pdb.gimp_image_scale(neWimage, new_width, new_height)													# scale image
		
	pdb.plug_in_wavelet_decompose(neWimage, newLayer, 5, 0, 0)													# wavelet decompose 5 layers
	
	layerActive = neWimage.layers[0]																			# variable for active layer	
	pdb.gimp_image_set_active_layer(neWimage, layerActive)														# make top layer active
	
	layer_copy1 = pdb.gimp_layer_new_from_drawable(layerActive, neWimage)										# duplicate layer1 of wavelet decompose	
	pdb.gimp_image_insert_layer(neWimage, layer_copy1, None, 0)													# insert layer
	
	layer = pdb.gimp_image_merge_visible_layers(neWimage,  EXPAND_AS_NECESSARY)									# merge visible layers
	
	
	outputFolderL = outputFolder + "/" + subDir + "/Large"														# create folder for large
	if not os.path.exists(outputFolderL):																		# size image
		os.makedirs(outputFolderL)
	
	nL = 1
	neWnameL = subDir + "_" + nName + '_' + str(nL) + "_l" + ".jpg"												# create unique fileName
	
	isFile = os.path.isfile(outputFolderL + "/" + neWnameL)														# test if file exists
	
	while isFile:																								# while file exist on disk
		nL = nL + 1
		neWnameL = subDir + "_" + nName + '_' + str(nL) + "_l" + ".jpg"											# neWname suffix incremented by 1
		isFile = os.path.isfile(outputFolderL + "/" + neWnameL)													# re-test if file exists
 		
 	else:																										# if file with suffix does not exist
 		pdb.file_jpeg_save(image, layer, outputFolderL + "/" + neWnameL, "", 0.9, 0, 0, 1, "", 2, 0, 0, 0)		# 90% quality, progressive, chroma sub-sampling
 		
 	pdb.gimp_image_clean_all(neWimage)																			# mark as saved
 	pdb.gimp_display_delete(display)																			# remove neWimage
	
	sizes = 1																									# select thumbnail size image
	
	neWimage1 = pdb.gimp_image_new(width, height, RGB)															# create a new image
	newLayer1 = pdb.gimp_layer_new(neWimage1, width, height, RGB_IMAGE, "newLayer1" , 100, LAYER_MODE_NORMAL)	# define new layer
	pdb.gimp_image_insert_layer(neWimage1, newLayer1, None, 0)													# insert layer
	display = pdb.gimp_display_new(neWimage1)																	# make the new image visible
	
	floating_sel = pdb.gimp_edit_paste(newLayer1, TRUE)															# define floating selection
	pdb.gimp_floating_sel_anchor(floating_sel)																	# anchor the floating selection
	
	if width > height:																							# if landscape
		new_width  = newWT																						# width thumbnail
		new_height = newWT * (float(height) / float(width))														# calculate new height
		pdb.gimp_image_scale(neWimage1, new_width, new_height)													# scale image
		
	elif width <= height:																						# if portrait
		new_width  = newWT																						# width thumbnail
		new_height = newWT * (float(height) / float(width))														# calculate new height		
		pdb.gimp_image_scale(neWimage1, new_width, new_height)													# scale image
		
	pdb.plug_in_wavelet_decompose(neWimage1, newLayer1, 5, 0, 0)												# wavelet decompose 5 layers
	
	layerCount = 1
	layerActive = neWimage1.layers[layerCount]																	# layer	2 (index 1) to be duplicated
	pdb.gimp_image_set_active_layer(neWimage1, layerActive)														# make layer active
	
	layer_copy1 = pdb.gimp_layer_new_from_drawable(layerActive,neWimage1)										# duplicate layer1 of wavelet decompose	
	pdb.gimp_image_insert_layer(neWimage1,layer_copy1,None,0)													# insert layer
	
	layer = pdb.gimp_image_merge_visible_layers(neWimage1,  EXPAND_AS_NECESSARY)								# merge visible layers
		
	nS = 1
	neWnameS = subDir + "_" + nName + '_' + str(nS) + "_s" + ".jpg"												# add '_s' + n + '.jpg' to fileName
			
	outputFolderS = outputFolder + "/" + subDir + "/Small"														# create folder for small
	if not os.path.exists(outputFolderS):																		# size image
		os.makedirs(outputFolderS)
	
	isFile = os.path.isfile(outputFolderS + "/" + neWnameS)														# test if file exists
	
	while isFile:																								# while file exist on disk
		nS = nS + 1
		neWnameS = subDir + "_" + nName + '_' + str(nS) + "_s" + ".jpg"											# neWname suffix incremented by 1
		isFile = os.path.isfile(outputFolderS + "/" + neWnameS)													# re-test if file exists
 		
	else:																										# if file with suffix does not exist
		pdb.file_jpeg_save(image, layer, outputFolderS + "/" + neWnameS, "", 0.9, 0, 0, 1, "", 2, 0, 0, 0)		# 90% quality, progressive, chroma sub-sampling
 		
 		pdb.gimp_image_clean_all(neWimage1)																		# mark as saved
 		pdb.gimp_display_delete(display)																		# remove neWimage1
 		
 	pdb.gimp_image_clean_all(image)																				# mark as saved
 	
	thawed = pdb.gimp_image_undo_thaw(image)																	# re-enable undo
		
	pdb.gimp_context_pop()
	pdb.gimp_image_undo_group_end(image)
	pdb.gimp_displays_flush()
	
register(
	"python_website_photos1",
	"Website Photos1",
	"Website Photos1",
	"David Marsden",
	"David Marsden",
	"November 2024",
	"<Image>/Python-Fu/LH/Website Photos1...",             #Menu path
	"RGB*, GRAY*", 
	[
		(PF_DIRNAME, "outputFolder", "Output directory", "Desktop"),
		(PF_STRING, "subDir", "Sub Directory", "", 0),
		(PF_STRING, "nName", "New Name", "", 0),
		(PF_SPINNER, "newWL", "New Width L'scape", 900, (600, 1200, 1)),
		(PF_SPINNER, "newWP", "New Width Portrait", 600, (400, 800, 1)),
		(PF_SPINNER, "newWT", "New Width Thumbnail", 200, (100, 300, 1)),
	],
	[],
	python_website_photos1)

main()
