# Copy-paste in the Gimp 2.10 Python console to generate the gradients
# "step" is the size (in degrees) covered by a gradient segment (360° total for a full cycle)
# Smaller step: more accurate gradient
# If there is already a gradient with the name, the created gradient may be named "{name} #1"
# Gradients created are directly usable. You have to refresh the gradients list (or exit Gimp)
# to have them saved as gradient files (.GGR).

import math
import gimpcolor

def channelAt(x,phase):
    return (1+math.sin((x+phase%360)*math.pi/180))/2

def rgbAt(x,phaseR,phaseG,phaseB):
    return gimpcolor.RGB(channelAt(x,phaseR),channelAt(x,phaseG),channelAt(x,phaseB))

step=5 # change this for a finer/coarser gradient
stops=range(0,360,step)
segs=len(stops)

def gradient(name,phaseR,phaseG,phaseB):
    colors=[rgbAt(x,phaseR,phaseG,phaseB) for x in stops]
    gradient=pdb.gimp_gradient_new(name)
    pdb.gimp_gradient_segment_range_set_blending_function(gradient, 0,0, GRADIENT_SEGMENT_LINEAR)
    pdb.gimp_gradient_segment_range_set_coloring_type(gradient, 0,0, GRADIENT_SEGMENT_RGB)
    pdb.gimp_gradient_segment_range_split_uniform(gradient,0,0,segs)
    for i in range(segs):
        pdb.gimp_gradient_segment_set_left_color(gradient, i, colors[i], 100)
        pdb.gimp_gradient_segment_set_right_color(gradient, i, colors[(i+1)%segs], 100)

gradient("ThreePhase-CW",90,90+120,90+240)
gradient("ThreePhase-CCW",90,90+240,90+120)
