; Source: http://gimpchat.com/viewtopic.php?f=9&t=14565&hilit=guides+to+selection&start=20#p201330
; Update for Gimp-2.10 MrQ

(define (script-fu-guides-to-selection-mk2 image layer select-mode)

	(let* (
				(next-guide (make-vector 4))
				(guide-orientation (make-vector 4))
				(guide-position (make-vector 4))
				(number 0)
				(count 3)
				(hold 0)
				(hold2 0)
				(x1 0)
				(x2 0)
				(y1 0)
				(y2 0)
				(loop-2x 2)
				(loop-3x 3)
			)

				(gimp-image-add-vguide image 424)
				(gimp-image-add-vguide image 1474)
				(gimp-image-add-hguide image 100)
				(gimp-image-add-hguide image 1500)

				(set! number (car (gimp-image-find-next-guide image 0)))
							
						(while (> count -1)

									(vector-set! guide-orientation count (car (gimp-image-get-guide-orientation image number)))
									(vector-set! guide-position count (car (gimp-image-get-guide-position image number)))
									(vector-set! next-guide count (car (gimp-image-find-next-guide image number)))
									(set! number (car (gimp-image-find-next-guide image number)))

						(set! count (- count 1)))
				
				(while (> loop-2x 0)
				
								(while (> loop-3x 0)

										(if (= (vector-ref guide-orientation loop-3x) 1)
										
												(begin
														(set! hold (vector-ref guide-orientation loop-3x))
														(vector-set! guide-orientation loop-3x (vector-ref guide-orientation (- loop-3x 1)))
														(vector-set! guide-orientation (- loop-3x 1) hold)
														
														(set! hold2 (vector-ref guide-position loop-3x))
														(vector-set! guide-position loop-3x (vector-ref guide-position (- loop-3x 1)))
														(vector-set! guide-position (- loop-3x 1) hold2)
												)
										)
						
								(set! loop-3x (- loop-3x 1)))
						
						(set! loop-3x 3)
						
				(set! loop-2x (- loop-2x 1)))		
				
				(set! x1 (vector-ref guide-position 0))
				(set! x2 (vector-ref guide-position 1))
				(set! y1 (vector-ref guide-position 2))
				(set! y2 (vector-ref guide-position 3))

				(if (> x1 x2) (begin
												(set! hold x1)
												(set! x1 x2)
												(set! x2 hold)))
				(set! x2 (- x2 x1))
													
				(if (> y1 y2) (begin
												(set! hold y1)
												(set! y1 y2)
												(set! y2 hold)))
													
				(set! y2 (- y2 y1))


			;(gimp-rect-select 1 x1 y1 x2 y2 select-mode FALSE 0)	MrQ: Procedure gimp-rect-select deprecated
			(gimp-image-select-rectangle image select-mode x1 y1 x2 y2)						
	)

	(script-fu-guides-remove image layer)

    (gimp-displays-flush)
)

(script-fu-register
		"script-fu-guides-to-selection-mk2"
		"Guides to selection..."
		"Makes a selection from 4 guides (must be 2 vertical and 2 horizontal)"
		"SteveMi"
		"Unrestricted"
		"2016"
		"*"
		SF-IMAGE		"Image"	0
		SF-DRAWABLE	    "Layer"		0
		SF-OPTION		"Selection mode"	'("Channel op Add" "Channel op Subtract" "Channel op Replace" "Channel op Intersect")
)
(script-fu-menu-register "script-fu-guides-to-selection-mk2"
                         "<Image>/Image/Guides")
