; Resynth along path

; Requires resynthesizer plug-in.
; Rob Antonishen - http://ffaat.pointclark.net/
; based on smart erase by:

; Paul Harrison (pfh@logarithmic.net)

; Concept by bootchk

; updated Oct 2012 to work with gimp 2.8

; License:
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; The GNU Public License is available at
; http://www.gnu.org/copyleft/gpl.html

; lkk comment: creates stencil selection in a temp dupe image to pass as source drawable to plugin


(define (script-fu-resynth-path img path width corpus-border)
   (let*
      (
        (dupe (car (gimp-image-duplicate img)))
        (pathdupe (car (gimp-image-get-active-vectors dupe)))
		(layer (car (gimp-image-get-active-layer img)))
		(noselection (car (gimp-selection-is-empty img)))
	    (brushTemp 0)
	    (varRadius (/ width 2.0))
        (channel 0)
        (imgchannel 0)
		(savedsel 0)
        (workLayerID -1)    ; lkk
		(buffer "")
      )
	  
	  ;(gimp-display-new dupe)
	  
	  (gimp-context-push)
	  (gimp-image-undo-group-start img)

	  ;RMA set up brush to stroke path mask
      (set! brushTemp (car (gimp-brush-new "StrokeBrush")))
  	  (gimp-brush-set-shape brushTemp BRUSH-GENERATED-CIRCLE)
      (gimp-brush-set-hardness brushTemp 1)
      (gimp-brush-set-radius brushTemp varRadius)
      (gimp-brush-set-spacing brushTemp 10)
      (gimp-brush-set-spikes brushTemp 2)
      (gimp-brush-set-aspect-ratio brushTemp 1)
      (gimp-brush-set-angle brushTemp 0)
  	  (gimp-context-set-brush brushTemp)
	  (gimp-context-set-paint-method "gimp-paintbrush")
	  
	  (gimp-context-set-foreground '(255 255 255))
  	
	  ;RMA save old selection if it existed
	  (when (equal? noselection FALSE)
	    (set! savedsel (car (gimp-selection-save img)))
		(gimp-selection-none img)
	    (gimp-selection-none dupe)
	  )
	  
      ; lkk flatten (so stencil gets everything visible) and to activate a layer in dupe
      ; (gimp-message-set-handler 1)	; debug messages to console
      (gimp-image-flatten dupe)         ; lkk !!! flatten, activates layer, but deletes alpha
      (set! workLayerID (car (gimp-image-get-active-layer dupe)))
      (cond ((= -1 workLayerID) 
           (gimp-message "Failed get active layer")
      )     )
      ; lkk plugin requires equal count of channels, target and source.  Plugin should be changed to relax this reqt.
      (cond ((= 1 (car (gimp-drawable-has-alpha layer)))
           ;debug (gimp-message "Adding alpha")
           (if (not (car (gimp-layer-add-alpha workLayerID)))  (gimp-message "Failed add alpha") )
      )     )
      

	  ;RMA create new empty channel for selection and stroke it with the width the load back as selection
	  (set! channel (car (gimp-selection-save dupe)))
	  (gimp-edit-stroke-vectors channel pathdupe)
	  (gimp-selection-load channel)
      
	  (set! imgchannel (car (gimp-selection-save img)))
	  (gimp-edit-stroke-vectors imgchannel path)
	  (gimp-selection-load imgchannel)
      (gimp-image-remove-channel img imgchannel)	  
	  
	  ;intersect with initial selection to limit effect
	  (if (equal? noselection FALSE)
	    (gimp-channel-combine-masks (car (gimp-image-get-selection img)) savedsel CHANNEL-OP-INTERSECT 0 0)
	  )
	  
      ; lkk comment: grow selection, invert, save to channel2, cut a hole size of orig selection
      ; lkk in the grown selection in channel2, select channel2, un invert
      (gimp-selection-grow dupe corpus-border)
      (gimp-selection-invert dupe)
      (let*
        (
	      (old-background (car (gimp-context-get-background)))
          (channel2 (car (gimp-selection-save dupe)))
        )

        (gimp-selection-load channel)
	    (gimp-context-set-background '(255 255 255))
        (if (not (car (gimp-edit-clear channel2))) (gimp-message "Failed edit clear") )
	    (gimp-context-set-background old-background)
        (gimp-selection-load channel2)
      )

      (gimp-selection-invert dupe)
      ; lkk comment: crop the dupe to size of stencil to save memory
      (let*
        (
          (bounds (gimp-selection-bounds dupe))
	      (x1 (nth 1 bounds))
	      (y1 (nth 2 bounds))
	      (x2 (nth 3 bounds))
	      (y2 (nth 4 bounds))
        )

        (gimp-image-crop dupe (- x2 x1) (- y2 y1) x1 y1)
      )
       
      ; RMA check for 11 or 13 parameter version of resynthesizer
	  (if (defined? 'plug-in-resynthesizer) 
	    (begin
		  (if (<> 0 (strcmp (list-ref (gimp-procedural-db-proc-info "plug-in-resynthesizer") 4) "2010"))  ; RMA check only invert for old version
            (gimp-selection-invert dupe)  ; lkk !!! plugin requires inverted selection
	      )
		  (cond
            ((= (list-ref (gimp-procedural-db-proc-info "plug-in-resynthesizer") 6) 11)
              ; lkk originally 7th param was layer (the in layer), which only SEEMED to work.  Should be the stencil.
		      (plug-in-resynthesizer RUN-NONINTERACTIVE img layer 0 0 1 workLayerID -1 -1 0.0 0.117)
            )
            ((= (list-ref (gimp-procedural-db-proc-info "plug-in-resynthesizer") 6) 13)
              ; lkk originally 7th param was layer (the in layer), which only SEEMED to work.  Should be the stencil.
		      (plug-in-resynthesizer RUN-NONINTERACTIVE img layer 0 0 1 workLayerID -1 -1 0.0 0.117 16 500)
            )
          )
		)
		(gimp-message "This script requires the resynthesizer plugin!")
	  )
      (gimp-image-delete dupe)
	  (gimp-brush-delete brushTemp)

	  ;RMA sload back original selection
	  (if (equal? noselection FALSE)
	    (begin
	      (gimp-selection-load savedsel)
          (gimp-image-remove-channel img savedsel)
		)
		(gimp-selection-none img)
	  )
	  
	  (gimp-image-undo-group-end img)	  
      (gimp-displays-flush)

	  (gimp-context-pop)
) 
)

(script-fu-register "script-fu-resynth-path"
                    "Resynth along Path..."
					"Extend surrounding texture to cover a path stroke.  Works best with homogenous, not regular surroundings. Requires separate resynthesizer plug-in."
				"Rob Antonishen"
				"Copyright 2000 Paul Harrison, 2009 Lloyd Konneker, 2011 Rob Antonishen"
				"16/08/2011"
				"RGB* GRAY*"
				SF-IMAGE "Input Image" 0
                SF-VECTORS    "path"   0
				SF-ADJUSTMENT "Width of line to repair" '(7 2 100 1.0 1.0 0 1)
                SF-ADJUSTMENT "Radius to take texture from" '(50 7 1000 1.0 1.0 0 1)
)

(script-fu-menu-register "script-fu-resynth-path"
                         "<Vectors>")