#!/usr/bin/env gimp-script-fu-interpreter-3.0

(script-fu-register
    "script-fu-quick-save-webp"  ;func name
    "quick-save-webp "    ;menu label
    " "    ;description
    " "    ;author
    " "    ;copyright notice
    " "    ;date created
    "*"    ;image type that the script works on
    SF-IMAGE    "Image"                 0
    SF-DRAWABLE "Drawable"              0
    SF-STRING "file-name"              ""
)
(script-fu-menu-register "script-fu-quick-save-webp" "<Image>/Tools")
(define (script-fu-quick-save-webp image drawable file-name)

    ;start
    (gimp-context-push)
    (gimp-image-undo-group-start image)
    
    ;put your procedures here

(file-webp-export #:run-mode RUN-NONINTERACTIVE
                  #:image image
                  #:file (string-append file-name ".webp")
                  #:preset "default"
                  #:lossless FALSE
                  #:quality 80
                  #:alpha-quality 100
                  #:use-sharp-yuv FALSE
                  #:animation-loop FALSE
                  #:minimize-size TRUE
                  #:keyframe-distance 0
                  #:default-delay 0
                  #:force-delay FALSE
                  #:animation FALSE
                  #:include-exif FALSE
                  #:include-iptc FALSE
                  #:include-xmp FALSE
                  #:include-color-profile FALSE
                  #:include-thumbnail FALSE )


    (gimp-image-clean-all image)

    ;finish
    (gimp-image-undo-group-end image)
    (gimp-context-pop)
    (gimp-displays-flush)
)




