#!/usr/bin/env python3
# -*- coding: utf-8 -*-


import sys

import gi
gi.require_version('Gimp', '3.0')
from gi.repository import Gimp
gi.require_version('GimpUi', '3.0')
from gi.repository import GimpUi
gi.require_version('Gegl', '0.4')
from gi.repository import Gegl
from gi.repository import GObject
from gi.repository import GLib
from gi.repository import Gio
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk
import glob
import sys


class MyFirstPlugin (Gimp.PlugIn):
    def do_query_procedures(self):
        return [ "for-gegl" ]

#  registration section

    def do_create_procedure(self, name):
        procedure = Gimp.ImageProcedure.new(self, name,
                                            Gimp.PDBProcType.PLUGIN,
                                            self.run, None)

        procedure.set_image_types("*")

        procedure.set_menu_label("for-gegl")
        procedure.add_menu_path('<Image>/Tools/')

        procedure.set_documentation("   ",
                                    "   ",
                                    name)
        procedure.set_attribution("name", "name", "date")

        return procedure

# end registration section

    def run(self, procedure, run_mode, image, drawables, config, run_data):

# Get the first layer of the first image
        image = Gimp.get_images()[0]
        layer = image.get_layers()[0]

#Create filter

#        filter = Gimp.DrawableFilter.new(layer, "gegl:c2g", "GEGL-example")

# Set properties (see https://gegl.org/operations/index.html)
#        filter_config = filter.get_config()
#        filter_config.set_property("enhance-shadows", True )

        Gimp.context_set_foreground(Gegl.Color.new("red"))
        Gimp.context_set_background(Gegl.Color.new("blue"))
        image = Gimp.Image.new(300, 400, Gimp.ImageBaseType.RGB)
        layer = Gimp.Layer.new(image, "layer 1", 300, 400, Gimp.ImageType.RGBA_IMAGE, 100, Gimp.LayerMode.NORMAL)
        image.insert_layer(layer, None, 0)
        layer.edit_fill(Gimp.FillType.BACKGROUND)
        Gimp.Display.new(image)
        Gimp.Image.select_rectangle(image, Gimp.ChannelOps.REPLACE, 60.0, 80.0, 100.0, 150.0)
        layer.edit_fill(Gimp.FillType.FOREGROUND)


# Apply filter
        layer.merge_filter (filter)


Gimp.main(MyFirstPlugin.__gtype__, sys.argv)
