#!/usr/bin/env gimp-script-fu-interpreter-3.0

(script-fu-register
    "script-fu-for-gegl"  ;func name
    "for-gegl "    ;menu label
    " "    ;description
    " "    ;author
    " "    ;copyright notice
    " "    ;date created
    "*"    ;image type that the script works on
    SF-IMAGE    "Image"                 0
    SF-DRAWABLE "Drawable"              0
)
(script-fu-menu-register "script-fu-for-gegl" "<Image>/Tools")
(define (script-fu-for-gegl image drawable)

    ;start
    (gimp-context-push)
    (gimp-image-undo-group-start image)
    
    ;put your procedures here

    (let (
        (new-layer (car (gimp-layer-new-from-visible image image "01")))
         )
        (gimp-image-insert-layer image new-layer -1)

        (gimp-drawable-merge-new-filter new-layer "gegl:tile-seamless" )

        (gimp-image-merge-down image new-layer 0)

    )
    
    ;finish
    (gimp-image-undo-group-end image)
    (gimp-context-pop)
    (gimp-displays-flush)
)



