# -*- coding: utf-8 -*-
#!/usr/bin/env python

import os, sys
from gimpfu import *

# The functions that do it, they will be called with image/layer
# set to the image/layer on which you call the script
# Technically, they can also be called with 'layer' being actually a "channel",
# (layers and channels are both "drawable") but you can't set the opacity
# on a channel and the script will croak. Not really a problem here.

def opacity60(image,layer):
    pdb.gimp_layer_set_opacity(layer, 60)

def opacity100(image,layer):
    pdb.gimp_layer_set_opacity(layer, 100)

### Registrations

# Not strictly necessary, but this tells you where the file with the script is
whoiam='\n'+os.path.abspath(sys.argv[0])

# When Gimp starts it calls this script which executes the two calls to the register() 
# function which themselves call Gimp and tell it what/how to call in this file.
# As you can see you can have two functions in one single file
register(
    'opacity60',    # identifier of the plugin. When defining keybaird shortcut, look for python-fu-opacity60
    'Set opacity to 60%'+whoiam,    # The help on the menu (tells where the script file is)
    'Set opacity to 60%',           # "Additional information" in the PDB browser
    'Me','Myself','2018',           # Copyright/author info, normally
    '60%',                          # the menu item 
    "RGB*, GRAY*",  # Enable only on RGB and grayscale image (wouldn't work on color-indexed)
    # The two parameters to the script, set automatically with current image/layer
    [
        (PF_IMAGE, "image", "Input image", None),
        (PF_DRAWABLE, "drawable", "Input drawable", None)
    ],
    [],
    opacity60,                      # the function above in "def opacity60(image,layer)..."
    menu="<Image>/Layer/Opacity",   # the menu in which you'll hjave the '60%' item above
)

# Barebones version for 100%
register(
    'opacity100','','','','','','100%','RGB*, GRAY*', 
    [(PF_IMAGE, "image", "Input image", None),(PF_DRAWABLE, "drawable", "Input drawable", None)],[],
    opacity100,menu="<Image>/Layer/Opacity" 
)

main()