#!/usr/bin/env python
from gimpfu import *
import random


def testBrushAsParm (inImage, inDrawable, inBrush, Run) :

   pdb.gimp_context_push()
   pdb.gimp_image_undo_group_start(inImage)
   
   # set parameters for drawing the lines
   pdb.gimp_context_set_brush (inBrush)
   pdb.gimp_paintbrush (inDrawable, 0, 4,(0,0,200,200), PAINT_CONSTANT, 0)
       
   pdb.gimp_image_undo_group_end(inImage)
   pdb.gimp_context_pop()
  

register(
   "testBrushAsParm",    
   "To test a Brush As Parameter",  
   "This script tests a Brush in the Parameters.",
   "Diego",
   "Diego Nassetti ",
   "2018",
   "testBrushAsParm",
   "RGB*",
   [
     (PF_IMAGE, "image", "Input image", None),
     (PF_DRAWABLE, "drawable", "Input drawable", None),
     (PF_BRUSH, "brush", "Brush to use", None),      
     (PF_TOGGLE, "test", "Does it run more than once?", False),    # fake parameter !
   ],
   [],
   testBrushAsParm,
   menu="<Image>/Test",
   )

main()