#!/usr/bin/env python
#-*- coding:utf-8 -*-

# Octave Sharpening v1.0
# Copyright (c) 2013 David Moreno
# dmc.coder@gmail.com
# Licence: GNU GPLv3  ( http://www.gnu.org/licenses/ )

# This program is distributed WITHOUT ANY WARRANTY.
# You using it in your own risk.

#Merging options.
MERGE_NONE = 0
MERGE_LAYERS = 1
MERGE_ALL = 2

def copy_layer (img, layer, name, pos):
	new_layer = pdb.gimp_layer_copy(layer, True)
	pdb.gimp_image_add_layer(img, new_layer, pos)
	pdb.gimp_drawable_set_name(new_layer, name)
	return new_layer

def plugin_main (img, lay, merge):
	pdb.gimp_image_undo_group_start(img)

	active_lay = pdb.gimp_image_get_active_layer(img)

	#Creates the 4 duplicates.
	c1 = copy_layer(img, active_lay, "1 - ratio: 0.5", -1)
	c2 = copy_layer(img, active_lay, "2 - ratio: 1.0", -1)
	c3 = copy_layer(img, active_lay, "3 - ratio: 2.0", -1)
	c4 = copy_layer(img, active_lay, "4 - ratio: 4.0", -1)

	#Applies the unsharp mask.
	pdb.plug_in_unsharp_mask(img, c1, 0.5, 5.0, 0)
	pdb.plug_in_unsharp_mask(img, c2, 1.0, 5.0, 0)
	pdb.plug_in_unsharp_mask(img, c3, 2.0, 5.0, 0)
	pdb.plug_in_unsharp_mask(img, c4, 4.0, 5.0, 0)

	#Sets the opacity.
	pdb.gimp_layer_set_opacity(c2, 50)
	pdb.gimp_layer_set_opacity(c3, 25)
	pdb.gimp_layer_set_opacity(c4, 12.5)

	#Merges the layers.
	if merge == MERGE_NONE:
		pdb.gimp_image_undo_group_end(img)
		return

	if merge == MERGE_ALL:
		octave_lay = pdb.gimp_image_merge_down(img, c1, CLIP_TO_IMAGE)

	octave_lay = pdb.gimp_image_merge_down(img, c2, CLIP_TO_IMAGE)
	octave_lay = pdb.gimp_image_merge_down(img, c3, CLIP_TO_IMAGE)
	octave_lay = pdb.gimp_image_merge_down(img, c4, CLIP_TO_IMAGE)
	pdb.gimp_drawable_set_name(octave_lay, "Octave Sharpening")

	pdb.gimp_image_undo_group_end(img)

try:
	from gimpfu import *
	register("Octave_Sharpening",
	         "Octave Sharpening",
	         "Sharpens the image using the Octave Sharpening method",
	         "David Moreno",
	         "2013 David Moreno",
	         "2013",
				"<Image>/Filters/Enhance/_Octave Sharpening...",
				"*",
				[
					(PF_OPTION, "merge", "Merge", MERGE_ALL, ["None", "Sharpening layers", "All"])
				],
				[],
				plugin_main)

	main()

except:
	pass
