#!/usr/bin/env python

#
# add_multiple_guides_plug.py - 2007 by Christian Nielebock (ravetracer@yahoo.de)
#
# This script allows you to set multiple guide lines in GIMP on given pixel position, horizontal and vertical.
# Just copy it under your home directory in .gimp-2.x/plugins (works with >=2.4) and chmod it for execution.
#
# This script is licensed under the CC-BY-SA Creative Commons License Version 3.0 !
# You can read about the license terms under: 
# 	(German) http://creativecommons.org/licenses/by-sa/3.0/deed.de
#	(English) http://creativecommons.org/licenses/by-sa/3.0/
#
# In case of modifications you have to leave the original author name an email address in this header information and the source code!
#
#
# history:
#
# 04.01.2008:
#	- initial release
#
# 05.01.2008:
#	- extended with GTK gui
#
# 09.01.2009:
#	- added possibility to set guides procentually
#	- set plugin under CC-BY-SA license

import gimp
import gimpplugin
from gimpenums import *
pdb = gimp.pdb

import pygtk
pygtk.require("2.0")
import gtk
import re

class add_guides_plugin(gimpplugin.plugin):
    def query(self):
        gimp.install_procedure("add_multiple_guides",
                               "This plugin sets several pixel precision guides",
                               "", "Christian Nielebock", "Christian Nielebock",
                   "2008", "<Image>/Image/Guides/Setup Multiple Guides...", "", PLUGIN,
                   [(PDB_INT32, "run_mode", "Run mode"),(PDB_IMAGE,"image","Image"),(PDB_DRAWABLE,"drawable","Drawable")], [])

    def __init__(self):
        self.lines = 0
        self.tableX = 4
        self.tableY = 1
        self.theWindow = gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.theWindow.set_title("Setup Multiple Guides")
        self.theWindow.set_resizable(False)
        self.theWindow.show()
        self.theWindow.connect("destroy",self.destroy)
        self.vbox = gtk.VBox(False,1)
        self.vbox.show()
        self.theWindow.add(self.vbox)
        self.mainTable = gtk.Table(self.tableY,self.tableX,True)
        self.mainTable.show()
        self.vbox.add(self.mainTable)
        self.hbuttonbox = gtk.HButtonBox()
        self.hbuttonbox.show()
        self.vbox.add(self.hbuttonbox)
	self.checkboxes = []
        self.labels = []
        self.entries = []
        self.combos = []
        self.theWindow.resize(200,50)

    def addline(self, widget):
        self.tableY+=1
        self.mainTable.resize(self.tableY,self.tableX)
        self.lines+=1

	# new Checkbox
	newcheck = gtk.CheckButton("Percentage?");
	newcheck.show()
	self.checkboxes.append(newcheck)

        # new Label
        newlabel = gtk.Label("Guideline " + str(self.lines))
        newlabel.show()
        self.labels.append(newlabel)

        # new Entry
        newentry = gtk.Entry(5)
        newentry.show()
        self.entries.append(newentry)	

        # new ComboBox
        newcombo = gtk.combo_box_new_text()
        newcombo.append_text("horizontal")
        newcombo.append_text("vertical")
        newcombo.set_active(0)
        newcombo.show()
        self.combos.append(newcombo)

	self.mainTable.attach(self.checkboxes[len(self.checkboxes)-1],0,1,self.tableY-2,self.tableY-1)
        self.mainTable.attach(self.labels[len(self.labels)-1],1,2,self.tableY-2,self.tableY-1)
        self.mainTable.attach(self.entries[len(self.entries)-1],2,3,self.tableY-2,self.tableY-1)
        self.mainTable.attach(self.combos[len(self.combos)-1],3,4,self.tableY-2,self.tableY-1)

    def delline(self,widget):
        if self.lines>1:
            self.lines-=1
	    self.checkboxes[len(self.checkboxes)-1].destroy()
            self.combos[len(self.combos)-1].destroy()
            self.entries[len(self.entries)-1].destroy()
            self.labels[len(self.labels)-1].destroy()
	    self.checkboxes.pop()
            self.combos.pop()
            self.entries.pop()
            self.labels.pop()
            self.tableY-=1
            self.mainTable.resize(self.tableY,self.tableX)
            self.theWindow.resize(300,100)

    def _checkstring(self,inputstring, chars):
        isok = True
        for x in range(len(inputstring)-1):
            if inputstring[x] not in chars:
                isok = False
        return isok

    def okbutton(self, widget):
        if self.lines>0:
            for a in range(self.lines):
                if self._checkstring(self.entries[a].get_text(),"0123456789"):
                    pos = int(self.entries[a].get_text())
                    hvtype = int(self.combos[a].get_active())
		    procents = int(self.checkboxes[a].get_active())
                    if hvtype==0:
			if procents==True:
			    if pos<0: pos=0
			    if pos>100: pos=100
			    pos = int(self.image.height * pos / 100)
			    
			if pos<0: pos=0
			if pos>self.image.height: pos=self.image.height
                        self.image.add_hguide(pos)
                    else:
			if procents==True:
			    if pos<0: pos=0
			    if pos>100: pos=100
			    pos = int(self.image.width * pos / 100)
			    
			if pos<0: pos=0
			if pos>self.image.width: pos=self.image.width
		        self.image.add_vguide(pos)
        gtk.main_quit()

    def quitbutton(self, widget):
        gtk.main_quit()

    def init_window(self):
        newbut0 = gtk.Button(None,gtk.STOCK_ADD)
        newbut0.connect("clicked",self.addline)
        newbut0.show()
        self.hbuttonbox.add(newbut0)
        newbut1 = gtk.Button(None,gtk.STOCK_REMOVE)
        newbut1.connect("clicked",self.delline)
        newbut1.show()
        self.hbuttonbox.add(newbut1)
        newbut2 = gtk.Button(None,gtk.STOCK_OK)
        newbut2.connect("clicked",self.okbutton)
        newbut2.show()
        self.hbuttonbox.add(newbut2)
        newbut3 = gtk.Button(None,gtk.STOCK_CANCEL)
        newbut3.connect("clicked",self.quitbutton)
        newbut3.show()
        self.hbuttonbox.add(newbut3)

    def add_multiple_guides(self,run_mode,image,drawable):
        self.image = image
        self.drawable = drawable
        self.init_window()
        self.addline(self.mainTable)
        gtk.main()

    def destroy(self, widget, data=None):
        gtk.main_quit()

if __name__ == "__main__":
    add_guides_plugin().start()
