; FU_sketch_line-sketch.scm
; version 2.7 [gimphelp.org]
; last modified/tested by Paul Sherman
; 05/05/2012 on GIMP-2.8
;
; 11/22/2007 - modified by Paul Sherman for GIMP 2.4
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 3 of the License, or
; (at your option) any later version.  
; 
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program; if not, you can view the GNU General Public
; License version 3 at the web site http://www.gnu.org/licenses/gpl-3.0.html
; Alternatively you can write to the Free Software Foundation, Inc., 675 Mass
; Ave, Cambridge, MA 02139, USA.
;
; ------------------------------------------------------------------
; Original information ---------------------------------------------
;
; Line Sketch script by kward1979uk
;
; End original information ------------------------------------------
;--------------------------------------------------------------------
; adjustments for gimp 2.10.6

(define (FU-line-sketch inimage indraw bg-colour)
	(define theImage inimage)
	(define theDraw indraw)
	(gimp-image-undo-group-start theImage)
	
	(define height (car (gimp-drawable-height theDraw)))
	(define width (car (gimp-drawable-width theDraw)))
;	(plug-in-edge 1 theImage theDraw 2 1 0) ; gimp 2.10
        (plug-in-edge 1 theImage theDraw 2 2 0)
	(gimp-drawable-equalize theDraw 0) ; gimp 2.10
	(gimp-drawable-desaturate theDraw 0) ; gimp 2.10
	(define highpass (car (gimp-layer-copy theDraw 1)))
	(gimp-image-insert-layer theImage highpass 0 1)
	(gimp-drawable-curves-spline highpass 0 18 #(0.0 0.0 0.7451 0.0 0.7461 0.0004 0.8203 0.8203 0.8593 0.8593 0.8984 0.8984 0.9375 0.9375 0.9766 0.9765 0.9961 0.9961 ))
	(gimp-drawable-invert theDraw FALSE) ; gimp 2.10
	(gimp-layer-add-alpha theDraw)
	(define imagemask (car (gimp-layer-create-mask theDraw 0)))
	(gimp-layer-add-mask theDraw imagemask)
	(gimp-edit-copy highpass)
	(define copy-paste (car (gimp-edit-paste imagemask 0)))
	(gimp-floating-sel-anchor copy-paste)
	(gimp-context-set-background bg-colour)
	(define background (car (gimp-layer-new theImage width height 1 "background" 100 0)))
	(gimp-drawable-fill background 1)
	(gimp-image-insert-layer theImage background 0 0)
	(gimp-image-remove-layer theImage highpass)
	(gimp-image-lower-item theImage background)

	(gimp-image-undo-group-end theImage)
	(gimp-displays-flush)
)

(script-fu-register "FU-line-sketch"
	"<Image>/Script-Fu/Sketch/Line Sketch"
	"Turns a image into a sketch.\n\nIf the image is a alpha layer it will be flattened first, background color is selectable."
	"Karl Ward"
	"Karl Ward"
	"Feb 2006"
	"RGB*"
	SF-IMAGE      	"SF-IMAGE" 0
	SF-DRAWABLE   	"SF-DRAWABLE" 0
	SF-COLOR		"Background Colour" '(255 255 255)		
)
