;;
;;   File        : gmic_shell.scm
;;               ( Scheme script for GIMP )
;; taken from    David Tschumperlé script
;; get gmic_gimp_qt plugin from www.gmic.eu


(define	(gmic-shell img drawable)

  ;; Start undo group.
  (gimp-image-undo-group-start img)

  (let* (
         (copy-layer (car (gimp-layer-copy drawable TRUE)))
        )

    ;; Add a copy of the layer to the image.
    (gimp-image-insert-layer img copy-layer 0 -1)

    ;;put your gmic commands in the following
;    (plug-in-gmic-qt 1 img drawable 1 0 "-v -99 uncomment & gmic command goes here")
    (plug-in-gmic-qt 1 img drawable 1 0 " -v -99 gcd_normalize_brightness 1.21,31,0.49,3,0,0")
    (plug-in-gmic-qt 1 img drawable 1 0 " -v -99 gcd_temp_balance 0.15,-0.06,1.23,2")



    (gimp-image-flatten img)
    
    )

  ;; Flush display.
  (gimp-displays-flush)

  ;; End undo group.
  (gimp-image-undo-group-end img)
  )

(script-fu-register "gmic-shell"
                    _"<Image>/Filters/G'MIC shell..."
                    ""
                    ""
                    ""
                    "2017"
                    "*"
                    SF-IMAGE		"Image"		1
                    SF-DRAWABLE         "Drawable"      1
                    )
