; RMA_label_points.scm
; by Rob Antonishen
; http://ffaat.pointclark.net

; Version 1.2 (20121217)

; Description
;
; Labels the points of the selected path
;

; Changelog
; v1.1 changed registration to GRAY from GREY
; v1.2 made striping spaces from custom labels an option.

; License:
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version. 
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; The GNU Public License is available at
; http://www.gnu.org/copyleft/gpl.html

(define (RMA_label_points img inPath inMethod inCustomText inStrip inFont inSize inOutlineMode inOutlineSize)
  (let*
    ((width (car (gimp-image-width img)))
	 (height (car (gimp-image-height img)))
	)
    
    (gimp-image-undo-group-start img)
    (gimp-context-push)
	
    ;there is an active vector/path
    (unless (equal? inPath -1)
      (let 
        ((strokelist (cadr (gimp-vectors-get-strokes inPath)))
         (numstrokes (vector-length (cadr (gimp-vectors-get-strokes inPath))))
		 (newLayer (car (gimp-layer-new img width height (car (gimp-drawable-type-with-alpha (car (gimp-image-get-active-layer img)))) "Labels" 100  NORMAL-MODE)))
         (points ())
         (counter 0)
         (numpoints 0)
		 (textLayer 0)
	 	 (textsize ())
		 (maxdia 0)
		 (pointlist ())
		 (labellist ()))
		 
        ; get all the points in the path as a ((x1 x1) (x2 y2) ...) list
        (while (< counter numstrokes)  ; for each stroke in the path
          (set! points (caddr (gimp-vectors-stroke-get-points inPath (vector-ref strokelist counter))))
          (set! numpoints (/ (cadr (gimp-vectors-stroke-get-points inPath (vector-ref strokelist counter))) 6))
 
          (let
            ((pcount 0))
		    (while (< pcount numpoints)
              (set! pointlist (append pointlist (list (list (vector-ref points (+ (* pcount 6) 2)) (vector-ref points (+ (* pcount 6) 3))))))
              (set! pcount (+ pcount 1))
            )
          )
          (set! counter (+ counter 1))
        ) 
        (set! numpoints (length pointlist) )
		
		
		;set up labels

		  (cond
		    ( (= inMethod 0) ; numeric
        	  (set! counter 0)
		      (while (< counter numpoints)
			    (set! labellist (append labellist (list (number->string (+ 1 counter)))))
			    (set! counter (+ counter 1))
			  )
			)
		    ( (= inMethod 1) ; alpha
        	  (set! counter 0)
		      (while (< counter numpoints)
  			    (set! labellist (append labellist (list (list-ref (list "A" "B" "C" "D" "E" "F" "G" "H" "I" "J" "K" "L" "M" "N" "O" "P" "Q" "R" "S" "T" "U" "V" "W" "X" "Y" "Z") (modulo counter 26) ))))	  
			    (set! counter (+ counter 1))
			  )
    		)
		    ( (= inMethod 2) ; custom
			  (let
			    ((sc 0)
				 (sl (string-length inCustomText))
				 (s "")
				 (c "")
				 (customlist ()))
				  (while (< sc sl)
				(set! c (substring inCustomText sc (+ sc 1)))
				(cond
  				      ( (equal? c ",") 
				        (set! customlist (append customlist (list s)))
					    (set! s "")
					  )
					  ( (and (equal? c " ") (equal? inStrip TRUE))
					  )
					  ( else 
   					    (set! s (string-append s c))
					  )
				    )
				    (set! sc (+ sc 1))
				  )

				(if (not (equal? s "")) (set! customlist (append customlist (list s))))
        	      (set! counter 0)
		          (while (< counter numpoints)
  			        (set! labellist (append labellist (list (list-ref customlist (modulo counter (length customlist))))))
			        (set! counter (+ counter 1))
			      ) 
    		  )
			)
          )
		  
		  (gimp-image-add-layer img newLayer -1)
		  (gimp-image-set-active-layer img newLayer)
		  
		  ; create text labels
		  (set! counter 0)
		  (while (< counter numpoints)
		    	
			(set! textLayer (car (gimp-text-fontname img -1 
			   (car (list-ref pointlist counter))
			   (cadr (list-ref pointlist counter))
			   (list-ref labellist counter)
			   0
			   TRUE ; antialiasing
			   inSize
			   0 ; PIXELS
			   inFont)))
            
			;set text to centered justification (only useful for multiline text)
			(gimp-text-layer-set-justification textLayer TEXT-JUSTIFY-CENTER)	
			
            ;calculate text size and offset
            (plug-in-autocrop-layer RUN-NONINTERACTIVE img textLayer)
            (set! textsize (list (car (gimp-drawable-width textLayer)) (car (gimp-drawable-height textLayer))))
            
            (gimp-layer-translate textLayer 
              (+ (/ (car textsize) -2) (- (car (list-ref pointlist counter)) (car (gimp-drawable-offsets textLayer)) )) 
              (+ (/ (cadr textsize) -2) (- (cadr (list-ref pointlist counter)) (cadr (gimp-drawable-offsets textLayer)) )))
            
            ;get max diagonal squared
			(if (< maxdia (+ (* (car textsize)(car textsize)) (* (cadr textsize)(cadr textsize)))) (set! maxdia (+ (* (car textsize)(car textsize)) (* (cadr textsize)(cadr textsize)))))
			   
			(set! newLayer (car (gimp-image-merge-down img textLayer CLIP-TO-IMAGE)))
			 
		 	(set! counter (+ counter 1))
          )
		  
		  (set! maxdia (round (+ (/ (sqrt maxdia) 2) inOutlineSize )))
		  
		  ;bg fill labels
		  (cond
		    ( (= inOutlineMode 1)
			  (gimp-selection-layer-alpha newLayer)
			  (gimp-selection-grow img inOutlineSize)
			  (gimp-edit-bucket-fill newLayer BG-BUCKET-FILL BEHIND-MODE 100 0 FALSE 0 0)
			  (gimp-selection-none img)
	        )
		    ( (= inOutlineMode 2)
			  (gimp-selection-layer-alpha newLayer)
			  (gimp-selection-grow img inOutlineSize)
			  (gimp-selection-feather img inOutlineSize)
			  (gimp-edit-bucket-fill newLayer BG-BUCKET-FILL BEHIND-MODE 100 0 FALSE 0 0)
			  (gimp-selection-none img)	        
			)
		    ( (= inOutlineMode 3)
  		      (set! counter 0)
			  (gimp-selection-none img)	        
		      (while (< counter numpoints)
			    (gimp-ellipse-select img (- (car (list-ref pointlist counter)) maxdia) (- (cadr (list-ref pointlist counter)) maxdia) (+ (* 2 maxdia) 1) (+ (* 2 maxdia) 1) CHANNEL-OP-ADD TRUE FALSE 0)
				(set! counter (+ counter 1))
			  )
 		      (gimp-edit-bucket-fill newLayer BG-BUCKET-FILL BEHIND-MODE 100 0 FALSE 0 0)
			  (gimp-selection-none img)	        
			)
          )
	  )   
    )

  	(gimp-displays-flush)
	(gimp-context-pop)
  	(gimp-image-undo-group-end img)
  )
)

(script-fu-register "RMA_label_points"
        		    "Label Path Points..."
                    "Label the points along a path. text is FG colour, outline or circle is BG colour."
                    "Rob Antonishen"
                    "Rob Antonishen"
                    "Feb 2012"
                    "RGB*, GRAY*"
                    SF-IMAGE      "image"              0
                    SF-VECTORS    "path"               0
	                SF-OPTION	  "Method"		       (list "Numeric" "Alphabetic" "Custom - Below")
					SF-TEXT       "Custom labels (comma seperated)"    "1,2,3,4a,4b,4c,5,6,7"
					SF-TOGGLE     "Strip Spaces from Custom Labels"    TRUE
					SF-FONT       "Font"                "sans"
                    SF-ADJUSTMENT "Text Size"          (list 32 1 100 1 10 0 SF-SLIDER)								
                    SF-OPTION	  "Outline"            (list "None" "Hard Outline" "Soft Outline" "Circle")
                    SF-ADJUSTMENT "Outline Size"       (list 3 1 100 1 10 0 SF-SLIDER)					
)

(script-fu-menu-register "RMA_label_points"
                         "<Vectors>")