#!/usr/bin/env python
# Author: Kevin Payne
# Copyright 2011 Kevin Payne
# License: GPL v3
# GIMP plugin to export the layers of an .xcf as png images
#  each png file has the name of the layer
# For PhotoComix:- http://gimpchat.com/viewtopic.php?f=9&t=985

from gimpfu import *
import os.path
import pygtk
import gtk

# something to help with debugging
def debugMessage(Message):
    dialog = gtk.MessageDialog(None, 0, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, Message)
    dialog.run()
    dialog.hide()

# unique_filename from http://stackoverflow.com/questions/183480/is-this-the-best-way-to-get-unique-version-of-filename-w-python
def unique_filename(file_name):
    counter = 1
    file_name_parts = os.path.splitext(file_name) # returns ('/path/file', '.ext')
    while os.path.isfile(file_name): 
      file_name = file_name_parts[0] + '_' + str(counter) + file_name_parts[1]
      counter += 1
    return file_name

# this is the bit that does all the work
def export_layers_as_jpg(img):
    layer_ids = img.layers                         # get the layers in the image
    directory_name = os.path.dirname(img.filename) # where is the source image
    
#    debugMessage(directory_name)
    
    num_layers = len(layer_ids)                    
    for layer_num in range (0, num_layers):        # work through layers (change to "num_layers-1" if you don't want the bottom layer)
      layer_name = pdb.gimp_drawable_get_name(layer_ids[layer_num])  
#      debugMessage(layer_name)
      
      # replace any illegal characters to be on the safe side
      layer_name = layer_name.replace(":", ";")
      layer_name = layer_name.replace("/", ";")
      layer_name = layer_name.replace("\\", ";")
      layer_name = layer_name.replace("?", ";")
      layer_name = layer_name.replace("*", ";")
      layer_name = layer_name.replace("\"", ";")
      
#      debugMessage(layer_name)

      # build the new file path - puts the saved layers in the same place as the source image
      jpg_file = os.path.join(directory_name, layer_name + ".jpg")
      jpg_file = unique_filename(jpg_file)

#      debugMessage(png_file)      
#      pdb.file_png_save2(img, layer_ids[layer_num], png_file, png_file, 1, 9, 1, 1, 0, 1, 1, 1, 1)
      pdb.file_jpeg_save(img, layer_ids[layer_num], jpg_file, jpg_file, 0.85, 0, 0, 0, "morph", 2, 1, 0, 0)

      # The End of the main routine


# menu registration
register(
    "python-fu-export-layers-as-png",
    "Export Layers as jpegs",
    "Export Layers as jpegs",
    "paynekj",
    "GimpChat",
    "12.01.2011",
    "Export Layers as separate jpegs", 
    "*",
    [
         (PF_IMAGE, "image",       "Input image", None),
    ],
    [],
    export_layers_as_jpg,
    menu="<Image>/Layer/layers-as-jpgs"
    )

main()
