;script-fu auto-rotate
;author : Hevan53
;version 3
;You can use this script like in the version 2, by simply adding a stroke with the path tool and, as usual, go to /Layer/Auto rotate.
;You can also add two strokes (in the same vector object). If you use this method the image will be rotated
;along this second line (if you draw the first line this will be parallel to the second after the rotation).
;note : each stroke you draw can contain more than 2 points (the script will only take the first and the last)

(define (script-fu-auto-rotate inImage inDrawable)

  (define PI (* 4 (atan 1)))

  (define (gimp-message-and-quit message)
    (let ( (old-handler (car (gimp-message-get-handler))) );get your handler type
      (gimp-message-set-handler MESSAGE-BOX)
      (gimp-message message)
      (gimp-message-set-handler old-handler);set handler to your handler type
      (quit)))

  (define (get-stroke-angle vectors-object stroke-id)
    (let* ( (r-gvsgp (gimp-vectors-stroke-get-points vectors-object stroke-id));r-gvsgp : result of gimp-vectors-stroke-get-points
            (num-controlpoints (cadr r-gvsgp)) )
      (if (< num-controlpoints 12)
        #f
        (let* ( (controlpoints (caddr r-gvsgp))
                (x0 (vector-ref controlpoints 2))
                (y0 (vector-ref controlpoints 3))
                (x1 (vector-ref controlpoints (- num-controlpoints 4)))
                (y1 (vector-ref controlpoints (- num-controlpoints 3)))
                ;mathematical vector defined by a for x and b for y
                (a (- x1 x0))
                (b (- y1 y0))
                ;angle of the vector in [-pi/2 ; pi/2]
                (teta (cond
                        ((and (= a 0) (= b 0)) #f);if a and b = 0 this mean that the 2 points of the vector are in the same place
                        ((= a 0) (/ PI 2));a = 0 means that the vector is a vertical line
                        (else (atan (/ b a))))) )
          teta))))

  (define (give-angles)
    (let ( (vectors-object (car (gimp-image-get-active-vectors inImage))) )
      (if (= vectors-object -1)
        (gimp-message-and-quit "There are no paths in the image! Please create one stroke or more on one path.")
        (let* ( (r-gvgs (gimp-vectors-get-strokes vectors-object))
                (num-strokes (car r-gvgs))
                (stroke-ids (cadr r-gvgs))
                (teta 0)
                (list-tetas '())
                (num-tetas 0) )
          (if (= num-strokes 0)
            (gimp-message-and-quit "There are no strokes in the path.")
            (do ( (i 0 (+ i 1)) )
              ((or (= i num-strokes) (= num-tetas 2)) )
              (set! teta (get-stroke-angle vectors-object (vector-ref stroke-ids i)))
              (if (not (eq? teta #f))
                (begin
                  (set! list-tetas (cons teta list-tetas))
                  (set! num-tetas (+ num-tetas 1))))))
          (list num-tetas list-tetas)))))

  (define (rotate teta) (gimp-item-transform-rotate inDrawable teta TRUE 0 0))

  (let* ( (r-ga (give-angles))
          (num-tetas (car r-ga))
          (list-tetas (cadr r-ga)) )
    (case num-tetas
      ((0) (gimp-message-and-quit "There are no usables strokes in the path. The path must contain one or two usables strokes. By \"usable\" I mean that each stroke must have, at least, two points."))
      ((1) (let ( (teta (car list-tetas)) (pi/2 (/ PI 2)) (pi/4 (/ PI 4)) )
             (cond
               ((and (> teta (- pi/2)) (< teta (- pi/4)))                (rotate (- (+ pi/2 teta))))
               ((and (>= teta (- pi/4)) (<= teta pi/4) (not (= teta 0))) (rotate (- teta)))
               ((and (> teta pi/4) (< teta pi/2))                        (rotate (- pi/2 teta))))))
      ((2) (let* ( (teta-base (car list-tetas))
                   (teta-to-correct (cadr list-tetas))
                   (delta-tetas (let ( (delta (- teta-base teta-to-correct)) )
                                  (if (> (abs delta) (/ PI 2))
                                    (cond
                                      ((> delta 0) (- delta PI))
                                      ((< delta 0) (+ PI delta)))
                                    delta))) )
             (rotate delta-tetas))))
    (gimp-displays-flush))

)

(script-fu-register
        "script-fu-auto-rotate"
        "Auto rotate"
        ""
        "Hevan53"
        "Hevan53"
        "2011"
        "*"

        SF-IMAGE    "Image"    0
        SF-DRAWABLE "Drawable" 0
)

(script-fu-menu-register "script-fu-auto-rotate" "<Image>/Layer")
