#!/usr/bin/env python
from gimpfu import *
import os
import platform
import time
import datetime

############################################################################
# include, then use: erro_msg or info_msg
#---------------------------------------------------------------------------
def erro_msg (msg):
    ###
    currenth = pdb.gimp_message_get_handler()
    pdb.gimp_message_set_handler(0) # box
    info_msg ("ERROR: "+msg)
    pdb.gimp_message_set_handler(currenth) # current
    ###
def info_msg (msg):
    ###
    currenth = pdb.gimp_message_get_handler()
    pdb.gimp_message_set_handler(2) # error console
    info_msg ("INFO: "+msg)
    pdb.gimp_message_set_handler(currenth) # current
    ###
    
############################################################################
#   MAIN
#--------------------------------------------------------------------------- 

def Mosaic_Stained_Glass_QT210 (inImage, inLayer,
                             widthheight, 
                             glassPattern, metalPattern,
                             skyGradient,  lightOrigin,
                             inNrCol, inLeadCol,
                             preferredBG,
                             embellishOpt, 
                             doFlatten) :
   
    # image characteristics
    width = inImage.width
    height = inImage.height
    basetype = inImage.base_type
    name = inLayer.name
    if '.' in name:
        split = name.split(".", 1)
        name = split[0]
    suffix = " as a stained glass mosaic "    
    
    ts = time.time()
    st = datetime.datetime.fromtimestamp(ts).strftime('%Y-%m-%d %H-%M-%S')
    
    # calculate scale factor for the new output image
    if widthheight == 0 :    # keep original dimensions
        scale = 1
    else :    
        optiWidthHeight = widthheight       # size to work on to get best results
        realWidthHeight = width+height      # real size of the input image
        scale = (optiWidthHeight*1.0)/(realWidthHeight*1.0)      # ratio for scaling

    pdb.gimp_context_push()
    
    # fix all required context settings 
    pdb.gimp_context_set_antialias (False)
    pdb.gimp_context_set_feather (False)
    pdb.gimp_context_set_sample_criterion (0)
    pdb.gimp_context_set_sample_merged (False)
    pdb.gimp_context_set_sample_threshold (0.01)
    pdb.gimp_context_set_sample_transparent (False)
    
    # detect system running
    systemrunning = platform.system()
    if systemrunning <> "Windows" :
        info_msg ("info: I am running "+systemrunning)
    # simulate non Windows to test alternatives
    # systemrunning = "whoknows"
    # info_msg ("I am simulating "+systemrunning)
    
    originalname = pdb.gimp_item_get_name (inLayer)
    # calculate work image width and height dimensions
    
    # set the new image dimensions
    newWidth=int(width*scale)
    newHeight=int(height*scale)
    #info_msg ("OUT sizes " +str(newWidth) +"," +str(newHeight))
    
    newImage = pdb.gimp_image_new(newWidth, newHeight, RGB)
    BG = pdb.gimp_layer_new_from_drawable(inLayer, newImage)     # background layer
    BG.name = "BG: Background Layer"
    BG.mode = LAYER_MODE_NORMAL     
    BG.opacity = 100.0 
    newImage.add_layer(BG, 0)
    pdb.gimp_item_transform_scale(BG, 0, 0, newWidth, newHeight)      # rescale BG
    
    # save original before any modification
    origBG = pdb.gimp_edit_named_copy (BG, "original:"+originalname)
    
    # shift black and white pixels
     
    lowestValue=0.06
    highestValue=0.94
    # decide which centre-value depending on the MeanValue of Original
    (meanValue, stdDev, median, pix, cnt, perc) = pdb.gimp_drawable_histogram (BG,
                                                  HISTOGRAM_VALUE, 0.0, 1.0)
    if meanValue<0.4: newCentre=1.11
    elif meanValue>0.6: newCentre=0.90
    else: newCentre=1.00
    pdb.gimp_drawable_levels(BG, HISTOGRAM_VALUE, 0.0, 1.0, False, newCentre, lowestValue, highestValue, False)     
    
    #pdb.gimp_display_new (newImage)
    #return()

    adjuBG = pdb.gimp_edit_named_copy (BG, "adjusted colours:"+originalname)
    
    # pre-processing
    # --------------
    Preprocessed = pdb.gimp_layer_new_from_drawable(BG, newImage) 
    Preprocessed.name = "Preprocessed: Layer smoothed thru Gaussian blur"
    Preprocessed.mode = LAYER_MODE_NORMAL    # 2.10
    Preprocessed.opacity = 100.0 
    newImage.add_layer(Preprocessed, 0)
    
    # 1.preprocess: sel-blur and blur
    pdb.plug_in_sel_gauss (newImage, Preprocessed, 16, 48)
    pdb.plug_in_gauss_iir2 (newImage, Preprocessed, newWidth/200, newHeight/200)
    
    #pdb.gimp_display_new (newImage)
    #return()
    
    # 2.step:  quantize the colour_areas using mode indexed on a duplicated image (WORK)
    # =================================================================================================== 

    WORK_IMAGE = pdb.gimp_image_duplicate (newImage)                
    WORK_DRAWABLE = WORK_IMAGE.active_layer                         
    WORK_DRAWABLE.name = "BG Layer"
    # change image mode to indexed (this produces a cartoonized image, nrAreas colors)
    pdb.gimp_image_convert_indexed (WORK_IMAGE, 0, 0, inNrCol, 0, 0, "ignored")    # INPUT   <<<<<<<< 
    # get the number of pixels in the colormap (which exists for indexed images)
    (count, colors) = pdb.gimp_image_get_colormap (WORK_IMAGE)
    nr_areas = (count/3) 
    areas_palette = pdb.gimp_palette_new(pdb.gimp_image_get_name (WORK_IMAGE))
    index = 0
    while index < count:
    # Compute the color
        color = (colors[index], colors[index+1], colors[index+2])
    # Add to the filter temporary palette
        pdb.gimp_palette_add_entry (areas_palette, str(index/3), color)
        index+=3
    # Endwhile index<count
    # the temporary palette has been created            
    # re-set image to RGB to proceed
    pdb.gimp_image_convert_rgb (WORK_IMAGE)
    pdb.gimp_layer_add_alpha (WORK_DRAWABLE)                        #  RGBA
    # ===================================================================================================
    
    Cartoonized = pdb.gimp_layer_new_from_drawable (WORK_DRAWABLE, newImage)
    newImage.add_layer (Cartoonized, 0)
    Cartoonized.name = "Cartoonized: Layer cartonized thru a work step using Indexed Mode"
    
    #pdb.gimp_display_new (newImage)
    #return()
    
    # 3.step: G'MIC Inpaint Holes with additional removal of small areas
        # + [G'MIC] Inpaint [holes]: -fx_inpaint_holes 20,20,1
    pdb.plug_in_gmic_qt(newImage, Cartoonized, 1,0 ,
        "-v - -fx_inpaint_holes "
        +str(100)
        +",20,1")
    
    #pdb.gimp_display_new (newImage)
    #return()
    
    # 4.step: Contours
    Contoured = Cartoonized.copy()    
    newImage.add_layer (Contoured, 0)
    Contoured.mode = LAYER_MODE_NORMAL          
    Contoured.name = "Contoured: Layer for Contours"
    Contoured.opacity = 100.0      
    
    areaNR = 0
    area_color = []   # empty list
    for areaNR in range (0, nr_areas):
        one_color = pdb.gimp_palette_entry_get_color (areas_palette, areaNR)
        pdb.gimp_image_select_color (newImage, CHANNEL_OP_REPLACE, Cartoonized, one_color)
        pdb.gimp_selection_border (newImage, 2)   
        pdb.gimp_context_set_background (inLeadCol)
        pdb.gimp_edit_fill (Contoured, FILL_BACKGROUND)
            
    #info_msg ("end loop")
    pdb.gimp_selection_none (newImage)
    
    #pdb.gimp_display_new (newImage)
    #return()
    
    pdb.gimp_image_select_color (newImage, CHANNEL_OP_REPLACE, Contoured, (inLeadCol))
    GN_selection = pdb.gimp_selection_save (newImage)   # selection of the areas boundaries
    pdb.gimp_selection_invert (newImage)
    pdb.gimp_edit_cut (Contoured)
    Contoured.name = "Contoured: Layer for Contours, with user chosen colour"
    pdb.gimp_image_select_item (newImage, CHANNEL_OP_REPLACE, GN_selection)
    
    #pdb.gimp_display_new (newImage)
    #return()

    #######################################################################################
    # to add cracks (pattern on the whole image, instead of color by color)
    #--------------------------------------------------------------------------------------
    
    Cracked = pdb.gimp_layer_new_from_drawable(Preprocessed, newImage) 
    Cracked.name = "Cracked: Cracks Layer"
    Cracked.mode = LAYER_MODE_NORMAL     
    Cracked.opacity = 100.0                                  
    newImage.add_layer(Cracked, 0)
    #pdb.gimp_context_set_pattern ("blackontransp2000.png")
    pdb.gimp_selection_all (newImage)
    #pdb.gimp_edit_clear (Cracked)   # no more need for the colour of the area
    pdb.gimp_drawable_edit_fill (Cracked, FILL_WHITE)    # cracks on white
    Cracked = newImage.active_layer
    (R,G,B,T) = inLeadCol
    if (newWidth + newHeight) > 6750 :
        density =  8
    elif (newWidth + newHeight) > 4500 :
        density =  12
    elif (newWidth + newHeight) > 3000 :
        density =  16
    elif (newWidth + newHeight) > 2000 :
        density =  20
    else :
        density = 24

    pdb.plug_in_gmic_qt(newImage, Cracked, 1,0 ,
         # [G'MIC] Cracks: -fx_cracks 16,0,5,15,30,255,0,0
         #                               d   R  G  B  T
         "-v - -fx_cracks "
         +str(density)
         +",0,"
         +str(R)
         +","
         +str(G)
         +","
         +str(B)
         +","
         +str(T)
         +",0,0")
    Cracked = newImage.active_layer

    pdb.plug_in_erode (newImage, Cracked, 1, HISTOGRAM_VALUE, 1.0, 7, 0, 128)
    pdb.plug_in_erode (newImage, Cracked, 1, HISTOGRAM_VALUE, 1.0, 7, 0, 128)
    '''
    if (newWidth + newHeight) > 2000 :
        pdb.plug_in_erode (newImage, Cracked, 1, HISTOGRAM_VALUE, 1.0, 7, 0, 128)
    if (newWidth + newHeight) > 4000 :
        pdb.plug_in_erode (newImage, Cracked, 1, HISTOGRAM_VALUE, 1.0, 7, 0, 128)
    if (newWidth + newHeight) > 6000 :
        pdb.plug_in_erode (newImage, Cracked, 1, HISTOGRAM_VALUE, 1.0, 7, 0, 128)
    '''    
    pdb.gimp_layer_add_alpha (Cracked)    
    pdb.plug_in_colortoalpha (newImage, Cracked, ((255,255,255,255)))
    
    #pdb.gimp_display_new (newImage)
    #return()
    
    CracksContours = pdb.gimp_image_merge_down (newImage, Cracked, CLIP_TO_IMAGE)
    CracksContours.name = "CracksContours: Layer for Contours and Cracks, merged"
    
    #pdb.gimp_display_new (newImage)
    #return()
    
    pdb.gimp_image_select_color (newImage, CHANNEL_OP_REPLACE, CracksContours, (R,G,B,T))
    CC_selection = pdb.gimp_selection_save (newImage)   # selection of all the cracks and contours
    
    pdb.gimp_selection_invert (newImage)                # switch to return to the tiles area
    TT_selection = pdb.gimp_selection_save (newImage)   # selection of all the tiles
    
    #pdb.gimp_display_new (newImage)
    #return()

    # embellishment of lights and colour
    # ----------------------------------
    # plasma layer
    Plasma = pdb.gimp_layer_new(newImage, newWidth, newHeight, RGBA_IMAGE,
                                        "Plasma: Layer for plasma overlay", 25.0, LAYER_MODE_OVERLAY)    
    newImage.add_layer(Plasma, 0)
    Plasma = newImage.active_layer
    pdb.gimp_image_select_item (newImage, CHANNEL_OP_REPLACE, TT_selection)
    pdb.plug_in_plasma(newImage, Plasma, 17, 3.3)
    
    #pdb.gimp_display_new (newImage)
    #return()
    
    # glass pattern layer
    Pattern = pdb.gimp_layer_new(newImage, newWidth, newHeight, RGBA_IMAGE,
                                        "Pattern: Layer for Glass pattern", 55.0, LAYER_MODE_VIVID_LIGHT)    
    newImage.add_layer(Pattern, 0)
    Pattern = newImage.active_layer
    
    pdb.gimp_context_set_pattern(glassPattern)
    pdb.gimp_image_select_item (newImage, CHANNEL_OP_REPLACE, TT_selection) # to be safe
    pdb.gimp_drawable_edit_fill(Pattern, FILL_PATTERN)    
    
    #pdb.gimp_display_new (newImage)
    #return()
    
    Bokeh = pdb.gimp_layer_new_from_visible(newImage, newImage, "Bokeh: Layer for Bokeh effect")
    Bokeh.opacity = 100.00
    Bokeh.mode = LAYER_MODE_NORMAL # 2.10
    newImage.add_layer(Bokeh, 0)
    Bokeh = newImage.active_layer
    pdb.gimp_image_select_item (newImage, CHANNEL_OP_REPLACE, TT_selection) # to be safe
    
    # WARNING! the Bokeh filter works ONLY if the underlying layer is in LAYER_MODE_NORMAL and 100.0% OPACITY !!!
    # !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    pdb.plug_in_gmic_qt(newImage, Bokeh, 1,0 ,
                  #[G'MIC] Bokeh: -fx_bokeh 3,8,0,30,8,4,0.3,0.2,210,210,80,160,0.7,30,20,20,1,2,170,130,20,110,0.15,0
                  "-v - -fx_bokeh 3,8,0,50,8,4,0.3,0.2,247,120,29,200,0.7,5,18,9,1,2,233,230,11,200,0.15,0")
    Bokeh = newImage.active_layer
    # NOW we set opacity and mode as we like
    Bokeh.opacity = 18.00
    Bokeh.mode = LAYER_MODE_VIVID_LIGHT  
    
    #pdb.gimp_display_new (newImage)
    #return()
    
    SkyLayer=pdb.gimp_layer_new(newImage, newWidth, newHeight, RGBA_IMAGE,
                                   "Sky Layer", 5.00, LAYER_MODE_DISSOLVE)   
    newImage.add_layer(SkyLayer, 0)
    SkyLayer = newImage.active_layer
    
    # sky
    if (lightOrigin==0):    # none
            fromX = 0
            fromY = 0 
            toX = 0
            toY = 0 
            gradType = 0          # gradient-linear
    elif (lightOrigin==1):    # top left
           fromX = -newWidth/4 
           fromY = -newHeight/4 
           toX = newWidth 
           toY = newHeight 
           gradType = 2          # gradient-radial
    elif (lightOrigin==2):   # top centre
           fromX = (newWidth/2) 
           fromY = -newHeight/4 
           toX = (newWidth/2) 
           toY = newHeight 
           gradType = 2          # gradient-radial
    elif (lightOrigin==3):   # top right
           fromX = newWidth*5/4  
           fromY = -newHeight/4 
           toX = 0 
           toY = newHeight 
           gradType = 2          # gradient-radial
    elif (lightOrigin==4):   # centre left
           fromX = -newWidth/4   
           fromY = (newHeight/2) 
           toX = newWidth 
           toY = (newHeight/2)
           gradType = 2          # gradient-radial
    elif (lightOrigin==5):   # centre centre
           fromX = (newWidth/2)  
           fromY = (newHeight/2) 
           toX = (newWidth/2) 
           toY = newHeight
           gradType = 2          # gradient-radial
    elif (lightOrigin==6):   # centre right
           fromX = newWidth*5/4   
           fromY = (newHeight/2) 
           toX = 0 
           toY = (newHeight/2)
           gradType = 2          # gradient-radial
    elif (lightOrigin==7):   # bottom left
           fromX = -newWidth/4   
           fromY = newHeight*5/4  
           toX = newWidth
           toY = 0
           gradType = 2          # gradient-radial
    elif (lightOrigin==8):   # bottom centre
           fromX = (newWidth/2)  
           fromY = newHeight*5/4 
           toX = (newWidth/2)
           toY = 0
           gradType = 2          # gradient-radial
    elif (lightOrigin==9):   # bottom right
           fromX = newWidth*5/4 
           fromY = newHeight*5/4  
           toX = 0
           toY = 0
           gradType = 2          # gradient-radial
             
    pdb.gimp_context_set_gradient(skyGradient)
    pdb.gimp_image_select_item (newImage, CHANNEL_OP_REPLACE, TT_selection) # to be safe
    if (lightOrigin>0):    # not none
        pdb.gimp_edit_blend(SkyLayer, 
        3, 				    	 # CUSTOM 
        0,                       # NORMAL MODE
        gradType, 				 # gradient type
        100,                     # opacity
        0,                       # offset
        0,                       # REPEAT-NONE
        True,                    # reverse
        False,                   # no supersampling
        0,                       # supers recursions
        0,                       # supers threshold
        False,                   # no dithering
        fromX,					 # x1 
        fromY,       			 # y1 
        toX,				     # x2
        toY)				     # y2
    
    #pdb.gimp_display_new (newImage)
    #return()
    
    pdb.gimp_selection_none (newImage)
    
    # reduce opacity of the cartoonised layer to let original transpare below
    Cartoonized.opacity = 60.0
    Cartoonized.mode = LAYER_MODE_HARDLIGHT    
    
    # for Preprocessed Layer first analyze user's choice
    if preferredBG == 0 :          # preprocessed only
        pdb.gimp_layer_set_mode (Preprocessed, LAYER_MODE_NORMAL)  
        pdb.gimp_layer_set_opacity (Preprocessed, 100.0)
    elif preferredBG == 2 :        # original only        
        pdb.gimp_item_set_visible (Preprocessed, False)
    else :                         #preprocessed & original  
        # decide which Mode and Opacity depending on the MeanValue of Original
        (meanValue, stdDev, median, pix, cnt, perc) = pdb.gimp_drawable_histogram (BG,
                                                                    HISTOGRAM_VALUE, 0, 1)   # 2.10
        #info_msg ("meanValue = "+str(meanValue))
        if meanValue < 107 :    # dark  
            pdb.gimp_layer_set_mode (Preprocessed, LAYER_MODE_SCREEN)   # 2.10
            pdb.gimp_layer_set_opacity (Preprocessed, 70.0)
        elif meanValue > 203 :    # light  
            pdb.gimp_layer_set_mode (Preprocessed, LAYER_MODE_BURN)   # 2.10
            pdb.gimp_layer_set_opacity (Preprocessed, 80.0)
        else :  # average      
            pdb.gimp_layer_set_mode (Preprocessed, LAYER_MODE_HARDLIGHT)   # 2.10
            pdb.gimp_layer_set_opacity (Preprocessed, 80.0)
    
    TopLayer = newImage.layers[0]  
     
    BorderSize=int((newWidth+newHeight)/10)  
    BorderLayer = pdb.gimp_layer_new (newImage, newWidth+BorderSize, newHeight+BorderSize,
                                      RGBA_IMAGE, "Frame", 100.0, LAYER_MODE_NORMAL)
    newImage.add_layer (BorderLayer, 0)
    pdb.gimp_layer_set_offsets(BorderLayer, -BorderSize/2, -BorderSize/2)
    pdb.gimp_image_resize_to_layers (newImage)
    pdb.gimp_selection_all (newImage)
    
    #pdb.gimp_display_new(newImage) 
    #return
    
    pdb.gimp_context_set_foreground ((60,60,85))    #((50,50,70))
    pdb.gimp_context_set_background ((30,30,42))    #((15,15,21))
    pdb.gimp_context_set_gradient ("FG to BG (Hardedge)")
     
    pdb.gimp_drawable_edit_gradient_fill (BorderLayer, GRADIENT_CONICAL_ASYMMETRIC ,0.0, False,0,0,False,
                                              newImage.width, 0, 0, newImage.height)
    pdb.plug_in_gauss_iir2 (newImage, BorderLayer, newImage.width/30, newImage.height/30)
    pdb.gimp_image_select_rectangle (newImage, CHANNEL_OP_REPLACE,
                                     BorderSize/2, BorderSize/2, newWidth, newHeight)
    pdb.gimp_edit_cut (BorderLayer)
    pdb.gimp_selection_invert (newImage)
    
    #pdb.gimp_display_new(newImage) 
    #return
    
    BorderLayer2 = BorderLayer.copy()
    newImage.add_layer (BorderLayer2, 0)
    BorderLayer2.mode = LAYER_MODE_GRAIN_MERGE
    BorderLayer2.opacity = 80.0

    pdb.gimp_context_set_pattern (metalPattern)
    pdb.gimp_drawable_edit_fill(BorderLayer2, FILL_PATTERN)    
    
    #pdb.gimp_display_new(newImage) 
    #return
    
    # we restore here the original BG
    floatBG = pdb.gimp_edit_named_paste (BG, origBG, False)
    pdb.gimp_floating_sel_anchor (floatBG)
    
    # analyze request of the user concerning the embellishments
    if embellishOpt == 0 :        # none
        pdb.gimp_item_set_visible (Plasma, False)
        pdb.gimp_item_set_visible (Pattern, False)
        pdb.gimp_item_set_visible (Bokeh, False)
        pdb.gimp_item_set_visible (SkyLayer, False)
    elif embellishOpt == 1 :      # low
        pdb.gimp_layer_set_opacity (Plasma, 33.3)
        pdb.gimp_layer_set_opacity (Pattern, 33.3)
        pdb.gimp_layer_set_opacity (Bokeh, 11.0)
        pdb.gimp_layer_set_opacity (SkyLayer, 3.5)
    else :                        #  full, confirm
        pdb.gimp_layer_set_opacity (Plasma, 66.0)
        pdb.gimp_layer_set_opacity (Pattern, 66.0)
        pdb.gimp_layer_set_opacity (Bokeh, 22.0)
        pdb.gimp_layer_set_opacity (SkyLayer, 7.0)
    
        
    if (doFlatten == True) :
        pdb.gimp_image_flatten(newImage)
        flattenedLayer = pdb.gimp_image_get_active_layer (newImage)
    else:
        flattenedLayer = pdb.gimp_layer_new_from_visible(newImage, newImage, st+" "+name+suffix)
        newImage.add_layer (flattenedLayer, 0)
    pdb.gimp_drawable_brightness_contrast (flattenedLayer, 0.0, +0.10)     
        
    pdb.gimp_item_set_name(flattenedLayer, st+" "+name+suffix)

    pdb.gimp_context_pop()
    
    pdb.gimp_display_new(newImage) 
    return (flattenedLayer)

register(
    "Mosaic_Stained_Glass_QT210",
    "to create a mosaic with stained glass from an image (gmic QT, gimp 2.10)",   
    "This script takes an image and transform it into a stained glass mosaic (gmic QT, gimp 2.10)",
    "Diego", 
    "Diego Nassetti ", 
    "2018",
    "Mosaic Stained Glass QT210 (using G'MIC QT and gimp 2.10)",
    "RGB*",
    [
      (PF_IMAGE, "image", "Input image", None),
      (PF_DRAWABLE, "drawable", "Input drawable", None),
      (PF_ADJUSTMENT, "size", "Width+Height of New Image", 3600, (0, 9600, 300)),
      (PF_PATTERN, "glass_pattern", "Glass pattern (select one)","DopeCrystals04seamless.jpg"),   # non std, should be provided
      (PF_PATTERN, "frame_pattern", "Frame pattern (select one)", "Granite #1"),
      (PF_GRADIENT, "sky_gradient", "Sky gradient (light on the right)", "Neon Yellow"),
      (PF_OPTION, "light_origin", "Light origin", 1, ("none","Top left","Top centre","Top right",
                                                      "Centre left","Centre centre","Centre right",
                                                      "Bottom left","Bottom centre","Bottom right")),
      (PF_ADJUSTMENT, "colours", "Nr of colours", 11, (5, 32, 1)),
      (PF_COLOR,"lead_col", "Colour of the lead junctions",  ((12,16,32,255))),
      (PF_OPTION, "bg", "BG preference", 1, ("preprocessed only","preproc. & original", "original only")),
      (PF_OPTION, "embellish", "Embellishment Strength", 1, ("none","low","full")),
      (PF_TOGGLE, "flatten", "Flatten Image?", True),

    ],
    [],
    Mosaic_Stained_Glass_QT210,
    menu="<Image>/Diego/Mosaic"
    )
main()
