#!/usr/bin/env python

# david2_lum_mask.py
# following the steps described on this link's pdf by david: https://gimplearn.net/viewtopic.php?p=29419#p29419
# Created by Tin Tran https://gimplearn.net
# Comments directed to https://gimplearn.net
#
# After being created, that ungrateful wretch, david, modified it by adding layers LLLL.
# DDDD and replacing M with a medium dark (MD) and medium light (ML).
#
# License: GPLv3
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# To view a copy of the GNU General Public License
# visit: http://www.gnu.org/licenses/gpl.html
#
#
# ------------
#| Change Log |
# ------------
# Rel 1: Initial release.
# Rel 2: DM 23 November 2019.
#import Image
from gimpfu import *
def python_david2_lum_mask(image, layer) :
	pdb.gimp_image_undo_group_start(image)
	pdb.gimp_context_push()
	
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)			#make drawable in order to desaturate (source, destination)
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)				#(image, layer, parent, position)
	pdb.gimp_drawable_equalize(layer_copy, TRUE)
	pdb.gimp_drawable_desaturate(layer_copy,DESATURATE_LUMINANCE)			#(drawable, destination)

	#copy Red channel as L1
	channel_L1 = pdb.gimp_channel_new_from_component(image,CHANNEL_RED,"L1")	#(image to add channel, component, channel name)
	pdb.gimp_image_insert_channel(image,channel_L1,None,0)				#(image, channel, parent, position)

	#create D1 from Alpha subtract L1						ALPHA = desaturated image(?)
	channel_D1 = pdb.gimp_channel_new_from_component(image,CHANNEL_ALPHA,"D1")
	pdb.gimp_image_insert_channel(image,channel_D1,None,0)
	pdb.gimp_channel_combine_masks(channel_D1,channel_L1,CHANNEL_OP_SUBTRACT,0,0)	#(channel1, channel2,operation, offsets x&Y)

	#create DD1 from Alpha - L1 - L1
	channel_DD1 = pdb.gimp_channel_new_from_component(image,CHANNEL_ALPHA,"DD1")
	pdb.gimp_image_insert_channel(image,channel_DD1,None,0)
	pdb.gimp_channel_combine_masks(channel_DD1,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_DD1,channel_L1,CHANNEL_OP_SUBTRACT,0,0)

	#create DDD1 from Alpha - L1 - L1 - L1
	channel_DDD1 = pdb.gimp_channel_new_from_component(image,CHANNEL_ALPHA,"DDD1")
	pdb.gimp_image_insert_channel(image,channel_DDD1,None,0)
	pdb.gimp_channel_combine_masks(channel_DDD1,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_DDD1,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_DDD1,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	
	#create DDDD1 from Alpha - L1 - L1 - L1 - L1 
	channel_DDDD1 = pdb.gimp_channel_new_from_component(image,CHANNEL_ALPHA,"DDDD1")
	pdb.gimp_image_insert_channel(image,channel_DDDD1,None,0)
	pdb.gimp_channel_combine_masks(channel_DDDD1,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_DDDD1,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_DDDD1,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_DDDD1,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	
	#create DDDD from Alpha - L1 - L1 - L1 - L1 - L1 
	channel_DDDD = pdb.gimp_channel_new_from_component(image,CHANNEL_ALPHA,"DDDD")
	pdb.gimp_image_insert_channel(image,channel_DDDD,None,0)
	pdb.gimp_channel_combine_masks(channel_DDDD,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_DDDD,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_DDDD,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_DDDD,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_DDDD,channel_L1,CHANNEL_OP_SUBTRACT,0,0)
		
	#create LL1 from RED_CHANNEL - D1
	channel_LL1 = pdb.gimp_channel_new_from_component(image,CHANNEL_RED,"LL1")
	pdb.gimp_image_insert_channel(image,channel_LL1,None,0)
	pdb.gimp_channel_combine_masks(channel_LL1,channel_D1,CHANNEL_OP_SUBTRACT,0,0)

	#create LLL1 from RED_CHANNEL - D1 -D1 
	channel_LLL1 = pdb.gimp_channel_new_from_component(image,CHANNEL_RED,"LLL1")
	pdb.gimp_image_insert_channel(image,channel_LLL1,None,0)
	pdb.gimp_channel_combine_masks(channel_LLL1,channel_D1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_LLL1,channel_D1,CHANNEL_OP_SUBTRACT,0,0)
	
	#create LLLL1 from RED_CHANNEL - D1 -D1 -D1 
	channel_LLLL1 = pdb.gimp_channel_new_from_component(image,CHANNEL_RED,"LLLL1")
	pdb.gimp_image_insert_channel(image,channel_LLLL1,None,0)
	pdb.gimp_channel_combine_masks(channel_LLLL1,channel_D1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_LLLL1,channel_D1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_LLLL1,channel_D1,CHANNEL_OP_SUBTRACT,0,0)
	
	#create LLLL from RED_CHANNEL - D1 -D1 -D1 -D1 
	channel_LLLL = pdb.gimp_channel_new_from_component(image,CHANNEL_RED,"LLLL")
	pdb.gimp_image_insert_channel(image,channel_LLLL,None,0)
	pdb.gimp_channel_combine_masks(channel_LLLL,channel_D1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_LLLL,channel_D1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_LLLL,channel_D1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_LLLL,channel_D1,CHANNEL_OP_SUBTRACT,0,0)

	#create ML from D1 - DD1 - DD1
	channel_ML = pdb.gimp_channel_copy(channel_D1)
	pdb.gimp_image_insert_channel(image,channel_ML,None,0)
	pdb.gimp_item_set_name(channel_ML,"ML")
	pdb.gimp_channel_combine_masks(channel_ML,channel_DD1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_ML,channel_DD1,CHANNEL_OP_SUBTRACT,0,0)
	
	#create MD from L1 - LL1 - LL1
	channel_MD = pdb.gimp_channel_copy(channel_L1)
	pdb.gimp_image_insert_channel(image,channel_MD,None,0)
	pdb.gimp_item_set_name(channel_MD,"MD")
	pdb.gimp_channel_combine_masks(channel_MD,channel_LL1,CHANNEL_OP_SUBTRACT,0,0)
	pdb.gimp_channel_combine_masks(channel_MD,channel_LL1,CHANNEL_OP_SUBTRACT,0,0)
	
	#create D from DD1 - DDD1
	channel_D = pdb.gimp_channel_copy(channel_DD1)
	pdb.gimp_image_insert_channel(image,channel_D,None,0)
	pdb.gimp_item_set_name(channel_D,"D")
	pdb.gimp_channel_combine_masks(channel_D,channel_DDD1,CHANNEL_OP_SUBTRACT,0,0)

	#create DD from DDD1 - DDDD1
	channel_DD = pdb.gimp_channel_copy(channel_DDD1)
	pdb.gimp_image_insert_channel(image,channel_DD,None,0)
	pdb.gimp_item_set_name(channel_DD,"DD")
	pdb.gimp_channel_combine_masks(channel_DD,channel_DDDD1,CHANNEL_OP_SUBTRACT,0,0)
	
	#create DDD from DDDD1 - DDDD
	channel_DDD = pdb.gimp_channel_copy(channel_DDDD1)
	pdb.gimp_image_insert_channel(image,channel_DDD,None,0)
	pdb.gimp_item_set_name(channel_DDD,"DDD")
	pdb.gimp_channel_combine_masks(channel_DDD,channel_DDDD,CHANNEL_OP_SUBTRACT,0,0)
	
	#create L from LL1 - LLL1
	channel_L = pdb.gimp_channel_copy(channel_LL1)
	pdb.gimp_image_insert_channel(image,channel_L,None,0)
	pdb.gimp_item_set_name(channel_L,"L")
	pdb.gimp_channel_combine_masks(channel_L,channel_LLL1,CHANNEL_OP_SUBTRACT,0,0)

	#create LL from LLL1 - LLLL1
	channel_LL = pdb.gimp_channel_copy(channel_LLL1)
	pdb.gimp_image_insert_channel(image,channel_LL,None,0)
	pdb.gimp_item_set_name(channel_LL,"LL")
	pdb.gimp_channel_combine_masks(channel_LL,channel_LLLL1,CHANNEL_OP_SUBTRACT,0,0)
	
	#create LLL from LLLL1 - LLLL
	channel_LLL = pdb.gimp_channel_copy(channel_LLLL1)
	pdb.gimp_image_insert_channel(image,channel_LLL,None,0)
	pdb.gimp_item_set_name(channel_LLL,"LLL")
	pdb.gimp_channel_combine_masks(channel_LLL,channel_LLLL,CHANNEL_OP_SUBTRACT,0,0)
	
	pdb.gimp_selection_none(image)
	pdb.gimp_image_remove_layer(image,layer_copy)


	#create layer with DDDD as mask
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,channel_DDDD)
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)
	pdb.gimp_item_set_name(layer_copy,"DDDD")
	pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	mask = pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	pdb.gimp_layer_add_mask(layer_copy,mask)


	#create layer with DDD as mask
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,channel_DDD)
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)
	pdb.gimp_item_set_name(layer_copy,"DDD")
	pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	mask = pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	pdb.gimp_layer_add_mask(layer_copy,mask)

	#create layer with DD as mask
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,channel_DD)
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)
	pdb.gimp_item_set_name(layer_copy,"DD")
	pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	mask = pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	pdb.gimp_layer_add_mask(layer_copy,mask)

	#create layer with D as mask
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,channel_D)
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)
	pdb.gimp_item_set_name(layer_copy,"D")
	pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	mask = pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	pdb.gimp_layer_add_mask(layer_copy,mask)

	#create layer with MD as mask
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,channel_MD)
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)
	pdb.gimp_item_set_name(layer_copy,"MD")
	pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	mask = pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	pdb.gimp_layer_add_mask(layer_copy,mask)
	
	#create layer with ML as mask
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,channel_ML)
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)
	pdb.gimp_item_set_name(layer_copy,"ML")
	pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	mask = pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	pdb.gimp_layer_add_mask(layer_copy,mask)
	
	#create layer with L as mask
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,channel_L)
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)
	pdb.gimp_item_set_name(layer_copy,"L")
	pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	mask = pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	pdb.gimp_layer_add_mask(layer_copy,mask)

	#create layer with LL as mask
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,channel_LL)
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)
	pdb.gimp_item_set_name(layer_copy,"LL")
	pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	mask = pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	pdb.gimp_layer_add_mask(layer_copy,mask)

	#create layer with LLL as mask
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,channel_LLL)
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)
	pdb.gimp_item_set_name(layer_copy,"LLL")
	pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	mask = pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	pdb.gimp_layer_add_mask(layer_copy,mask)
	
	#create layer with LLLL as mask
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,channel_LLLL)
	layer_copy = pdb.gimp_layer_new_from_drawable(layer,image)
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)
	pdb.gimp_item_set_name(layer_copy,"LLLL")
	pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	mask = pdb.gimp_layer_create_mask(layer_copy,ADD_MASK_SELECTION)
	pdb.gimp_layer_add_mask(layer_copy,mask)
	
	#remove all channels
	pdb.gimp_image_remove_channel(image,channel_L1)
	pdb.gimp_image_remove_channel(image,channel_LL1)
	pdb.gimp_image_remove_channel(image,channel_LLL1)
	pdb.gimp_image_remove_channel(image,channel_LLLL1)
	pdb.gimp_image_remove_channel(image,channel_L)
	pdb.gimp_image_remove_channel(image,channel_LL)
	pdb.gimp_image_remove_channel(image,channel_LLL)
	pdb.gimp_image_remove_channel(image,channel_LLLL)
	pdb.gimp_image_remove_channel(image,channel_D1)
	pdb.gimp_image_remove_channel(image,channel_DD1)
	pdb.gimp_image_remove_channel(image,channel_DDD1)
	pdb.gimp_image_remove_channel(image,channel_DDDD1)
	pdb.gimp_image_remove_channel(image,channel_D)
	pdb.gimp_image_remove_channel(image,channel_DD)
	pdb.gimp_image_remove_channel(image,channel_DDD)
	pdb.gimp_image_remove_channel(image,channel_DDDD)
	pdb.gimp_image_remove_channel(image,channel_ML)
	pdb.gimp_image_remove_channel(image,channel_MD)

	pdb.gimp_selection_none(image)

	pdb.gimp_context_pop()
	pdb.gimp_image_undo_group_end(image)
	pdb.gimp_displays_flush()


register(
	"python_fu_david2_lum_mask",
	"Create Luminosity Masks",
	"Create Luminosity Masks",
	"David Marsden",
	"David Marsden",
	"December 2019",
	"<Image>/Python-Fu/David2 Luminosity Masks...",             #Menu path
	"RGB*, GRAY*", 
	[
	#(PF_OPTION,"option",   "Mapping:", 0, ["To Circle","To Square"]),
	],
	[],
	python_david2_lum_mask)

main()
