#!/usr/bin/env python
# -*- coding: utf-8 -*-

# GIMP plugin to crop charts, keeping information on the borders (graticule...)

# (c) Ofnuts 2019
#
#   History:
#
#   v0.0: 2019-12-25: Initial version
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import sys, os
from gimpfu import *

finalWidth=2000
finalHeight=3300
levelsBlack=50
levelsWhite=200
levelsGamma=.5


def crop(image,layer):
    hasSelection,xl,yt,xr,yb= pdb.gimp_selection_bounds(image)
    if not hasSelection:
        raise Exception('No selection')
    
    w=xr-xl
    h=yb-yt
    
    # new top corner for crop
    xlc=xl-(finalWidth-w)/2
    ytc=yt-(finalHeight-h)/2 # double negative
    pdb.gimp_image_crop(image, finalWidth,finalHeight,xlc,ytc)
    
def enhance(image,layer):
    pdb.gimp_selection_none(image)
    pdb.gimp_image_convert_grayscale(image)
    pdb.gimp_drawable_levels(layer,HISTOGRAM_VALUE,levelsBlack/255.,levelsWhite/255.,False,levelsGamma,0.,1.,False)

def cropAndEnhance(image,drawable):
    image.undo_group_start()
    try:
        crop(image,drawable)
        enhance(image,drawable)
        
    except Exception as e:
        print e.args[0]
        pdb.gimp_message(e.args[0])
    image.undo_group_end()

### Registration
whoiam='\n'+os.path.abspath(sys.argv[0])
author='Ofnuts'
menu='<Image>/Filters/Enhance/'
copyrightYear='2014'
cropAndEnhanceDesc='Crop and enhance layer'

register(
    'gimpy222-crop-and-enhance',
    cropAndEnhanceDesc+whoiam,cropAndEnhanceDesc,
    author,author,
    copyrightYear,
    'Crop and enhance scanned page...',
    '*',
    [
        (PF_IMAGE, 'image', 'Input image', None),
        (PF_DRAWABLE, 'drawable', 'Input drawable', None),
    ],
    [],
    cropAndEnhance,
    menu=menu
)

main()
