; Bevel Reflect Logo V1.6
; 
; Requires GIMP 2.8.x (or higher)
;
; Created by GnuTux 
; Comments directed to http://gimpchat.com or http://gimpscripts.com
;
; Official Support Thread: http://gimpchat.com/viewtopic.php?f=9&t=9650
; Downloaded From GIMP Scripts: http://gimpscripts.com/2014/02/bevel-reflect-logo/  
; 
;
; License: GPLv3
;    This program is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation, either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;    GNU General Public License for more details.
;
;    To view a copy of the GNU General Public License
;    visit: http://www.gnu.org/licenses/gpl.html
;
; ------------
;| Change Log |
; ----------------------------------------------------------
; V1.0 - Official Release
; V1.1 - User Sets Spherical EMap Size
;        User Controlled Edge Smoothing
;        Fixed Manual Selection Bugs
;        Moved Interactive Select to Bevel Slope Dropdown
; V1.2 - Add Contour Curves Option To Alpha To Logo Section
; V1.3 - Check To Ensure ML Bevel Reflect Plug-in Installed
;        Replace Several Depreciated GIMP V2.6 Procedures 
;        Eliminate Extraneous Lines Created by ML BR Plugin
;                  As suggested by Graechan
; V1.4 - Expand Text Options In Create Logo Section
;        Add Option for Solid Color Spherical Emap
;        Add Option for Light Direction (rotate spherical emap)
;        Add Option For Specular Highlight
; V1.5 - Add Bevel Slope Depth Options To Support ML Bevel Reflect V2.0
;        Allow 45 Degree Increments For Light Direction 
; V1.6 - Correct Issue With Gradient FG-BG (Forgot to Restore Change in FG Color)   
;
;-----------------------------------------------------------
;
;
; Define Apply Contour Procedure
;
(define (apply-curves layer contour)
  (let* (
          (contour (- contour 1))                                              ; Adjust contour index  
          (curve_num_segments #(6 6 6 18 8 8 8 8 18 16 14 14))                 ; Number of Segments Per Curve x2 (pair)
          (curve_xy                                                            ; Curve XY pairs
           #(
             #(0 0 127 255 255 0)                                              ; Cone Mid Bevel
             #(0 0 02 255 255 0)                                               ; Cone Inner Bevel
             #(0 0 250 255 255 0)                                              ; Cone Outer Bevel
             #(0 0 33 8 64 38 97 102 128 166 158 209 191 235 222 247 255 255)  ; Step Bevel
             #(0 0 16 255 32 0 125 255)                                        ; Ring Narrow
             #(0 0 64 255 127 0 255 255)                                       ; Ring Medium
             #(0 0 95 255 250 0 255 255)                                       ; Ring Wide
             #(0 0 95 255 253 0 255 255)                                       ; Ring Extra Wide
             #(0 0 33 110 64 237 97 240 128 138 158 33 191 5 222 99 255 255)   ; Ring Thick
             #(0 0 42 255 43 0 80 32 151 255 164 0 223 60 255 255)             ; Double Ring 
             #(0 0 26 255 27 0 79 255 108 0 160 255 255 255)                   ; Double Ring (Narrow)
             #(0 0 26 255 27 0 152 255 162 0 237 59 255 255)                   ; Double Ring (Wide)
            )
          )
        ) 
;
;       Apply the curve   
        (gimp-curves-spline layer HISTOGRAM-ALPHA (vector-ref curve_num_segments contour) (vector-ref curve_xy contour))

  ) ;end let
) ; end define apply-curves
;
;
;
; Display Message 
;
; 
(define (display_message 
                 text_message                              ; Message to display
                 output_destination                        ; MESSAGE-BOX (0), CONSOLE (1), ERROR-CONSOLE (2)
        )
   (let* (
          (handler_state (car (gimp-message-get-handler))) ; Save current message handler state
         )
          (gimp-message-set-handler output_destination)    ; Set message handler to the desired output destination    
          (gimp-message text_message)                      ; Display the message
          (gimp-message-set-handler handler_state)         ; Restore message handler to saved state 
   ) ;end let
) ; end define display-message procedure
;
;
; Define the apply logo ml-bevel-reflect-logo procedure
;
(define (apply-ml-bevel-reflect-logo 
                             img                     ; Image
                             logo-layer              ; Input Layer
                             bevel-slope             ; Bevel Slope
                             slope-smoothing         ; Slope Smoothing
                             flat-depth              ; Flat Slope Depth
                             round1-depth            ; Round1 Slope Depth
                             round2-depth            ; Round2 SLope Depth  
                             diffusion               ; Diffusion
                             contour                 ; Contour
                             blur-depth              ; Blur Depth
                             edge-smoothing          ; Edge Smoothing Amount
                             emap-name               ; Environment Map Name
                             map-type                ; Environment Map Type
                             paint-mode              ; Selected Paint Mode For Use WIth Blend Plug-in
                             blend-direction         ; Blend Direction
                             blend-shape             ; Blend Shape
                             emap-gradient           ; Selected Gradient For Environment Map
                             light-direction         ; Light Direction Falling Onto Spherical Map
                             spec                    ; Specular Highlights
                             detail-level            ; Detail Level For Solid Noise Plug-in 
                             texturesizex            ; Drawable Width
                             texturesizey            ; Drawable Height
                             emap-size               ; Spherical Emap Final Size
                             blur-radius             ; Gaussian Blur Radius 
                             auto-hsv                ; Autostretch HSV Flag
                             turbulent               ; Turbulance Flag
                             keep-layers)            ; Keep Spherical Map & BR Logo/Selection Copy Layers 

  (let* (
           (emap-img -1)        ; Environment Map Image
           (emap-drawable -1)   ; Environment Map Drawable 
           (bumptext-layer -1)  ; Bump Text Layer
           (bumpmap-layer -1)   ; Bumpmap Layer
           (copytext-layer -1)  ; Copy of Text layer
           (saved-selection -1) ; Saved Selection
           (saved-flag FALSE)   ; Saved Selection Flag
           (sel-flag TRUE)      ; Selection Is Empty Flag
           (act-lay-pos -1)     ; Current Slected Layer Position
           (invert-bump FALSE)  ; Inverted Bump Map
           (interactive 1)      ; ML Bevel Reflect Interactive Flag
           (edge-blur 3)        ; Edge Smoothing Blur
           (image-height 0)     ; Image Height
           (image-width 0)      ; Image Width
           (xblend-start 0)     ; X Blend Starting Point
           (yblend-start 0)     ; X Blend Starting Point
           (xblend-end 0)       ; X Blend Ending Point
           (yblend-end 0)       ; X Blend Ending Point
           (emap-name-len)      ; Length of Emap Filename
           (emap-name-pos)      ; Position of Substring in Emap Filename
           (parent -1)          ; Parent of drawable
           (saved-fg-color (car (gimp-context-get-foreground img))) ; Save Foreground Color 
        )

;
;
;

   (set! parent (car (gimp-item-get-parent logo-layer))) ; Get Parent of current drawable
;
; Selection Check
;
   (set! sel-flag (car (gimp-selection-is-empty img)))  ; Set incoming selection flag

    (if (= sel-flag FALSE)                                                ; Check for a selection 
        (begin
           (set! saved-selection (car (gimp-selection-save img)))         ; Save selection
           (gimp-selection-none img)                                      ; Clear selection
           (set! saved-flag TRUE)                                         ; Set Saved Selecion Flag
        )
     ) ; endif
;
; Save Active Layer Position
; 
(set! act-lay-pos (car (gimp-image-get-item-position img logo-layer))) 

;
; Create Bump Map & Save As Layer
;
     (set! copytext-layer (car (gimp-layer-new-from-drawable logo-layer img))) ; Copy of Logo Layer
     (set! bumpmap-layer (car (gimp-layer-new-from-drawable logo-layer img)))  ; BG for bumpmap
     (gimp-image-insert-layer img bumpmap-layer parent act-lay-pos)            ; Add it to image
     (gimp-item-set-name bumpmap-layer "BR Logo")                              ; Name bumpmap
     (gimp-edit-clear bumpmap-layer)                                           ; Clear Layer
     (gimp-selection-all img)                                                  ; Select Layer
     (gimp-context-set-foreground '(255 255 255))                              ; Color to White
     (gimp-edit-bucket-fill bumpmap-layer 0 0 100 0 0 0 0)                     ; Fill with color
     (gimp-selection-none img)                                                 ; No Selection
     (gimp-item-set-visible bumpmap-layer TRUE)                                ; Turn on Bumpmap Layer    
     (set! bumptext-layer (car (gimp-layer-new-from-drawable logo-layer img))) ; Text for bumpmap
     (gimp-image-insert-layer img bumptext-layer parent act-lay-pos)           ; Add it to image
     (gimp-context-set-foreground saved-fg-color)                              ; Restore Foreground Color 
;
; Clear Away Outside of Selecion
;
    (if (= saved-flag TRUE)                         ; Check For A Saved Selection 
        (begin
           (gimp-selection-load saved-selection)    ; Restore Selection Before Emapping
           (gimp-selection-invert img)              ; Invert the selection
           (gimp-edit-clear bumptext-layer)         ; Clear outside selection
           (gimp-selection-invert img)              ; Invert the selection
           (gimp-selection-none img)                ; Clear selection
        )
     ) ; endif

;
;  Gausian Blur For Curves
;
     (if (> blur-depth 0)
       (begin  

         (plug-in-colorify 1 img bumptext-layer '(255 255 255))                ; Color for alpha curves

         (plug-in-gauss                ; Gaussien blur the shadow (radius blur)
                1                      ; Non-interactive 
                img                    ; Image to apply blur 
                bumptext-layer         ; Layer to apply blur
                blur-depth             ; Blur Radius x  
                blur-depth             ; Blue Radius y 
                1)                     ; Method (IIR=0 RLE=1)

         (if (> contour 0) (apply-curves bumptext-layer contour))              ; Apply contour if necessary      
         (gimp-image-set-active-layer img bumptext-layer)                      ; Make Bumptext layer active

       )
     );Endif


     (plug-in-colorify 1 img bumptext-layer '(0 0 0))                         ; Ensure Drawable BLACK for ML Bevel Reflect
     (gimp-item-set-name bumptext-layer "Bump Text")                          ; Name bumpmap
     (gimp-item-set-visible bumptext-layer TRUE)                              ; Turn on Bumpmap Layer    

     (set! bumpmap-layer (car (gimp-image-merge-down img bumptext-layer 0)))  ; Merge Down Text
     (gimp-invert bumpmap-layer)                                              ; Invert it

;
; Load Environment Map If Specified
;
;
; Notes on strings: (substring "xyz" 0 3) returns xyz 
;                   (substring-equal? "png" "xyz.png" 4 7) returns true
;                   (string-length "ABC") returns 3
;
(set! emap-name-len (string-length emap-name))         ; Length of the emap Filename
(set! emap-name-pos (- (string-length emap-name) 3))   ; Length of the emap filename minus 3 (postition of file extension) 


(if (or (substring-equal? "png" emap-name emap-name-pos emap-name-len) ; Validity Check png
        (substring-equal? "PNG" emap-name emap-name-pos emap-name-len) ; Validity Check PNG
        (substring-equal? "jpg" emap-name emap-name-pos emap-name-len) ; Validity Check jpg
        (substring-equal? "JPG" emap-name emap-name-pos emap-name-len) ; Validity Check JPG
    ) 
      (begin
        (set! emap-img (car (gimp-file-load RUN-NONINTERACTIVE emap-name emap-name))) ; Load emap
        (set! emap-drawable (car (gimp-image-get-active-drawable emap-img)))          ; Emap Drawable 
      ) ;else
      (begin
;
;       Generate An Environment Map if one is not manually loaded 
;
        (set! emap-drawable (car (gimp-layer-new-from-drawable logo-layer img))) ; Add Layer for Emap
        (gimp-image-insert-layer img emap-drawable parent (+ act-lay-pos 1))     ; Add it to image
        (gimp-image-set-active-layer img emap-drawable)                          ; Make layer Active
        (gimp-layer-resize emap-drawable (+ emap-size 40) (+ emap-size 40) 0 0)  ; Spherical Map Size (40 autocrop fudge)
        (gimp-item-set-visible emap-drawable FALSE)                              ; Turn off emap Layer    
;
;       Call Solid Noise Plug-in
;
        (set! *seed* (car (gettimeofday))) ; Random Number Seed From Clock (*seed* is global)
        (random-next)                      ; Next Random Seed

        (plug-in-solid-noise 
                       1         ; Non-Interactive
                     img         ; Input Image
           emap-drawable         ; Imput Drawable
                    TRUE         ; Tileable
               turbulent         ; Turbulent Noise
           (random-next)         ; Random Seed
            detail-level         ; Detail Level
            texturesizex         ; Horizontal Texture Size
            texturesizey         ; Vertical Texture Size
        )

;
; Auto-stretch HSV
;
     (if (= auto-hsv TRUE)
         (begin  
           (plug-in-autostretch-hsv 1 img emap-drawable)
         )
     ) ;endif

;
; Gaussian Blur
;
    (plug-in-gauss                 
                 1     ; Non-Interactive 
               img     ; Image to apply blur 
     emap-drawable     ; Layer to apply blur
                 5     ; Blur Radius x  
                 5     ; Blue Radius y 
                 0     ; Method (IIR=0 RLE=1)
    )

;
; Set Specified Gradient Active Unless Active Gradient Is Selected
;
(if (< map-type 2)
    (begin  
       (gimp-context-set-gradient emap-gradient)
     )
) ;endif

;
; Environment Map Type: Topographical
;
(if (or (= map-type 0) (= map-type 2))
    (begin  
      (plug-in-gradmap 1 img emap-drawable)                ; Map Gradient
      (gimp-item-set-name emap-drawable "Spherical Topo")  ; Name it
     )
) ;endif

;
; Environment Map Type: Cloud
;
(if (or (> paint-mode 0) (= map-type 1) (= map-type 3))
    (begin  

     (set! image-height (car (gimp-drawable-height emap-drawable)))     ; Get Height 
     (set! image-width (car (gimp-drawable-width emap-drawable)))       ; Get Width

;
; Calculate Gradient Blend Start & End Points
;

      (cond ((= blend-direction 0)         ; Top-Bottom 
          (set! xblend-start 0)            ; X Blend Starting Point
          (set! yblend-start 0)            ; Y Blend Starting Point
          (set! xblend-end 0)              ; X Blend Ending Point
          (set! yblend-end image-height)   ; Y Blend Ending Point
          )
          ((= blend-direction 1)           ; Bottom-Top
          (set! xblend-start 0)            ; X Blend Starting Point
          (set! yblend-start image-height) ; Y Blend Starting Point
          (set! xblend-end 0)              ; X Blend Ending Point
          (set! yblend-end 0)              ; Y Blend Ending Point
          )
          ((= blend-direction 2)           ; Left-Right
          (set! xblend-start 0)            ; X Blend Starting Point
          (set! yblend-start 0)            ; Y Blend Starting Point
          (set! xblend-end image-width)    ; X Blend Ending Point
          (set! yblend-end 0)              ; Y Blend Ending Point
          )
          ((= blend-direction 3)           ; Right-Left
          (set! xblend-start image-width)  ; X Blend Starting Point
          (set! yblend-start 0)            ; Y Blend Starting Point
          (set! xblend-end 0)              ; X Blend Ending Point
          (set! yblend-end 0)              ; Y Blend Ending Point
          )
          ((= blend-direction 4)           ; Diag-Top-Left
          (set! xblend-start 0)            ; X Blend Starting Point
          (set! yblend-start 0)            ; Y Blend Starting Point
          (set! xblend-end image-width)    ; X Blend Ending Point
          (set! yblend-end image-height)   ; Y Blend Ending Point
          )
          ((= blend-direction 5)           ; Diag-Top-Right
          (set! xblend-start image-width)  ; X Blend Starting Point
          (set! yblend-start 0)            ; Y Blend Starting Point
          (set! xblend-end 0)              ; X Blend Ending Point
          (set! yblend-end image-height)   ; Y Blend Ending Point
          )
          ((= blend-direction 6)           ; Diag-Bottom-Left
          (set! xblend-start 0)            ; X Blend Starting Point
          (set! yblend-start image-height) ; Y Blend Starting Point
          (set! xblend-end image-width)    ; X Blend Ending Point
          (set! yblend-end 0)              ; Y Blend Ending Point
          )
          ((= blend-direction 7)           ; Diag-Bottom-Right
          (set! xblend-start image-width)  ; X Blend Starting Point
          (set! yblend-start image-height) ; Y Blend Starting Point
          (set! xblend-end 0)              ; X Blend Ending Point
          (set! yblend-end 0)              ; Y Blend Ending Point
          )
;          (else
;                 ; For later use.. 
;          )
       ) ;end cond

;
; Check Paint Mode
;
     (if (and (= paint-mode 0) (or (= map-type 1) (= map-type 3)))
            (begin  
              (set! paint-mode 4)   ; Normal Makes No Sense For Cloud Map So Set To Screen As Default
            )
      ) ;endif

       (gimp-edit-blend              ; Blend (Gradient)
                      emap-drawable  ; Drawable - (The affected drawable)
                        CUSTOM       ; Int32 - Blend Type (FG-BG-RGB-MODE (0))
                        paint-mode   ; Int32 - Paint Mode (NORMAL-MODE (0)) 
                        blend-shape  ; Int32 - Gradient Type (LINEAR (0))
                        100          ; Float - Opacity (0 - 100)
                        0            ; Float - Offset ( >= 0) 
                        0            ; Int32 - Repeat (NONE (0))
                        FALSE        ; Int32 - Reverse (TRUE or FALSE)
                        TRUE         ; Int32 - Supersample (TRUE or FALSE)
                        3            ; Int32 - Supersampling Recursion  Dept (1 - 9)
                        0.20         ; Float - Supersampling threshold (0 <= 4)
                        TRUE         ; Int32 - Dither (TRUE or FALSE)
                        xblend-start ; Int32 - X Blend Starting Point
                        yblend-start ; Int32 - Y Blend Starting Point
                        xblend-end   ; Int32 - X Blend Ending Point  
                        yblend-end   ; Int32 - Y Blend Ending Point
       ) ; End Blend

       (if (or (= map-type 1) (= map-type 3))
           (begin  
              (gimp-item-set-name emap-drawable "Spherical Cloud") ; Name it
           )
       ) ;endif

     )
) ;endif

;
; Create Solid Color Spherical Map Using Current Forgraound Color
;
(if (= map-type 4)
    (begin
      (gimp-context-set-foreground saved-fg-color)       ; Restore Foreground  
      (gimp-layer-add-alpha emap-drawable)               ; Alpha Channel Required For Drawable Fill
      (gimp-edit-clear emap-drawable)                    ; Clear the map
      (gimp-drawable-fill emap-drawable FOREGROUND-FILL) ; Fill it 
     )
) ;endif

;
; Gaussian Blur Final eMap
;
(if (> blur-radius 0)
    (begin  
      (plug-in-gauss                 
                   1     ; Non-interactive 
                 img     ; Image to apply blur 
       emap-drawable     ; Layer to apply blur
         blur-radius     ; Blur Radius x  
         blur-radius     ; Blue Radius y 
                   0     ; Method (IIR=0 RLE=1)
      )
    )
) ;endif

;
;  Make Environment Map Spherical
;
 
(if (not (= map-type 4))                     ; Add alpha is it hasn't already been added
    (begin
        (gimp-layer-add-alpha emap-drawable) ; Add alpha channel to emap-drawable
     )
) ;endif


    (plug-in-map-object 1 img emap-drawable
         1                       ; Type of mapping (0=plane,1=sphere,2=box,3=cylinder)
         0.5 0.5 2.0             ; Viewpoint
         0.5 0.5 0.0             ; Object pos
         1.0 0.0 0.0             ; First axis
         0.0 1.0 0.0             ; 2nd axis
         0.0 0.0 0.0             ; Axis rotation
         0 '(255 255 255)        ; Type of lightsource (0=point,1=directional,2=none)and Lightsource color (r,g,b)
         -0.5 -0.5 2.0           ; Light position
         -1.0 -1.0 1.0           ; Light direction
         0.3 1.0 0.45 spec 30.0  ; Material (amb, diff, refl, spec, high)
         TRUE                    ; Antialias
         TRUE                    ; Tile
         FALSE                   ; New image
         TRUE                    ; Transparency
         .44                     ; Sphere/cylinder radius (only used when maptype=1 or 3)
         0.5 0.5 0.5             ; Box size
         1.00                    ; Unused parameter Cylinder length
         -1                      ; Box front face (set these to -1 if not used)
         -1                      ; Box back face
         -1                      ; Box top face
         -1                      ; Box bottom face
         -1                      ; Box left face
         -1                      ; Box right face
         -1                      ; Cylinder top face (unused parameter)
         -1)                     ; Cylinder bottom face (unused parameter)

    (plug-in-autocrop-layer 1 img emap-drawable) ; Autocrop the spherical emap

;
; Rotate Spherical Map For Lighting Direction 
;
    (gimp-item-transform-rotate emap-drawable (/ (* (+ light-direction 40) *pi*) 180) TRUE 0 0)


  ) ;End Else Begin

) ; Endif (of emap render)

   
   (gimp-image-set-active-layer img bumpmap-layer)   ; Make Bumpmap layer Active

;
; Run ML Bevel Reflect Plug-in
;

   (if (= bevel-slope 3)       ; Run Interacrive
      (begin
        (set! interactive 0)
      )
    ) ;endif

   (if (= map-type 5)           ; Create a Normal Map
     (begin  
       (set! emap-drawable -1) ; (-1 for Normal Map)
     )
   ) ;endif

   (set! image-height (car (gimp-drawable-height bumpmap-layer))) ; Get Height 
   (set! image-width (car (gimp-drawable-width bumpmap-layer)))   ; Get Width

   (gimp-image-resize img (+ image-width 4) image-height 2 0)     ; Increase Canvas by 4px to Compensate For Extraneous Lines Created By ML BR Plug-in
   (gimp-layer-resize-to-image-size bumpmap-layer)                ; Layer to new size 

   (plug-in-mlbevelreflect2 
                           interactive   ; Interactive (0), non-interactive (1)
                                   img   ; Input image
                         bumpmap-layer   ; Input drawable
                                 FALSE   ; Invert Flag
                     (+ bevel-slope 1)   ; Slope-Flat (1), Slope-Round1 (2), Slope-Round2 (3) 
                       slope-smoothing   ; Smoothing For Flat Slope (INT8 Blur Radius 1-32)
                            flat-depth   ; Flat Slope Depth (default = 10)
                          round1-depth   ; Round Slope Depth (default = 7)
                          round2-depth   ; Round2 Slope Depth (default = 20)          
                         emap-drawable   ; Light Probe image, HDRi Probe Images or Spherical Environment Map (-1 = NormMap)
                            diffusion)   ; Diffusion: Float - Diffuse (0) <---> Shiny (1)

   (gimp-image-resize img image-width image-height -2 0)  ; Resize Canvas to Eliminate Extraneous Lines Created By ML BR Plug-in
   (gimp-layer-resize-to-image-size bumpmap-layer)        ; Layer to original size 

;
; Edge Smoothing Attempt
;
   (gimp-image-select-item img 0 bumpmap-layer) ; Alpha to Selection

    (if (= edge-smoothing 3)                ; More Smoothing 
        (begin
           (set! edge-smoothing 2)          ; Limit Shrink Amount
           (set! edge-blur 4)               ; More blur 
        )
    ) ;endif

    (if (= edge-smoothing 4)                ; Max Smoothing 
        (begin
           (set! edge-smoothing 2)          ; Limit Shrink Amount
           (set! edge-blur 5)               ; More blur 
        )
    ) ;endif

   (gimp-selection-shrink img edge-smoothing)   ; Shrink by edge smoothing amount
   (gimp-selection-invert img)                  ; Invert selection

      (if (> edge-smoothing 0)                  ; Run Interacrive
         (begin
               (plug-in-gauss                   ; Blur Edge 
                         1                      ; Non-interactive 
                         img                    ; Image to apply blur 
                         bumpmap-layer          ; Layer to apply blur
                         edge-blur              ; Blur Radius x  
                         edge-blur              ; Blue Radius y 
                         1)                     ; Method (IIR=0 RLE=1)
         )
      ) ;endif

   (gimp-selection-invert img)                  ; Invert selection
   (gimp-selection-none img)                    ; Clear selection

;
; Add copy of original layer below spherical map
;
     (gimp-image-insert-layer img copytext-layer parent (+ act-lay-pos 2))  ; Add it to image
     (gimp-item-set-name copytext-layer "BR Logo Copy")                     ; Name Copy 
     (gimp-item-set-visible copytext-layer FALSE)                           ; Turn off copy
     (gimp-image-remove-layer img logo-layer)                               ; Remove Layer
     (gimp-image-set-active-layer img bumpmap-layer)                        ; Bumpmap layer active (bump is new bevel reflect layer)

;
; Keep Layers
;
    (if (= keep-layers FALSE)                               ; Keep Layers?
        (begin
          (gimp-image-remove-layer img copytext-layer)       ; Remove Copytext Layer
          (if (< emap-name-len 3)                            ; Emap loaded from disk?
             (begin
                (gimp-image-remove-layer img emap-drawable) ; Remove Emap Layer
             )
           ) ; endif
        )
     ) ; endif

;
; Restore Selection
;
    (if (= saved-flag TRUE)                         ; Check For A Saved Selection 
        (begin
           (gimp-selection-load saved-selection)    ; Restore Selection  
        )
     ) ; endif

 ); endlet
) ; return (from apply-ml-bevel-reflect-logo) 

;
; Define alpha to selection procedure
;
(define (script-fu-ml-bevel-reflect-logo-alpha 
                   img                     ; Image
                   logo-layer              ; Input layer
                   bevel-slope             ; Bevel Slope
                   slope-smoothing         ; Slope Smoothing
                   flat-depth              ; Flat Slope Depth
                   round1-depth            ; Round1 Slope Depth
                   round2-depth            ; Round2 SLope Depth  
                   diffusion               ; Diffusion
                   contour                 ; Contour
                   blur-depth              ; Blur Depth
                   edge-smoothing          ; Edge Smoothing Amount
                   emap-name               ; Environment Map Name
                   map-type                ; Environment Map Type
                   paint-mode              ; Selected Paint Mode For Use WIth Blend Plug-in
                   blend-direction         ; Blend Direction
                   blend-shape             ; Blend Shape
                   emap-gradient           ; Selected Gradient For Environment Map
                   light-direction         ; Light Direction Falling Onto Spherical Map
                   spec                    ; Specular Highlights
                   detail-level            ; Detail Level For Solid Noise Plug-in 
                   texturesizex            ; Drawable Width
                   texturesizey            ; Drawable Height
                   emap-size               ; Spherical Emap Final Size
                   blur-radius             ; Gaussian Blur Radius 
                   auto-hsv                ; Autostretch HSV Flag
                   turbulent               ; Turbulance Flag
                   keep-layers)            ; Keep Spherical Map & BR Logo/Selection Copy Layers 

  (let* (
          (alpha2logo 1) ; 0 - Text mode , 1 - Alpha mode
        )

 (if (not (defined? 'plug-in-mlbevelreflect2))        ;Check for ML Bevel Reflect
   (begin
     (display_message "This Script Requires: ML Bevel Reflect Plug-in \n\nML Bevel Reflect Plug-in Can Be Obtained From: \n\nhttp://gimpscripts.com/2014/01/ml-bevel-reflect/   " 0)
    )
   (begin ;else
;
; Save current GIMP context
;
    (gimp-context-push)               ; Push context onto stack
    (gimp-image-undo-group-start img) ; Begin undo group
;
; Call apply logo procedure  
;
    (apply-ml-bevel-reflect-logo 
                 img                     ; Image
                 logo-layer              ; Input layer
                 bevel-slope             ; Bevel Slope
                 slope-smoothing         ; Slope Smoothing
                 flat-depth              ; Flat Slope Depth
                 round1-depth            ; Round1 Slope Depth
                 round2-depth            ; Round2 SLope Depth  
                 diffusion               ; Diffusion
                 contour                 ; Contour
                 blur-depth              ; Blur Depth
                 edge-smoothing          ; Edge Smoothing Amount
                 emap-name               ; Environment Map Name
                 map-type                ; Environment Map Type
                 paint-mode              ; Selected Paint Mode For Use WIth Blend Plug-in
                 blend-direction         ; Blend Direction
                 blend-shape             ; Blend Shape
                 emap-gradient           ; Selected Gradient For Environment Map
                 light-direction         ; Light Direction Falling Onto Spherical Map
                 spec                    ; Specular Highlights
                 detail-level            ; Detail Level For Solid Noise Plug-in 
                 texturesizex            ; Drawable Width
                 texturesizey            ; Drawable Height
                 emap-size               ; Spherical Emap Final Size
                 blur-radius             ; Gaussian Blur Radius 
                 auto-hsv                ; Autostretch HSV Flag
                 turbulent               ; Turbulance Flag
                 keep-layers)            ; Keep Spherical Map & BR Logo/Selection Copy Layers 

    (gimp-image-undo-group-end img) ; End undo group
    (gimp-context-pop)              ; Pop context off stack
    (gimp-displays-flush)           ; Flush display


  ) ; End else for ML Bevel Reflect Check
 );endif for ML Bevel Refect Check

  ) ;endlet
) ; return  

;
; Register logo to alpha procedure
;
(script-fu-register "script-fu-ml-bevel-reflect-logo-alpha"
                    _"Bevel Reflect Logo..."
                    _"Create selected logo"
                    "GnuTux - http://gimpchat.com"
                    "GnuTux - GPLv3"
                    "08-2013"
                    "RGBA"
                    SF-IMAGE       "Image"                      0
                    SF-DRAWABLE    "Drawable"                   0
                    SF-OPTION     _"Bevel - Slope Options"     '("Flat Bevel" "Round1 Bevel" "Round2 Bevel" "Run Interactive")
                    SF-ADJUSTMENT _"Flat Bevel - Smoothing"    '(8 1 32 1 1 0 0)
                    SF-ADJUSTMENT _"Flat Bevel - Depth"        '(10.0 1.0 10.5 0.1 0.5 1 0)
                    SF-ADJUSTMENT _"Round1 Bevel - Depth"      '(7.0 1.0 8.0 0.1 0.5 1 0)
                    SF-ADJUSTMENT _"Round2 Bevel - Depth"      '(20.0 1.0 25.0 0.1 0.5 1 0)
                    SF-ADJUSTMENT _"(Diffuse) 0<--->1 (Shiny)" '(1 0 1 .1 .1 2 0)
                    SF-OPTION     _"Contour"		           '("Linear" "Outline" "Outline (Inner Bevel)" "Outline (Outer Bevel)" "Step Bevel" "Ring (Narrow)" "Ring (Medium)" "Ring (Wide)" "Ring (Extra Wide)" "Ring (Thick)" "Double Ring" "Double Ring (Narrow)" "Double Ring (Wide)")
                    SF-ADJUSTMENT _"Contour Depth"             '(0 0 20 1 1 0 0)
                    SF-ADJUSTMENT _"Edge Smoothing Amount"     '(1 0 4 1 1 0 0)
                    SF-FILENAME   _"Spherical Emap (png/jpg)"  "none"
                    SF-OPTION     _"Environment Map Type"      '("Spherical Topographical" "Spherical Cloud" "Spherical Topo (Active Gradient)" "Spherical Cloud (Active Gradient)" "Spherical Solid (Active Color)" "Generate Normal Map")
                    SF-OPTION     _"Blending Mode"             '("Normal" "Dissolve" "Behind" "Multiply" "Screen" "Overlay" "Difference" "Addition" "Subtract" "Darken" "Lighten" "Hue" "Saturation" "Color" "Value" "Divide" "Dodge" "Burn" "Hard Light" "Soft Light" "Grain Extract" "Grain Merge")
                    SF-OPTION     _"Blend Direction"           '("Top-Botton" "Bottom-Top" "Left-Right" "Right-Left" "Diag-Top-Left" "Diag-Top-Right" "Diag-Bottom-Left" "Diag-Bottom-Right")
                    SF-OPTION     _"Blend Shape"               '("Linear""Bilinear" "Radial" "Square" "Conical-Symmetric" "Conical-Asymmetric" "Shapeburst-Angular" "Shapburst-Spherical" "Shapeburst-Dimpled" "Spiral-CW" "Spiral-CCW")
                    SF-GRADIENT   _"Select Gradient"           "Abstract 1"
         		    SF-ADJUSTMENT _"Light Direction (Degrees)" '(315 0 360 1 45 0 0)
                    SF-ADJUSTMENT _"Emap Specular Highlights"  '(0.35 0.10 0.65 0.01 0.05 2 0)
                    SF-ADJUSTMENT _"Detail Level"              '(0 0 3 1 1 0 0)
                    SF-ADJUSTMENT _"Horizontal Texture Size"   '(1.2 1 5 .1 .5 1 0)
                    SF-ADJUSTMENT _"Vertical Texture Size"     '(2.6 1 5 .1 .5 1 0)
                    SF-ADJUSTMENT _"EMap Final Size"           '(300 250 1000 1 5 0 0)
                    SF-ADJUSTMENT _"EMap Final Blur"           '(0 0 20 1 5 0 0)
                    SF-TOGGLE     _"Autostretch HSV"           TRUE
                    SF-TOGGLE     _"Turbulent Noise"           TRUE
                    SF-TOGGLE     _"Keep Layers"               TRUE

) ;end register


(script-fu-menu-register "script-fu-ml-bevel-reflect-logo-alpha"
                         "<Image>/Filters/Alpha to Logo")

;
; Define logo text procedure
;
(define (script-fu-ml-bevel-reflect-logo 
                              text                    ; Text Layer
                              font                    ; Selected Font
                              size                    ; Text Size
                              spacing                 ; Letter Spacing
                              line-spacing            ; Line Spacing
                              justification           ; Text Justification
                              bevel-slope             ; Bevel Slope
                              slope-smoothing         ; Slope Smoothing 
                              flat-depth              ; Flat Slope Depth
                              round1-depth            ; Round1 Slope Depth
                              round2-depth            ; Round2 SLope Depth  
                              diffusion               ; Diffusion
                              contour                 ; Contour
                              blur-depth              ; Blur Depth
                              edge-smoothing          ; Edge Smoothing Amount
                              emap-name               ; Environment Map Name
                              map-type                ; Environment Map Type
                              paint-mode              ; Selected Paint Mode For Use WIth Blend Plug-in
                              blend-direction         ; Blend Direction
                              blend-shape             ; Blend Shape
                              emap-gradient           ; Selected Gradient For Environment Map
                              light-direction         ; Light Direction Falling Onto Spherical Map
                              spec                    ; Specular Highlights
                              detail-level            ; Detail Level For Solid Noise Plug-in 
                              texturesizex            ; Drawable Width
                              texturesizey            ; Drawable Height
                              emap-size               ; Spherical Emap Final Size
                              blur-radius             ; Gaussian Blur Radius 
                              auto-hsv                ; Autostretch HSV Flag
                              turbulent)              ; Turbulance Flag

 (let* (
          (img -1)                                 ; Declare and Init img
          (text-layer -1)                          ; Declare and init text-layer
          (logo-layer -1)                          ; Declare and init logo-layer 
          (alpha2logo 0)			               ; 0 - Text mode , 1 - Alpha mode
          (keep-layers TRUE)                       ; Keep Layers FLag
          (saved-fg-color (car (gimp-context-get-foreground img))) ; Save Foreground Color 
       )

(if (not (defined? 'plug-in-mlbevelreflect2))        ;Check for ML Bevel Reflect
  (begin
    (display_message "This Script Requires: ML Bevel Reflect Plug-in \n\nML Bevel Reflect Plug-in Can Be Obtained From: \n\nhttp://gimpscripts.com/2014/01/ml-bevel-reflect/   " 0)
   )
  (begin ;else
  
  (gimp-context-push)                              ; Push context onto stack
  (set! img (car (gimp-image-new 128 128 RGB)))    ; Create a new image

;
; Original Text Layer (keep untouched)
;

   (gimp-context-set-foreground '(0 0 0))                        ; Set Logo Color To Black (Requirement For ML Bevel Reflect) 
   (set! text-layer (car (gimp-text-fontname img -1 0 0 text 40 TRUE size PIXELS font))) ; Create text layer
   (gimp-text-layer-set-letter-spacing text-layer spacing)       ; Set Letter Spacing
   (gimp-text-layer-set-line-spacing text-layer line-spacing)    ; Set Line Spacing
   (gimp-text-layer-set-justification text-layer justification)  ; Text Jusification 
   (script-fu-util-image-resize-from-layer img text-layer)       ; Logo layer to image size
   (gimp-desaturate text-layer)                                  ; Desat discards text data
   (gimp-context-set-foreground saved-fg-color)                  ; Restore Foreground   
   (gimp-image-undo-group-start img)                             ; Begin undo group

                                                            
;
; Call the logo ml-bevel-reflect-logo main procedure 
;
  (apply-ml-bevel-reflect-logo
               img                     ; Image
               text-layer              ; Text Layer
               bevel-slope             ; Bevel Slope
               slope-smoothing         ; Slope Smoothing
               flat-depth              ; Flat Slope Depth
               round1-depth            ; Round1 Slope Depth
               round2-depth            ; Round2 SLope Depth  
               diffusion               ; Diffusion
               contour                 ; Contour
               blur-depth              ; Blur Depth
               edge-smoothing          ; Edge Smoothing Amount
               emap-name               ; Environment Map Name
               map-type                ; Environment Map Type
               paint-mode              ; Selected Paint Mode For Use WIth Blend Plug-in
               blend-direction         ; Blend Direction
               blend-shape             ; Blend Shape
               emap-gradient           ; Selected Gradient For Environment Map
               light-direction         ; Light Direction Falling Onto Spherical Map
               spec                    ; Specular Highlights
               detail-level            ; Detail Level For Solid Noise Plug-in 
               texturesizex            ; Drawable Width
               texturesizey            ; Drawable Height 
               emap-size               ; Spherical Emap Final Size
               blur-radius             ; Gaussian Blur Radius 
               auto-hsv                ; Autostretch HSV Flag
               turbulent               ; Turbulance Flag
               keep-layers)            ; Keep Spherical Map & BR Logo/Selection Copy Layers 

    (gimp-selection-none img)          ; Clear selection
    (gimp-image-undo-group-end img)    ; End undo group
    (gimp-context-pop)                 ; Pop context off stack

    (gimp-display-new img)             ; Show the image

  ) ; End else for ML Bevel Reflect Check
 );endif for ML Bevel Refect Check

 ) ; endlet
) ; return

;
; Register the script
;    
(script-fu-register "script-fu-ml-bevel-reflect-logo"
                    _"Bevel Reflect Logo.."
                    _"Create logo"
                    "GnuTux - http://gimpchat.com"
                    "GnuTux - GPLv3"
                    "08-2013"
                    ""
                    SF-TEXT       _"Text"                      "Bevel\nReflect\nLogo"
                    SF-FONT       _"Font"                      "Arial Bold"
                    SF-ADJUSTMENT _"Font size (pixels)"        '(250 2 1000 1 10 0 0)
                    SF-ADJUSTMENT _"Letter Spacing"            '(-8 -50 50 1 5 0 0)
                    SF-ADJUSTMENT _"Line Spacing"              '(-75 -300 300 1 10 0 0)
                    SF-OPTION     _"Text Justification"        '("Left" "Right" "Center")
                    SF-OPTION     _"Bevel - Slope Options"     '("Flat Bevel" "Round1 Bevel" "Round2 Bevel" "Run Interactive")
                    SF-ADJUSTMENT _"Flat Bevel - Smoothing"    '(8 1 32 1 1 0 0)
                    SF-ADJUSTMENT _"Flat Bevel - Depth"        '(10.0 1.0 10.5 0.1 0.5 1 0)
                    SF-ADJUSTMENT _"Round1 Bevel - Depth"      '(7.0 1.0 8.0 0.1 0.5 1 0)
                    SF-ADJUSTMENT _"Round2 Bevel - Depth"      '(20.0 1.0 25.0 0.1 0.5 1 0)
                    SF-ADJUSTMENT _"(Diffuse) 0<--->1 (Shiny)" '(1 0 1 .1 .1 2 0)
                    SF-OPTION     _"Contour"		           '("Linear" "Outline" "Outline (Inner Bevel)" "Outline (Outer Bevel)" "Step Bevel" "Ring (Narrow)" "Ring (Medium)" "Ring (Wide)" "Ring (Extra Wide)" "Ring (Thick)" "Double Ring" "Double Ring (Narrow)" "Double Ring (Wide)")
                    SF-ADJUSTMENT _"Contour Depth"             '(0 0 20 1 1 0 0)
                    SF-ADJUSTMENT _"Edge Smoothing Amount"     '(1 0 4 1 1 0 0)
                    SF-FILENAME   _"Spherical Emap (png/jpg)"  "none"
                    SF-OPTION     _"Environment Map Type"      '("Spherical Topographical" "Spherical Cloud" "Spherical Topo (Active Gradient)" "Spherical Cloud (Active Gradient)" "Spherical Solid (Active Color)" "Generate Normal Map")
                    SF-OPTION     _"Blending Mode"             '("Normal" "Dissolve" "Behind" "Multiply" "Screen" "Overlay" "Difference" "Addition" "Subtract" "Darken" "Lighten" "Hue" "Saturation" "Color" "Value" "Divide" "Dodge" "Burn" "Hard Light" "Soft Light" "Grain Extract" "Grain Merge")
                    SF-OPTION     _"Blend Direction"           '("Top-Botton" "Bottom-Top" "Left-Right" "Right-Left" "Diag-Top-Left" "Diag-Top-Right" "Diag-Bottom-Left" "Diag-Bottom-Right")
                    SF-OPTION     _"Blend Shape"               '("Linear""Bilinear" "Radial" "Square" "Conical-Symmetric" "Conical-Asymmetric" "Shapeburst-Angular" "Shapburst-Spherical" "Shapeburst-Dimpled" "Spiral-CW" "Spiral-CCW")
                    SF-GRADIENT   _"Select Gradient"           "Abstract 1"
         		    SF-ADJUSTMENT _"Light Direction (Degrees)" '(315 0 360 1 45 0 0)
                    SF-ADJUSTMENT _"Emap Specular Highlights"  '(0.35 0.10 0.65 0.01 0.05 2 0)
                    SF-ADJUSTMENT _"Detail Level"              '(0 0 3 1 1 0 0)
                    SF-ADJUSTMENT _"Horizontal Texture Size"   '(1.2 1 5 .1 .5 1 0)
                    SF-ADJUSTMENT _"Vertical Texture Size"     '(2.6 1 5 .1 .5 1 0)
                    SF-ADJUSTMENT _"EMap Final Size"           '(300 250 1000 1 5 0 0)
                    SF-ADJUSTMENT _"EMap Final Blur"           '(0 0 20 1 5 0 0)
                    SF-TOGGLE     _"Autostretch HSV"           TRUE
                    SF-TOGGLE     _"Turbulent Noise"           TRUE
) ; end register

(script-fu-menu-register "script-fu-ml-bevel-reflect-logo"
                         "<Image>/File/Create/Logos (gimpchat.com)/")
