;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; SCRIPT-FU-FLUTTERING-FLAG animates a flat image of a flag by blowing wind on it
; Copyright (c) 2006-2008  Tharsice Demand <www.td-e.com>
; version 1.00  2006.08.15  english
; version 1.10  2007.09.16  replaced set! with define for future compatibility,
;                           mast now optional, mast thickness can be adjusted,
;                           smoothing the hitch of the repetition of the images
; version 1.20  2007.10.25, migration to Gimp 2.4
; version 1.21  2008.04.05  indexed pictures without grey in their palette did not produce correct results, bug corrected
; version 1.22  2008.11.29  improvement of the flag edges when the bg is transparent, thx Peter PKHG from NL
; version 1.30  2011.10.18  A color can be selected for the parts of the flag that should became transparent and/or show the sky
; version 1.31  2012.01.12  The height of the mast can be adjusted
;
;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
;
;Copy of the license at http://td-e.com/site/gpl.php

(define (addReplaceToName image)
  (let* (
	 (layerNr 0)
	 (tmp 0)
	 (teller 0)
	 (layerName "vlagPKHG ")
	 (flagLayersVec (cadr (gimp-image-get-layers image)))
	 (nrOfLayers (vector-length flagLayersVec))
	 )    
    (while (< teller nrOfLayers) 
      (set! layerNr (vector-ref flagLayersVec teller))
      (set! tmp (string-append "vlagNEU" (number->string teller) "(replace)"))
      (gimp-drawable-set-name layerNr tmp)
      
      (set! teller  (+ teller 1))
      )    
    )
  )


(define (script-fu-fluttering-flag image flatflag layertotal ripple windstrength formf mthickness mheight hitch skycolor mastcolorl mastcolorr transcolor formrand skytrans)
  (let*
    (
      (old-fg (car (gimp-context-get-foreground)))
      (old-bg (car (gimp-context-get-background)))
      (owidth (car (gimp-image-width image)))
      (oheight (car (gimp-image-height image)))
      (borderx (/ owidth 10))
      (bordery borderx)
      (mastlef (* borderx (- 0.80 (/ (* 0.60 mthickness) 100))))
      (mastrig (* borderx (+ 0.80 (/ (* 0.60 mthickness) 100))))
      (width (+ owidth (* 2 borderx)))
      (mastheight (/ (* oheight mheight) 10))
      (height (+ mastheight (* 2 bordery)))
      (snx (/ ripple 10)) ;5..150 default to 25 -> 0.5..15 defaults to 2.5
      (sny 0.1) ;~ 0.1
      (flutterx (/ owidth (- layertotal 1))) ;dependent on num of layers
      (fluttery (/ oheight (- layertotal 1)))
      (layerindex 0)
      (formseed (if (= formrand TRUE) (rand 4294967295) (* formf 10000000))) ;(2^32-1 = 4 294 967 295)
      (fgcolormax hitch)
      (fgcolormin 0)
      (fgcolorval 0)
      (fgcolorvalar '(0 0 0))
      (attenmax (+ 0.40 (/ (* hitch 0.59) 255)))
      (attenmin 0.40)
      (attenval 0.40)
      ;---factors for smoothing the repetition---
      ; y = ax^2 + bx + c
      ; a = 4 (max - min) / layerindex^2  ; b= 4 (min -max) / layerindex  ; c= max
      ;
      ; attenuation
      ; max = 0.95  ; min = 0.40  ; a = 2.20 / layertotal^2 ;  b = - 2.20 / layertotal ;  c = 0.95
      ;
      ; foreground color
      ; max = 160  ; min = 0  ; a = 640 / layertotal^2 ;  b = - 640 / layertotal ;  c = 160
      ;
      (attena (/ (* 4 (- attenmax attenmin)) (* layertotal layertotal)))
      (attenb (/ (* 4 (- attenmin attenmax)) layertotal))
      (attenc attenmax)
      (fgcolora (/ (* 4 (- fgcolormax fgcolormin)) (* layertotal layertotal)))
      (fgcolorb (/ (* 4 (- fgcolormin fgcolormax)) layertotal))
      (fgcolorc fgcolormax)
    )
    (srand (realtime))
    (gimp-image-undo-group-start image)

    (gimp-context-set-background '(255 255 255))
    (define flatflag1 (car (gimp-image-flatten image)))

    ;---if not an RGB, make one---
    (if (= (car (gimp-drawable-is-rgb flatflag1)) 0) (gimp-image-convert-rgb image))

    ;---add a 10% border---
    (gimp-image-resize image width height borderx bordery)
    (define borderlayer (car (gimp-layer-new image width height 1 "sky" 100 0)))
    (gimp-layer-add-alpha borderlayer)
    (gimp-context-set-foreground transcolor)
    (gimp-drawable-fill borderlayer 0)
    (gimp-image-add-layer image borderlayer 1)
    (gimp-context-set-background transcolor)
    (define flatflagf (car (gimp-image-flatten image)))

    ;(gimp-context-set-background '(255 255 255))
    ;(gimp-context-set-foreground '(0 0 0))

    (if (= (car (gimp-selection-is-empty image)) 1) (gimp-selection-all image))
    (define flag-select (car (gimp-selection-save image)))
    (gimp-selection-none image)

    ;---make the added border transparent---
    (gimp-fuzzy-select flatflagf 1 1 10 0 FALSE FALSE 0.0 0)
    (gimp-layer-add-alpha flatflagf)
    (gimp-edit-clear flatflagf)
    (gimp-selection-none image)

    ;---draw the mast layer---
    (define mastlayer (car (gimp-layer-new image width height 1 "mast" 100 0)))
    (gimp-layer-add-alpha mastlayer)
    (gimp-drawable-fill mastlayer 3)
    (gimp-image-add-layer image mastlayer 0)

    (gimp-context-set-foreground mastcolorl)
    (gimp-context-set-background mastcolorr)

    (define (gen-mast-array borderx bordery width height mastlef mastrig)
      (let*
        ((mastarray (cons-array 10 'double)))
        (aset mastarray 0 mastlef)
        (aset mastarray 1 (* bordery 0.5))
        (aset mastarray 2 mastrig)
        (aset mastarray 3 (* bordery 0.5))
        (aset mastarray 4 mastrig)
        (aset mastarray 5 height)
        (aset mastarray 6 mastlef)
        (aset mastarray 7 height )
        (aset mastarray 8 mastlef)
        (aset mastarray 9 (* bordery 0.5))
        mastarray
      )
    )

    (define mastsel (gen-mast-array borderx bordery width height mastlef mastrig))
    (gimp-free-select image
                      10
                      mastsel
                      CHANNEL-OP-REPLACE
                      0
                      0
                      0.0)
    (if (>= mthickness 10)
      (gimp-edit-blend
        mastlayer BLEND-FG-BG-RGB LAYER-MODE-NORMAL GRADIENT-LINEAR
        100 0 REPEAT-NONE FALSE FALSE
        0 0 FALSE
        mastlef (/ height 2) mastrig (/ height 2)
      )
    )
    (gimp-selection-none image)

    ;---draw the sky layer---
    (if (= skytrans TRUE)
      (begin
        (define skylayer (car (gimp-layer-new image width height 1 "sky" 0 0)))
        (gimp-layer-add-alpha skylayer)
      )
      (begin
        (define skylayer (car (gimp-layer-new image width height 1 "sky" 100 0)))
        (gimp-layer-add-alpha skylayer)
        (gimp-context-set-foreground skycolor)
        (gimp-drawable-fill skylayer 0)
      )
    )
    (gimp-image-add-layer image skylayer 0)

    ;---draw the flutter layer---
    (define flutterlayer (car (gimp-layer-new image width height 1 "flutter" 100 0)))
    (gimp-drawable-fill flutterlayer 3)
    (gimp-image-add-layer image flutterlayer 0)

    (plug-in-solid-noise 1 image flutterlayer 1 0 formseed 1 snx sny)
    (plug-in-gauss 1 image flutterlayer 5 5 0)
    (plug-in-c-astretch 1 image flutterlayer)
    (gimp-selection-load flag-select)


    (while (< layerindex layertotal)
      ;---stabilize flag at mast---
      (define fluttercopy (car (gimp-layer-copy flutterlayer 1)))
      (gimp-drawable-set-name fluttercopy "fluttercopy")
      (gimp-image-add-layer image fluttercopy -1)

      (define stablemast (car (gimp-layer-new image width height 1 "stablemast" 100 0)))
      (gimp-image-add-layer image stablemast -1)
      (define stablemastmask (car (gimp-layer-create-mask stablemast 0)))
      (gimp-layer-add-mask stablemast stablemastmask)
      (gimp-context-set-foreground '(128 128 128))
      (gimp-drawable-fill stablemast 0)

      ;---smoothing the repetition---
      ; y = ax ^ 2 + bx + c
      (set! attenval   (+ (+ (* attena   (* layerindex layerindex)) (* attenb   layerindex)) attenc))
      (set! fgcolorval (+ (+ (* fgcolora (* layerindex layerindex)) (* fgcolorb layerindex)) fgcolorc))
      (set! fgcolorvalar (list fgcolorval fgcolorval fgcolorval))

      (gimp-context-set-foreground fgcolorvalar)
      (gimp-context-set-background '(255 255 255))

      (gimp-edit-blend
          stablemastmask BLEND-FG-BG-RGB LAYER-MODE-NORMAL  GRADIENT-LINEAR
          100 0 REPEAT-NONE TRUE FALSE
          0 0 FALSE
          (* borderx 0.80) (/ height 2) (* width attenval) (/ height 2))
      (define fluttermodif (car (gimp-image-merge-down image stablemast 1)))
      (gimp-drawable-set-name fluttermodif "fluttermodif")

      ;---blow onto the flag---
      (define flagcopy (car (gimp-layer-copy flatflagf 1)))
      (gimp-image-add-layer image flagcopy -1)

      (plug-in-bump-map 1 image flagcopy fluttermodif 135 45 10 0 0 0 0 1 0 2)
      (plug-in-displace 1 image flagcopy (/ (* owidth windstrength) 400) (/ (* oheight windstrength) 100) 1 1 fluttermodif fluttermodif 1)
      (gimp-image-remove-layer image fluttermodif)
      (gimp-drawable-offset flutterlayer 1 0 flutterx fluttery)

      ;---add the sky---
      (define skycopy (car (gimp-layer-copy skylayer 1)))
      (gimp-image-add-layer image skycopy -1)
      (gimp-image-lower-layer image skycopy)
      (gimp-image-merge-down image flagcopy 1)

      ;---add the mast---
      (define mastcopy (car (gimp-layer-copy mastlayer 1)))
      (gimp-image-add-layer image mastcopy -1)
      (gimp-image-merge-down image mastcopy 1)

      (set! layerindex (+ layerindex 1))
    )

    (gimp-image-remove-layer image mastlayer)
    (gimp-image-remove-layer image skylayer)
    (gimp-image-remove-layer image flutterlayer)
    (gimp-image-remove-layer image flatflagf)
    (gimp-context-set-foreground old-fg)
    (gimp-context-set-background old-bg)

    (gimp-selection-none image)
    (gimp-image-remove-channel image flag-select)
    (gimp-image-convert-indexed image 0 0 255 0 0 "")
    ;---line below added in case of transparent sky---
    (if (= skytrans TRUE) (addReplaceToName image))
    (gimp-image-undo-group-end image)
    (gimp-displays-flush)
  )
)
(script-fu-register "script-fu-fluttering-flag"
                    "<Image>/Filters/Animation/Fluttering flag..."
                    "Creates an animated flag made of a choosen number of layers. 
When saving as a gif file, select 
- Save as Animation 
- Loop forever
- Delay between frames = 100 ms. 
- Frame disposal = one frame per layer 
A high ripple parameter = a very wavy flag. 
The wind parameter affects the amplitude of the movement. 
The form factor can be random or specific. 
Recommended form factors: 5, 14, 134, 199."
                    "Tharsice Demand <td-e.com>"
                    "Tharsice Demand"
                    "2012.01.12"
                    "RGB RGBA GRAY GRAYA INDEXED INDEXEDA"
                    SF-IMAGE      "Image" 0
                    SF-DRAWABLE   "Drawable" 0
                    SF-ADJUSTMENT "Number of layers"                   '(8 4 32 1 4 0 1)
                    SF-ADJUSTMENT "Ripple"                             '(30 5 150 1 5 0 1)
                    SF-ADJUSTMENT "Wind"                               '(5 1 9 1 2 0 1)
                    SF-ADJUSTMENT "Form factor"                        '(5 1 400 1 10 0 1)
                    SF-ADJUSTMENT "Thickness of the mast"              '(60 5 100 1 10 0 1)
                    SF-ADJUSTMENT "Height of the mast multiplicator 10=1x 20=2x "   '(10 10 100 1 10 0 1)
                    SF-ADJUSTMENT "Reduction of repetition hitch"      '(1 1 255 1 10 0 1)
                    SF-COLOR      "Color of the sky"                   '(128 170 255)
                    SF-COLOR      "Left color of mast gradient"        '(255 240 176)
                    SF-COLOR      "Right color of mast gradient"       '(80 48 16)
                    SF-COLOR      "This color will be made transparent"'(76 19 76)
                    SF-TOGGLE     "Ignore form factor and make it random"            FALSE
                    SF-TOGGLE     "Ignore sky color and make background transparent" FALSE
)
