#!/usr/bin/env python

# --------------------------------------------
# Add file name box
# --------------------------------------------
# Change Log
# ============================================
# Version 0.0.1 Initial release.

import math
import os
import os.path
import sys

from array import array 
from gimpfu import *

#------------------------------
def format_pkz(sText):
#    sConcatenatedText = sText + "(c) TEST"
    sConcatenatedText = "Chapter 1 - Page " + sText + " - Book II"  ## set text here
    return sConcatenatedText

# -------------------------------------------------------------------------------------------
def add_filename_box(image, layer, use_filename, pkz1, placement):
    # set start of undo
    pdb.gimp_image_undo_group_start(image)

    # Save the current foreground color:
    pdb.gimp_context_push()

    # Set foreground and background color to default
    gimp.set_foreground(0,0,0)
    gimp.set_background(255, 255, 255)

    # use filename for pkz1
    if use_filename:
        filename = image.filename
        filename_w_ext = os.path.basename(filename)
        file_name, file_extension = os.path.splitext(filename_w_ext) 
        pkz1 = format_pkz(file_name)

        if placement == 0:      # top right
            xOffset = image.width - 630
            yOffset = 50
        elif placement == 1:    # down right
            xOffset = image.width - 630
            yOffset = image.height - 150
        elif placement == 2:    # down left
#            xOffset = 50
#            yOffset = image.height - 150     
            xOffset = 600                                         ## adjust center
            yOffset = image.height - 150              ## adjust height
        else:                   # top left
            xOffset = 50
            yOffset = 50
        # create layer with text and add it to the image: image, drawable, x, y, text, border, antialias, size, size_type, fontname
#        pdb.gimp_text_fontname(image, None, xOffset, yOffset, pkz1 , 10, True, 64, PIXELS, "Verdana Bold")   
        pdb.gimp_text_fontname(image, None, xOffset, yOffset, pkz1 , 10, True, 100, PIXELS, "Times New Roman, Bold")   ## set font here

    else:                       # don't use file name
        xOffset = 50
        yOffset = 200
        # create layer with text and add it to the image: image, drawable, x, y, text, border, antialias, size, size_type, fontname
        pdb.gimp_text_fontname(image, None, xOffset, yOffset, pkz1 , 10, True, 100, PIXELS, "Times New Roman, Bold")         

    # Restore the old foreground color:
    pdb.gimp_context_pop()
    # set end of undo
    pdb.gimp_image_undo_group_end(image)

# -----------------------------------------------------------------------------
# register the plug-in
# ----------------------------------------------------------------------------- 

register(
    "python_fu_add_filename_box",
    "My function test.",
    "My function test for developing cases.",
    "help-info.de",
    "help-info.de (c)",
    "2018-06-03",
    "<Image>/DEVELOP/Add filename box ...",
    "RGB*",
     [
#            (PF_TOGGLE, "use_filename", "PKZ aus Dateinamen ableiten", 1),
            (PF_TOGGLE, "use_filename", "from file name", 1),
            (PF_STRING, "pkz1", "User Input", "0000-0-00000"),            
            (PF_OPTION, "placement", "Placement", 2, ("top right", "down right", "down left", "top left")),         
     ],
     [],
     add_filename_box)

main()
