#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys,os

from gimpfu import *
import gimpcolor

def noDots(image,layer,pixels):
    print 'Running with %d pixels' % pixels 
    image.undo_group_start()
        
    try:
        selColor=pdb.gimp_context_get_background()
        pdb.gimp_by_color_select(layer,selColor,2,CHANNEL_OP_REPLACE,False,False,0.,False)
        pdb.gimp_selection_grow(image, pixels)
        pdb.gimp_selection_shrink(image, pixels)
        pdb.gimp_edit_clear(layer)
        pdb.gimp_selection_none(image)
        layer=pdb.gimp_image_flatten(image)
        pdb.gimp_image_convert_rgb(image)
        pdb.gimp_image_add_hguide(image, image.height/2)
        pdb.gimp_image_add_vguide(image, image.width/2)
        
    except Exception as e:
        gimp.message(e.args[0])
        
    # Clean and exit
    image.undo_group_end()
    return

# Some variables to avoid repeating myself
whoiam='\n%s' % (os.path.abspath(sys.argv[0]),)
parmsIn= [(PF_IMAGE,'image','Input image',None),(PF_DRAWABLE,'layer','Input layer',None)]
parmsOut=[]
menuLocation='<Image>/Gimpy222'
author=''
year='2020'

def functionGenerator(pixels):
    def function(image,layer):
        noDots(image,layer,pixels)
    return function 

for pixels in range(1,6,1):
    id='gimpy222-nodots-%dpx'% pixels
    desc='Remove dots (%dpx)'% pixels
    register(id,desc+whoiam,desc,author,author,year,desc,'*',parmsIn,parmsOut,functionGenerator(pixels),menuLocation)    
    
main()
