#!/usr/bin/env python
# -*- coding: utf-8 -*-

# GIMP plugin split layers along the guides
# (c) Ofnuts 2018
#
#   quick hack to position guides on a layer as a percentage of the size - rich 2020 

#   History:
#
#   v0.0: 2018-08-08 First published version
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published
#   by the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This very file is the complete source code to the program.
#
#   If you make and redistribute changes to this code, please mark it
#   in reasonable ways as different from the original version. 
#   
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   The GPL v3 licence is available at: https://www.gnu.org/licenses/gpl-3.0.en.html


from gimpfu import *

def guidesonLayer(image,layer,hg,vg):
    
    if not isinstance(layer,gimp.Layer):
        return

    image.undo_group_start()
    
    x,y=layer.offsets
    w,h=layer.width,layer.height
    w = (w * hg / 100)
    h = (h * vg / 100)
    x = x + w
    y = y + h
 
#    image.add_vguide(x)
    pdb.gimp_image_add_vguide(image, x)    
#    image.add_vguide(x+w)    
#    image.add_hguide(y)
    pdb.gimp_image_add_hguide(image, y)
#    image.add_hguide(y+h) 

    image.undo_group_end()

### Registrations
register(
    "guides-on-layer",
    "Generate guides on layer",
    "Generate guides on layer",
    "Mostly Ofnuts","Ofnuts","2018",
    "New percentage guides on  active layer",
    "*",
    [
        (PF_IMAGE, "image", "Input image", None),
        (PF_DRAWABLE, 'drawable', 'Input drawable', None),
        (PF_INT,      "hg",        "Horiz %", 50),    
        (PF_INT,      "vg",        "Vert %", 50) ,
    ],
    [],
    guidesonLayer,
    menu="<Image>/Image/Guides"
)

main()
