#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Example of Gimp pythonj plugin with modules

# (c) Ofnuts 2019
#
#   History:
#
#   v0.0: 2017-08-09 First published version

#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published
#   by the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This very file is the complete source code to the program.
#
#   If you make and redistribute changes to this code, please mark it
#   in reasonable ways as different from the original version. 
#   
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   The GPL v3 licence is available at: https://www.gnu.org/licenses/gpl-3.0.en.html

import sys,os,os.path,re,glob,traceback
from gimpfu import *

me=os.path.abspath(sys.argv[0])
mydir=os.path.dirname(me)
sys.path.insert(0,mydir)

import module1,module2,module3

functions=[module1.function,module3.function,module3.function]

### Registrations
author='Ofnuts'
year='2019'
menu='<Image>/DemoModule/'
atomPrefix='ofn-modules'
argsIn=[(PF_IMAGE,'image','Input image', None),]
argsOut=[]

for i,f in enumerate(functions,1):   
    name='Function-%02d' % i
    register(
        atomPrefix+name,
        name,name,author,author,year,name+'...',
        '*',argsIn,argsOut,f,
        menu=menu
    )
    
main()
