#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gimpfu import *
import os
import glob  # unused

# a quick add white border - rich

def newborder(dirname, bwidth, ext, suffix):


    topdir = os.walk(dirname)


    if suffix.find(ext) < 0:
        suffix = suffix + ext

    while 1:
        try:
            pwd, dirs, files = next(topdir)
            
            os.chdir(pwd)

            for f in files:
                
                if f.endswith(ext):
                    abspath = os.path.abspath(f)
                    filename = f.split(ext)[0]
                    new_filename = filename + suffix
                    new_filename_path = os.path.join( os.path.dirname(abspath),
                                            new_filename)

                    img = pdb.gimp_file_load(abspath, "")
                    drawable = pdb.gimp_image_get_active_layer(img)
                    pdb.script_fu_addborder(img, drawable, bwidth, bwidth, "#ffffff", 0)
                    pdb.gimp_image_flatten(img)
                    drawable = pdb.gimp_image_get_active_layer(img)
                    pdb.gimp_file_save(img, drawable, new_filename_path, "")

        except StopIteration, e:
            break

register(
    "newborder",  
    "*",
    "*",
    "*",
    "*",
    "2020",  
    "newborder",
    "",
    [(PF_DIRNAME, "directory", "root directory of images for process", ""),
     (PF_FLOAT,    "bwidth",     "Border width", 20.0),
     (PF_STRING,  "extension", "image type", ".jpg"),
     (PF_STRING,  "suffix", "processed image suffix", "_border")], 

    [],
    newborder,
    menu="<Image>/Tools/",) 

main()         
