
;-------------------------------------------------------------------------
; The GIMP -- an image manipulation program
; Copyright (C) 1995 Spencer Kimball and Peter Mattis
;
; Layer Effects script for GIMP 2.8
; Copyright (C) 2001 Iccii
;
; Tags: layer, effects
;
; --------------------------------------------------------------------
; Distributed by GimpChat
; --------------------------------------------------------------------
; version 0.1 by Iccii 2001/08/06
; - Initial relase
; version 0.2 by Iccii 2001/08/07
; - Divide each function into depending function and common function
; version 0.3 by Iccii 2001/08/09
; - Add the Stain script
; version 0.4 by Iccii 2001/08/10
; - Add the Color/Gradient/Pattern Overlay scripts
; version 0.5 by Iccii 2001/08/14
; - Add the Border script (not better)
; version 0.5a by Iccii 2003/05/29
; - Add "Antialias" option in Add Border script
; version 0.6 by Graechan 2013/02/02
; - Add improved Add Border script Added Stroke Script and additional layer style
; - moved script to Iccii/Layer affects
; --------------------------------------------------------------------
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
; corrections made by Michael Hoelzen begin
; 2005-11-12 replaced some deprecated procedures (not all of them)
; 2005-11-12 error corrected in gradient overlay script:
; "do adaptive supersampling" and "supersampling threshold"
; weren't set
; corrections made by Michael Hoelzen end
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Layer Effect common function ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (layer-effects-common1
            img ;
            layer ;
            color ;
            angle ;
            offset-radius ;
            effect-radius ;
            blur-radius ;
            opacity ;
            layer-mode ;
            layer-name ;
            color-side ; (Outer(0) Inner(1) Inner-Inverse(2))			
         )

    (let* (
        (width (car (gimp-drawable-width layer)))
        (height (car (gimp-drawable-height layer)))
        (radians (/ (* 2 *pi* angle) 360))
        (x-offset (* offset-radius (sin radians)))
        (y-offset (* offset-radius (cos radians)))
        (target-layer (car (gimp-layer-copy layer TRUE)))
        (effect-layer (car (gimp-layer-new img width height RGBA-IMAGE layer-name opacity layer-mode)))
        (effect-mask (car (gimp-layer-create-mask effect-layer ADD-MASK-WHITE)))
        (effect-mask2 0)
		(alpha (car (gimp-drawable-has-alpha layer)))
		(sel (car (gimp-selection-is-empty img)))
		(selection 0)
      )
        (if (= alpha FALSE) (gimp-layer-add-alpha layer))
		(if (= sel TRUE) (gimp-selection-layer-alpha layer))
		(set! selection (car (gimp-selection-save img)))
		(gimp-selection-none img)
        ;;
        (gimp-image-add-layer img effect-layer -1)

        (gimp-layer-add-mask effect-layer effect-mask)
        (if (= color-side 0)
        (gimp-invert effect-mask))
        (if (< 0 (car (gimp-layer-get-mask target-layer)))
        ;replaced 2005-11-13
       ; (gimp-image-remove-layer-mask img target-layer MASK-APPLY))
        (gimp-layer-remove-mask target-layer MASK-APPLY))

        ;;
        (gimp-context-set-background color)
        (gimp-drawable-fill effect-layer FILL-BACKGROUND)
        (gimp-selection-load selection)
        (if (= color-side 0)
            (gimp-selection-grow img effect-radius)
            (begin
                (gimp-selection-invert img)
                (gimp-selection-grow img effect-radius)
                (gimp-selection-invert img) ))
        (if (= color-side 0)
            (gimp-context-set-background '(255 255 255))
            (gimp-context-set-background '(0 0 0)))
            (gimp-edit-fill effect-mask FILL-BACKGROUND)
            (gimp-selection-none img)
            ;;
            (gimp-context-set-background '(0 0 0))
        (if (< 0 offset-radius)
            (gimp-drawable-offset effect-mask FALSE OFFSET-BACKGROUND x-offset y-offset))
        (if (< 0 blur-radius)
            (plug-in-gauss-iir2 1 img effect-mask blur-radius blur-radius))
        (if (= color-side 2)
            (gimp-invert effect-mask))

        (gimp-layer-remove-mask effect-layer MASK-APPLY)
        (set! effect-mask2 (car (gimp-layer-create-mask effect-layer ADD-MASK-BLACK)))

        (gimp-layer-add-mask effect-layer effect-mask2)
        (if (= color-side 0)
            (gimp-invert effect-mask2))
        (gimp-selection-load selection)
        (if (= color-side 0)
            (gimp-context-set-background '(0 0 0))
            (gimp-context-set-background '(255 255 255)))
        (gimp-edit-fill effect-mask2 FILL-BACKGROUND)
        (gimp-selection-none img)

        ;;
        (if (= color-side 0)
            (gimp-image-lower-layer img effect-layer))
		(gimp-selection-load selection)
		(gimp-image-remove-channel img selection)	
        (gimp-image-set-active-layer img layer)		
        (list effect-layer)
		
    )
)
(define (draw-blurshape img drawable size initgrowth sel invert)
  (let* ((k initgrowth)
	 (currshade 0)
	 (i 0))
    (while (< i size)
      (if (> k 0)
	(gimp-selection-grow img k)
	(if (< k 0)
	  (gimp-selection-shrink img (abs k))
	)
      )
      (if (= invert 1)
	(set! currshade (math-round (* (/ (- size (+ i 1)) size) 255)))
	(set! currshade (math-round (* (/ (+ i 1) size) 255)))
      )
      (gimp-palette-set-foreground (list currshade currshade currshade))
      (if (= (car (gimp-selection-is-empty img)) 0)
	(gimp-edit-fill drawable 0)
      )
      (gimp-selection-load sel)
      (set! k (- k 1))
      (set! i (+ i 1))
    )
  )
)
(define list-contours
 '("Linear (0)" "Cone (1)" "Cone - Inverted (2)" "Cove - Deep (3)" "Cove-Shallow (4)" "Gaussian (5)" "Half Round (6)" "Ring (7)" 
   "Ring - Double (8)" "Rolling Slope - Descending (9)" "Rounded Steps (10)" "Sawtooth 1 (11)")
)
(define (iccii-contour drawable channel contour)
  (let* ((contourtypes #(0 0 0 0 0 0 0 0 0 1 1))
	 (contourlengths #(6 6 10 14 18 10 18 18 10 256 256))
	 (contours #(#(0 0 127 255 255 0)
#(0 255 127 0 255 255)
#(0 64 94 74 150 115 179 179 191 255)
#(0 0 5 125 6 125 48 148 79 179 107 217 130 255)
#(0 0 33 8 64 38 97 102 128 166 158 209 191 235 222 247 255 255)
#(0 0 28 71 87 166 194 240 255 255)
#(0 0 33 110 64 237 97 240 128 138 158 33 191 5 222 99 255 255)
#(0 0 33 74 64 219 97 186 128 0 158 176 191 201 222 3 255 255)
#(3 255 54 99 97 107 179 153 252 0)
#(0 5 9 13 16 19 22 25 27 29 30 32 33 34 35 36 38 39 40 41 43 44 46 47 48 49 50 51 52 53 54 55 55 56 56 57 57 58 58 59 59 59 60 60 60 61 61 61 61 62 62 62 62 62 63 63 63 63 63 63 64 64 64 64 64 71 75 78 81 84 86 89 91 93 95 96 98 99 101 102 103 104 105 107 107 108 110 111 112 113 114 115 116 117 118 119 119 120 121 121 122 123 123 123 124 124 124 125 125 125 125 125 125 125 126 126 126 126 126 126 126 125 125 125 125 125 125 125 125 130 134 137 141 145 148 151 153 156 158 160 162 163 165 166 167 168 170 171 171 172 173 174 175 176 177 178 178 179 180 181 181 182 183 183 184 184 185 185 186 186 187 187 188 188 189 189 189 189 190 190 190 190 191 191 191 191 191 191 191 191 191 191 193 194 196 197 198 200 201 203 204 205 207 208 209 211 212 213 214 215 217 218 219 220 220 221 222 222 223 223 224 224 224 224 224 223 223 222 222 221 221 220 219 218 217 216 215 214 213 212 211 210 209 208 206 205 204 203 202 200 199 198 197 196 194 194)
#(0 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48 50 52 54 56 58 60 62 64 66 68 70 72 74 76 78 80 82 84 86 88 90 92 94 96 98 100 102 104 106 108 110 112 114 116 118 120 122 124 126 127 125 123 121 119 117 115 113 111 109 107 105 103 101 99 97 95 93 91 89 87 85 83 81 79 77 75 73 71 69 67 65 63 61 59 57 55 53 51 49 47 45 43 41 39 37 35 33 31 29 27 25 23 21 19 17 15 13 11 9 7 5 3 1 1 3 5 7 9 11 13 15 17 19 21 23 25 27 29 31 33 35 37 39 41 43 45 47 49 51 53 55 57 59 61 63 65 67 69 71 73 75 77 79 81 83 85 87 89 91 93 95 97 99 101 103 105 107 109 111 113 115 117 119 121 123 125 127 128 126 124 122 120 118 116 114 112 110 108 106 104 102 100 98 96 94 92 90 88 86 84 82 80 78 76 74 72 70 68 66 64 62 60 58 56 54 52 50 48 46 44 42 40 38 36 34 32 30 28 26 24 22 20 18 16 14 12 10 8 6 4 2))))
    (if (= (vector-ref contourtypes (- contour 1)) 0)
      (gimp-curves-spline drawable channel (vector-ref contourlengths (- contour 1)) (vector-ref contours (- contour 1)))
      (gimp-curves-explicit drawable channel (vector-ref contourlengths (- contour 1)) (vector-ref contours (- contour 1)))
    )
  )
)

(define (math-round input)
  (floor (+ input 0.5))
)

(define (math-ceil input)
  (if (= input (floor input))
    input
    (+ (floor input) 1)
  )
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Drop Shadow Script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (script-fu-layer-effects-drop-shadow
            img ;
            layer ;
            color ;
            angle ;
            offset-radius ;
            radius ;
            blur-radius ;
            opacity ;
            layer-mode ;
        )

   (let* (
        (alpha (car (gimp-drawable-has-alpha layer)))
		(sel (car (gimp-selection-is-empty img)))
      )
    
	(gimp-context-push)
	(gimp-image-undo-group-start img)
	(if (= alpha FALSE) (gimp-layer-add-alpha layer))
	(if (= sel TRUE) (gimp-selection-layer-alpha layer))
    (layer-effects-common1 img layer color angle offset-radius radius blur-radius
    opacity layer-mode "Drop Shadow" 0)
    
	(gimp-selection-none img)
    (gimp-displays-flush)
	(gimp-image-undo-group-end img)
	(gimp-context-pop)
	
   )
)

(script-fu-register
    "script-fu-layer-effects-drop-shadow"
    "<Image>/ICCII FX/Drop Shadow..."
    "Create the Drop Shadow on the layer with alpha"
    "Iccii "
    "Iccii"
    "Aug, 2001"
    "RGB*"
    SF-IMAGE "Image" 0
    SF-DRAWABLE "Drawable" 0
    SF-COLOR "Shadow Color" '(0 0 0)
    SF-ADJUSTMENT "Lighting (degrees)" '(30 0 360 1 15 0 0)
    SF-ADJUSTMENT "Offset Radius" '(10 0 100 1 10 0 1)
    SF-ADJUSTMENT "Shadow Radius" '(0 0 100 1 10 0 1)
    SF-ADJUSTMENT "Shadow Blur Radius" '(5 0 100 1 10 0 1)
    SF-ADJUSTMENT "Drop Shadow Opacity" '(75 0 100 1 10 0 0)
    SF-ENUM "LayerMode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Inner Shadow script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (script-fu-layer-effects-inner-shadow
            img ;
            layer ;
            color ;
            angle ;
            offset-radius ;
            radius ;
            blur-radius ;
            opacity ;
            layer-mode ;
        )

    (let* (
                        
        )
		(gimp-context-push)
        (gimp-image-undo-group-start img)
        (layer-effects-common1 img layer color angle offset-radius radius blur-radius
        opacity layer-mode "Inner Shadow" 1)
		(gimp-selection-none img)
        (gimp-image-undo-group-end img)
        (gimp-displays-flush)
		(gimp-context-pop)
    )
)
(script-fu-register
    "script-fu-layer-effects-inner-shadow"
    "<Image>/ICCII FX/Inner Shadow..."
    "Create the Inner Shadow on the layer with alpha"
    "Iccii "
    "Iccii"
    "Aug, 2001"
    "RGBA"
    SF-IMAGE "Image" 0
    SF-DRAWABLE "Drawable" 0
    SF-COLOR "Shadow Color" '(0 0 0)
    SF-ADJUSTMENT "Lighting (degrees)" '(30 0 360 1 15 0 0)
    SF-ADJUSTMENT "Offset Radius" '(5 0 100 1 10 0 1)
    SF-ADJUSTMENT "Shadow Radius" '(0 0 100 1 10 0 1)
    SF-ADJUSTMENT "Shadow Blur Radius" '(5 0 100 1 10 0 1)
    SF-ADJUSTMENT "Drop Shadow Opacity" '(75 0 100 1 10 0 0)
	SF-ENUM "Shadow Layer Mode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
    
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Outer Glow script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (script-fu-layer-effects-outer-glow
            img ;
            layer ;
            color ;
            radius ;
            blur-radius ;
            opacity ;
            layer-mode ;
        )

  (let* (
                
      )
    (gimp-context-push)
    (gimp-image-undo-group-start img)
    (layer-effects-common1 img layer color 0 0 radius blur-radius
    opacity layer-mode "Outer Glow" 0)
	(gimp-selection-none img)
    (gimp-image-undo-group-end img)
    (gimp-displays-flush)
	(gimp-context-pop)
  )
)

(script-fu-register
    "script-fu-layer-effects-outer-glow"
    "<Image>/ICCII FX/Outer Glow..."
    "Create the Outer Glow on the layer with alpha"
    "Iccii "
    "Iccii"
    "Aug, 2001"
    "RGBA"
    SF-IMAGE "Image" 0
    SF-DRAWABLE "Drawable" 0
    SF-COLOR "Glow Color" '(255 255 191)
    SF-ADJUSTMENT "Glow Radius" '(2 0 100 1 10 0 1)
    SF-ADJUSTMENT "Blur Radius" '(10 0 100 1 10 0 1)
    SF-ADJUSTMENT "Opacity" '(75 0 100 1 10 0 0)
    SF-ENUM "LayerMode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Inner Glow script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (script-fu-layer-effects-inner-glow
            img ;
            layer ;
            color ;
            radius ;
            blur-radius ;
            opacity ;
            layer-mode ;
            glow-type ; Edge(0) or Inside(1)
        )

  (let* (
        (glow-type (+ glow-type 1))
      )
    (gimp-context-push)
    (gimp-image-undo-group-start img)
    (layer-effects-common1 img layer color 0 0 radius blur-radius
    opacity layer-mode "Inner Glow" glow-type)
	(gimp-selection-none img)
    (gimp-image-undo-group-end img)
    (gimp-displays-flush)
	(gimp-context-pop)
  )
)

(script-fu-register
    "script-fu-layer-effects-inner-glow"
    "<Image>/ICCII FX/Inner Glow..."
    "Create the Inner Glow on the layer with alpha"
    "Iccii "
    "Iccii"
    "Aug, 2001"
    "RGBA"
    SF-IMAGE "Image" 0
    SF-DRAWABLE "Drawable" 0
    SF-COLOR "Glow Color" '(255 255 191)
    SF-ADJUSTMENT "Glow Radius" '(2 0 100 1 10 0 1)
    SF-ADJUSTMENT "Blur Radius" '(10 0 100 1 10 0 1)
    SF-ADJUSTMENT "Opacity" '(75 0 100 1 10 0 0)
	SF-ENUM "Glow Layer Mode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
    SF-OPTION "Glow Type" '("Edge" "Inner")
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Bevel and Emboss script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (script-fu-layer-effects-bevel-and-emboss
            img ;
            layer ;
            effect-style ; Outer Bevel(0) Inner Bevel(1)
            ; Emboss(2) Pillow Emboss(3)
            angle ;
            depth ;
            blur-radius ;
            light-color ;
            light-opacity ;
            light-mode ;
            shadow-color ;
            shadow-opacity;
            shadow-mode ;			
        )

(let* (
                		
      )
        (gimp-context-push)
        (gimp-image-undo-group-start img)
        (cond
        ((= effect-style 0) ; Outer Bevel
            (layer-effects-common1 img layer shadow-color angle depth 0 blur-radius
            shadow-opacity shadow-mode "Bevel Shadow" 0)
            (layer-effects-common1 img layer light-color (+ angle 180) depth 0 blur-radius
            light-opacity light-mode "Bevel Light" 0)
        )
            ((= effect-style 1) ; Inner Bevel
            (layer-effects-common1 img layer shadow-color (+ angle 180) depth 0 blur-radius
            shadow-opacity shadow-mode "Bevel Shadow" 1)
            (layer-effects-common1 img layer light-color angle depth 0 blur-radius
            light-opacity light-mode "Bevel Light" 1)
        )
        ((= effect-style 2) ; Emboss
            (layer-effects-common1 img layer shadow-color angle depth 0 blur-radius
            shadow-opacity shadow-mode "Enboss Outer Shadow" 0)
            (layer-effects-common1 img layer light-color (+ angle 180) depth 0 blur-radius
            light-opacity light-mode "Emboss Outer Light" 0)
            (layer-effects-common1 img layer shadow-color (+ angle 180) depth 0 blur-radius
            shadow-opacity shadow-mode "Emboss Inner Shadow" 1)
            (layer-effects-common1 img layer light-color angle depth 0 blur-radius
            light-opacity light-mode "Emboss Inner Light" 1)
			(gimp-image-raise-layer-to-top img layer)			
        )
        ((= effect-style 3) ; Pillow Emboss
            (layer-effects-common1 img layer shadow-color (+ angle 180) depth 0 blur-radius
            shadow-opacity shadow-mode "Enboss Outer Shadow" 0)
            (layer-effects-common1 img layer light-color angle depth 0 blur-radius
            light-opacity light-mode "Emboss Outer Light" 0)
            (layer-effects-common1 img layer shadow-color (+ angle 180) depth 0 blur-radius
            shadow-opacity shadow-mode "Emboss Inner Shadow" 1)
            (layer-effects-common1 img layer light-color angle depth 0 blur-radius
            light-opacity light-mode "Emboss Inner Light" 1)			
        )
        ) ; end of cond
		(gimp-selection-none img)
		(gimp-image-set-active-layer img layer)
		(gimp-image-undo-group-end img)
        (gimp-displays-flush)
		(gimp-context-pop)
    )
)

(script-fu-register
    "script-fu-layer-effects-bevel-and-emboss"
    "<Image>/ICCII FX/Bevel and Emboss..."
    "Create the Bevel and Emboss effects on the layer with alpha"
    "Iccii "
    "Iccii"
    "Aug, 2001"
    "RGB*"
    SF-IMAGE "Image" 0
    SF-DRAWABLE "Drawable" 0
    SF-OPTION "Effect Style" '("Outer Bevel" "Inner Bevel"
    "Emboss" "Pillow Emboss")
    SF-ADJUSTMENT "Lighting (degrees)" '(30 0 360 1 15 0 0)
    SF-ADJUSTMENT "Depth" '(5 0 100 1 10 0 1)
    SF-ADJUSTMENT "Blur Radius" '(5 0 100 1 10 0 1)
    SF-COLOR "Highlight Color" '(255 255 255)
    SF-ADJUSTMENT "Highlight Opacity" '(75 0 100 1 10 0 0)
	SF-ENUM "Highlight Layer Mode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
    SF-COLOR "Shadow Color" '(0 0 0)
    SF-ADJUSTMENT "Shadow Opacity" '(75 0 100 1 10 0 0)
	SF-ENUM "Shadow Layer Mode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
    	
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Satin Effect script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (script-fu-layer-effects-satin img
				 layer
				 color
				 opacity
				 mode
				 offsetangle
				 offsetdist
				 size
				 contour
				 invert
				 merge)
  (gimp-image-undo-group-start img)
  (let* (
	 (origselection (car (gimp-selection-save img)))
	 (layername (car (gimp-drawable-get-name layer)))
	 (growamt (math-ceil (/ size 2)))
	 (lyrgrowamt (math-round (* growamt 1.2)))
	 (satinlayer (car (gimp-layer-new img (+ (car (gimp-drawable-width layer)) (* lyrgrowamt 2)) (+ (car (gimp-drawable-height layer)) (* lyrgrowamt 2)) (cond ((= (car (gimp-image-base-type img)) 0) 1) ((= (car (gimp-image-base-type img)) 1) 3)) (string-append layername "-satin") 100 0)))
	 (satinmask 0)
	 (blacklayer 0)
	 (drwoffsets (gimp-drawable-offsets layer))
	 (ang (* (* (+ offsetangle 180) -1) (/ (* 4 (atan 1.0)) 180)))
	 (offsetX (math-round (* offsetdist (cos ang))))
	 (offsetY (math-round (* offsetdist (sin ang))))
	 (alphaSel 0)
	 (layeraoffsets 0)
	 (layerboffsets 0)
	 (dx 0)
	 (dy 0)
	 (origmask 0)
	 (alphamask 0)
	)
    (gimp-context-push)	
	(gimp-image-add-layer img satinlayer (car (gimp-image-get-layer-position img layer)))
    (gimp-layer-set-offsets satinlayer (- (car drwoffsets) lyrgrowamt) (- (cadr drwoffsets) lyrgrowamt))
    (gimp-selection-all img)
    (gimp-palette-set-foreground '(0 0 0))
    (gimp-edit-fill satinlayer 0)
    (gimp-selection-none img)
    (gimp-selection-layer-alpha layer)
    (if (> (car (gimp-layer-get-mask layer)) -1)
       (gimp-selection-combine (car (gimp-layer-get-mask layer)) 3)
    )
    (set! alphaSel (car (gimp-selection-save img)))
    (draw-blurshape img satinlayer size growamt alphaSel 0)
    (plug-in-autocrop-layer 1 img satinlayer)
    (set! satinmask (car (gimp-layer-copy satinlayer 0)))
    (gimp-image-add-layer img satinmask (car (gimp-image-get-layer-position img satinlayer)))
    (gimp-layer-translate satinlayer offsetX offsetY)
    (gimp-layer-translate satinmask (* offsetX -1) (* offsetY -1))
    (set! layeraoffsets (gimp-drawable-offsets satinlayer))
    (set! layerboffsets (gimp-drawable-offsets satinmask))
    (set! dx (- (max (car layeraoffsets) (car layerboffsets)) (min (car layeraoffsets) (car layerboffsets))))
    (set! dy (- (max (cadr layeraoffsets) (cadr layerboffsets)) (min (cadr layeraoffsets) (cadr layerboffsets))))
    (set! blacklayer (car (gimp-layer-new img (+ (car (gimp-drawable-width satinlayer)) dx) (+ (car (gimp-drawable-height satinlayer)) dy) (cond ((= (car (gimp-image-base-type img)) 0) 1) ((= (car (gimp-image-base-type img)) 1) 3)) (string-append layername "-satinblank") 100 0)))
    (gimp-image-add-layer img blacklayer (+ (car (gimp-image-get-layer-position img satinlayer)) 1))
    (gimp-layer-set-offsets blacklayer (min (car layeraoffsets) (car layerboffsets)) (min (cadr layeraoffsets) (cadr layerboffsets)))
    (gimp-selection-all img)
    (gimp-palette-set-foreground '(0 0 0))
    (gimp-edit-fill blacklayer 0)
    (gimp-selection-none img)
    (gimp-layer-set-mode satinmask 6)
    (set! satinlayer (car (gimp-image-merge-down img satinlayer 0)))
    (set! satinlayer (car (gimp-image-merge-down img satinmask 0)))
    (gimp-drawable-set-name satinlayer (string-append layername "-satin"))
    (if (> contour 0)
      (begin
	(iccii-contour satinlayer 0 contour)
	(gimp-selection-load alphaSel)
	(gimp-selection-grow img size)
	(gimp-selection-invert img)
	(gimp-palette-set-foreground '(0 0 0))
	(gimp-edit-fill satinlayer 0)
	(gimp-selection-none img)
      )
    )
    (if (= invert 1)
      (gimp-invert satinlayer)
    )
    (set! satinmask (car (gimp-layer-create-mask satinlayer 5)))
    (gimp-layer-add-mask satinlayer satinmask)
    (gimp-selection-all img)
    (gimp-palette-set-foreground color)
    (gimp-edit-fill satinlayer 0)
    (gimp-selection-none img)
    (gimp-layer-set-opacity satinlayer opacity)
    (gimp-layer-set-mode satinlayer mode)
    (gimp-layer-resize satinlayer (car (gimp-drawable-width layer)) (car (gimp-drawable-height layer)) (- (car (gimp-drawable-offsets satinlayer)) (car drwoffsets)) (- (cadr (gimp-drawable-offsets satinlayer)) (cadr drwoffsets)))
    (if (= merge 1)
      (begin
	(set! origmask (car (gimp-layer-get-mask layer)))
	(if (> origmask -1)
	  (begin
	    (set! origmask (car (gimp-channel-copy origmask)))
	    (gimp-layer-remove-mask layer 1)
	  )
	)
	(set! alphamask (car (gimp-layer-create-mask layer 3)))
	(set! layer (car (gimp-image-merge-down img satinlayer 0)))
	(gimp-drawable-set-name layer layername)
	(gimp-layer-add-mask layer alphamask)
	(gimp-layer-remove-mask layer 0)
	(if (> origmask -1)
	  (gimp-layer-add-mask layer origmask)
	)
      )
      (begin
	(gimp-selection-load alphaSel)
	(gimp-selection-invert img)
	(gimp-palette-set-foreground '(0 0 0))
	(gimp-edit-fill satinmask 0)
      )
    )
    (if (= merge 0) (gimp-image-raise-layer-to-top img satinlayer))
	(gimp-image-set-active-layer img layer)
	(gimp-selection-load origselection)
    (gimp-image-remove-channel img alphaSel)
    (gimp-image-remove-channel img origselection)
    (gimp-displays-flush)
	(gimp-context-pop)
  )
  (gimp-image-undo-group-end img)
)

(script-fu-register "script-fu-layer-effects-satin"
		    _"<Image>/ICCII FX/Satin..."
		    "Creates a satin effect over a layer."
		    "Graechan for iccii"
            "Graechan - http://gimpchat.com"
            "Feb 2013"
		    "RGBA, GRAYA"
		    SF-IMAGE		"Image"			0
		    SF-DRAWABLE		"Drawable"		0
		    SF-COLOR		_"Color"		'(0 0 0)
		    SF-ADJUSTMENT	"Opacity"		'(75 0 100 1 10 1 0)
		    SF-ENUM         "LayerMode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
		    SF-ADJUSTMENT	"Offset Angle"		'(19 -180 180 1 10 1 0)
		    SF-ADJUSTMENT	"Offset Distance"	'(11 0 30000 1 10 1 1)
		    SF-ADJUSTMENT	"Size"			'(14 0 250 1 10 0 0)
		    SF-OPTION		"Contour"       list-contours
		    SF-TOGGLE		"Invert"		TRUE
		    SF-TOGGLE		"Merge with layer"	FALSE)
			


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Color Overlay script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define (script-fu-layer-effects-color-overlay
    img ;
    layer ;
    color ;
    opacity ;
    layer-mode ;
	
)

(let* (
        (width (car (gimp-drawable-width layer)))
        (height (car (gimp-drawable-height layer)))
		(offx (car (gimp-drawable-offsets layer)))
	    (offy (cadr (gimp-drawable-offsets layer)))
        (color-layer (car (gimp-layer-new img width height RGBA-IMAGE
        "Color Fill Layer" opacity layer-mode)))
		(color-mask 0)
        )
        (gimp-context-push)
        (gimp-image-undo-group-start img)
        (gimp-image-add-layer img color-layer -1)
		(gimp-layer-set-offsets color-layer offx offy)
        (gimp-drawable-fill color-layer TRANS-IMAGE-FILL)
        (gimp-selection-layer-alpha layer)
        (gimp-context-set-background color)
        (gimp-drawable-fill color-layer BG-IMAGE-FILL)
		(set! color-mask (car (gimp-layer-create-mask color-layer ADD-MASK-SELECTION)))
	    (gimp-layer-add-mask color-layer color-mask)
        (gimp-selection-none img)
		
        (gimp-image-set-active-layer img layer)
        (gimp-image-undo-group-end img)
        (gimp-displays-flush)
		(gimp-context-pop)
        (list color-layer)
      )
)

(script-fu-register
    "script-fu-layer-effects-color-overlay"
    "<Image>/ICCII FX/Color Overlay..."
    "Create the Color overlay effect on the layer with alpha"
    "Iccii "
    "Iccii"
    "Aug, 2001"
    "RGBA"
    SF-IMAGE "Image" 0
    SF-DRAWABLE "Drawable" 0
    SF-COLOR "Color" '(0 0 0)
    SF-ADJUSTMENT "Opacity" '(100 0 100 1 10 0 0)
	SF-ENUM "Color Fill Mode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
   	
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Gradient Overlay script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        ;(script-fu-layer-effects-gradient-overlay img layer '(255 255 255) '(214 214 214) 3 "FG to BG (Hardedge)" angle 1.0 75 0 0 0)
(define (script-fu-layer-effects-gradient-overlay
            img ;
            layer ;
            fg-color ;
            bg-color ;
            blend-mode ;("FG-BG RGB" "FG-BG HSV" "FG-Trans" "Custom")
            gradient ;
            angle ;
            scale ;
            opacity ;
            layer-mode ;
            style ;
            repeat ;
         )

  (let* (
        (width (car (gimp-drawable-width layer)))
        (height (car (gimp-drawable-height layer)))
		(offx (car (gimp-drawable-offsets layer)))
	    (offy (cadr (gimp-drawable-offsets layer)))
        (radians (/ (* 2 *pi* angle) 360))
        (x-distance (* 0.5 scale width (sin radians)))
        (y-distance (* 0.5 scale height (cos radians)))
        (x-center (/ width 2))
        (y-center (/ height 2))
        (x1 (- x-center x-distance))
        (y1 (- y-center y-distance))
        (x2 (+ x-center x-distance))
        (y2 (+ y-center y-distance))
        (gradient-layer (car (gimp-layer-new img width height RGBA-IMAGE
        "Gradient Fill Layer" opacity layer-mode)))
		(gradient-mask 0)
      )
        (gimp-context-push)
        (gimp-image-undo-group-start img)
        (gimp-image-add-layer img gradient-layer -1)
		(gimp-layer-set-offsets gradient-layer offx offy)
        (gimp-drawable-fill gradient-layer TRANS-IMAGE-FILL)
        (gimp-context-set-foreground fg-color)
        (gimp-context-set-background bg-color)
        (gimp-context-set-gradient gradient)
        (gimp-edit-blend gradient-layer blend-mode LAYER-MODE-NORMAL style 100 0 repeat
        FALSE FALSE 0 0 0 x1 y1 x2 y2)
		(gimp-selection-layer-alpha layer)
		(set! gradient-mask (car (gimp-layer-create-mask gradient-layer ADD-MASK-SELECTION)))
	    (gimp-layer-add-mask gradient-layer gradient-mask)
        (gimp-selection-none img)

        (gimp-image-set-active-layer img layer)
        (gimp-image-undo-group-end img)
        (gimp-displays-flush)
		(gimp-context-pop)
        (list gradient-layer)
  )
)

(script-fu-register
    "script-fu-layer-effects-gradient-overlay"
    "<Image>/ICCII FX/Gradient Overlay..."
    "Create the Gradient overlay effect on the layer with alpha"
    "Iccii "
    "Iccii"
    "Aug, 2001"
    "RGBA"
    SF-IMAGE "Image" 0
    SF-DRAWABLE "Drawable" 0
    SF-COLOR "Foreground Color" '(127 255 255)
    SF-COLOR "Background Color" '(127 255 127)
    SF-ENUM "Blend Mode" '("BlendMode" "BLEND-CUSTOM")
    SF-GRADIENT "Custom Gradient" "Sunrise"
    SF-ADJUSTMENT "Angle" '(30 0 360 1 15 0 0)
    SF-ADJUSTMENT "Scale" '(1.00 0.05 5 0.05 0.1 2 0)
    SF-ADJUSTMENT "Opacity" '(100 0 100 1 10 0 0)
	SF-ENUM "Gradient Fill Mode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
	SF-ENUM "Gradient Style" '("GradientType" "gradient-linear")
    SF-OPTION "Repeat" '("None" "Sawtooth Wave" "Triangular Wave")
)



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Pattern Overlay script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define (script-fu-layer-effects-pattern-overlay
    img ;
    layer ;
    pattern ;
    opacity ;
    layer-mode ;
)

    (let* (
            (width (car (gimp-drawable-width layer)))
            (height (car (gimp-drawable-height layer)))
			(offx (car (gimp-drawable-offsets layer)))
	        (offy (cadr (gimp-drawable-offsets layer)))
            (pattern-layer (car (gimp-layer-new img width height RGBA-IMAGE
            "Pattern Fill Layer" opacity layer-mode)))
			(pattern-mask 0)
          )
        (gimp-context-push)
        (gimp-image-undo-group-start img)
        (gimp-image-add-layer img pattern-layer -1)
		(gimp-layer-set-offsets pattern-layer offx offy)
        (gimp-drawable-fill pattern-layer TRANS-IMAGE-FILL)
        (gimp-context-set-pattern pattern)
        (gimp-drawable-fill pattern-layer FILL-PATTERN)
		(gimp-selection-layer-alpha layer)
		(set! pattern-mask (car (gimp-layer-create-mask pattern-layer ADD-MASK-SELECTION)))
	    (gimp-layer-add-mask pattern-layer pattern-mask)
        (gimp-selection-none img)

        (gimp-image-set-active-layer img layer)
        (gimp-image-undo-group-end img)
        (gimp-displays-flush)
		(gimp-context-pop)
        (list pattern-layer)
    )
)

(script-fu-register
    "script-fu-layer-effects-pattern-overlay"
    "<Image>/ICCII FX/Pattern Overlay..."
    "Create the Pattern overlay effect on the layer with alpha"
    "Iccii "
    "Iccii"
    "Aug, 2001"
    "RGBA"
    SF-IMAGE "Image" 0
    SF-DRAWABLE "Drawable" 0
    SF-PATTERN "Pattern" "Pine?"
    SF-ADJUSTMENT "Opacity" '(100 0 100 1 10 0 0)
	SF-ENUM "Pattern Fill Mode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
    
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Add Border script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (script-fu-layer-effects-add-border
            img ;
            layer ;			
            type ; Color(0) Gradient(1) Pattern(2)
            size ;
            position-in ;
            opacity ;
			blur-radius ;
            layer-mode ;
            color ;
            fg-color ;
            bg-color ;
            blend-mode ;
            gradient ;
            angle ;
            scale ;
            style ;
            repeat ;
            pattern ;
            antialias? ;
        )
        
		(gimp-image-undo-group-start img)
		(gimp-context-push)
		
    (let* (
            (width (car (gimp-drawable-width layer)))
            (height (car (gimp-drawable-height layer)))
			(alpha (car (gimp-drawable-has-alpha layer)))
            (border-layer 0)
			(position position-in)
			(c-size (/ size 2))
            (result-layer 0)
          )
        
		(if (= alpha FALSE) (gimp-layer-add-alpha layer))
		
;;;;set for outer border
		(if (= position 1) (begin
		(gimp-layer-resize layer (+ width (* size 2)) (+ height (* size 2)) size size)
		(gimp-image-resize-to-layers img)
		(set! width (car (gimp-drawable-width layer)))
        (set! height (car (gimp-drawable-height layer)))
		(set! position 0)))
		
;;;;set for center border
		(if (= position 2) (begin
		(gimp-layer-resize layer (+ width (* c-size 2)) (+ height (* c-size 2)) c-size c-size)
		(gimp-image-resize-to-layers img)
		(set! width (car (gimp-drawable-width layer)))
        (set! height (car (gimp-drawable-height layer)))
		(set! position 0)))

;;;;create the border layer		
		(set! border-layer (car (gimp-layer-new img width height RGBA-IMAGE "Boder Line" opacity layer-mode)))
        (gimp-image-add-layer img border-layer -1)
        (gimp-drawable-fill border-layer TRANS-IMAGE-FILL)

;;;;create border selection
		(gimp-rect-select img
                        (car (gimp-drawable-offsets layer)) ;offx
                        (cadr (gimp-drawable-offsets layer)) ;offy
                        width
                        height
						CHANNEL-OP-REPLACE ;operation{ CHANNEL-OP-ADD (0), CHANNEL-OP-SUBTRACT (1), CHANNEL-OP-REPLACE (2), CHANNEL-OP-INTERSECT (3) }
						FALSE ;feather
						10) ;feather radious
        (cond
            ((= position 0)
            (gimp-selection-shrink img (- size 3)))
            ((= position 1)
            (gimp-selection-grow img (- size 2)))
        ) ; end of cond
        (if (< (car (gimp-selection-is-empty img)) 0)
        (gimp-message "The selection is empty. Abort.")
            (begin
                (gimp-selection-border img size)
                (gimp-selection-sharpen img)
                (gimp-edit-fill border-layer WHITE-IMAGE-FILL)
                (if (= antialias? TRUE)
                    (begin
                    (gimp-layer-scale border-layer (* 2 width) (* 2 height) 0)
                    (gimp-layer-scale border-layer width height 0)))
                (set! result-layer (car
               (cond
                   ((= type 0)
                   (script-fu-layer-effects-color-overlay
                   img border-layer color opacity layer-mode TRUE))
                   ((= type 1)
                   (script-fu-layer-effects-gradient-overlay
                   img border-layer fg-color bg-color blend-mode gradient
                   angle scale opacity layer-mode style repeat))
                   ((= type 2)
                   (script-fu-layer-effects-pattern-overlay
                   img border-layer pattern opacity layer-mode))
               ) ; end of cond
               )) ; end of set! and car
        (set! border-layer (car (gimp-image-merge-down img result-layer 0)))
		(if (< 0 blur-radius) (plug-in-gauss-iir2 1 img border-layer blur-radius blur-radius))
            ) ; end of begin
        ) ; end of if

        (gimp-image-set-active-layer img layer)
        (gimp-image-undo-group-end img)
        (gimp-displays-flush)
		(gimp-context-pop)
        (list border-layer)
    )
)

(script-fu-register
    "script-fu-layer-effects-add-border"
    "<Image>/ICCII FX/Add Border..."
    "Create the Add Border effect on the layer with alpha"
    "Iccii "
    "Iccii"
    "Aug, 2001"
    "RGB*"
    SF-IMAGE "Image" 0
    SF-DRAWABLE "Drawable" 0
	SF-OPTION "Border Fill Type" '("Color" "Gradient" "Pattern")
    SF-ADJUSTMENT "Border Size" '(5 3 100 1 10 0 1)
    SF-OPTION "Border Position" '("Inner Border" "Outer Border" "Center Border")
    SF-ADJUSTMENT "Opacity" '(100 0 100 1 10 0 0)
	SF-ADJUSTMENT "Border Blur" '(0 0 100 1 10 0 0)
	SF-ENUM "Border Fill Mode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
    SF-COLOR "Color" '(0 0 0)
    SF-COLOR "Foreground Color" '(127 255 255)
    SF-COLOR "Background Color" '(127 255 127)
    SF-ENUM "Blend Mode" '("BlendMode" "BLEND-CUSTOM")
    SF-GRADIENT "Custom Gradient" "Sunrise"
    SF-ADJUSTMENT "Angle" '(30 0 360 1 15 0 0)
    SF-ADJUSTMENT "Scale" '(1.00 0.05 5 0.05 0.1 2 0)
	SF-ENUM "Gradient Style" '("GradientType" "gradient-linear")
    SF-OPTION "Repeat" '("None" "Sawtooth Wave" "Triangular Wave")
    SF-PATTERN "Pattern" "Pine?"
    SF-TOGGLE "Antialias" TRUE
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Layer Stroke script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define (script-fu-layer-stroke img layer
                  type ; Color(0) Gradient(1) Pattern(2)
				  color
				  opacity
				  mode
				  size
				  position
				  fg-color ;
                  bg-color ;
                  blend-mode ;
                  gradient ;
				  angle ;
                  scale ;
                  style ;
                  repeat ;
				  pattern ;				  
				  )
	
	(gimp-image-undo-group-start img)						  

 (let* (            
			(width (car (gimp-drawable-width layer)))
			(height (car (gimp-drawable-height layer)))
			(original-width width)
			(original-height height)
			(area (* 1000 1000))
			(alpha (car (gimp-drawable-has-alpha layer)))
		    (sel (car (gimp-selection-is-empty img)))
			(typeA (car (gimp-drawable-type-with-alpha layer)))
		    (layer-name (car (gimp-drawable-get-name layer)))
			(inc (if (> position 0) (* (/ size 100) position) 0))
			(stroke-layer (car (gimp-layer-new img (+ width (* inc 2)) (+ height (* inc 2)) typeA "Stroke Layer" 100 LAYER-MODE-NORMAL)))
		    (alpha-selection 0)
			(inner-selection 0)
			(outer-selection 0)
			(mask-selection 0)
			(stroke-mask 0)
			(result-layer 0)
			(visible 0)
			(selection-bounds 0)			
        )
	
	(gimp-image-add-layer img stroke-layer 0)
	(if (> position 0) (gimp-layer-set-offsets stroke-layer (- 0 inc) (- 0 inc)))
	
	(gimp-context-push)
    (gimp-context-set-default-colors)

	(if (= alpha FALSE) (gimp-layer-add-alpha layer))
	
;;;;check that a selection was made if not make one	
	(if (= sel TRUE) (gimp-selection-layer-alpha layer))
	
;;;;create selection-channel (gimp-selection-load alpha-selection)    
	(set! alpha-selection (car (gimp-selection-save img)))	
	
;;;;begin the script	
	(if (> position 0) (begin
	(gimp-image-resize-to-layers img)
	(gimp-selection-grow img inc)
	(set! outer-selection (car (gimp-selection-save img)))
	(gimp-edit-fill stroke-layer FILL-BACKGROUND)
	(gimp-image-set-active-layer img stroke-layer)
	(plug-in-autocrop-layer 1 img stroke-layer)
	(gimp-drawable-fill stroke-layer FILL-TRANSPARENT)
	(gimp-image-resize-to-layers img)
	(gimp-selection-load alpha-selection)
	(gimp-selection-shrink img (- size inc))
	(set! inner-selection (car (gimp-selection-save img)))
	))

	(if (= position 0) (begin
	(gimp-selection-load alpha-selection)
	(set! outer-selection (car (gimp-selection-save img)))
	(gimp-selection-shrink img size)
	(set! inner-selection (car (gimp-selection-save img)))
	))
	
;;;;create the selection for mask	
	(gimp-selection-load outer-selection)
	(gimp-selection-combine inner-selection 1)
	(set! mask-selection (car (gimp-selection-save img)))
	(gimp-selection-none img)
	
	(gimp-image-set-active-layer img stroke-layer)
	
	(gimp-drawable-fill stroke-layer FILL-BACKGROUND)
	

	(set! result-layer (car
               (cond
                   ((= type 0)
                   (script-fu-layer-effects-color-overlay
                   img stroke-layer color opacity mode))
                   ((= type 1)
                   (script-fu-layer-effects-gradient-overlay
                   img stroke-layer fg-color bg-color blend-mode gradient
                   angle scale opacity mode style repeat))
                   ((= type 2)
                   (script-fu-layer-effects-pattern-overlay
                   img stroke-layer pattern opacity mode))
               ) ; end of cond
               )) ; end of set! and car
	
	(set! stroke-layer (car (gimp-image-merge-down img result-layer 0)))
    	
;;;;create the mask	
	(gimp-selection-load mask-selection)
	(set! stroke-mask (car (gimp-layer-create-mask stroke-layer ADD-MASK-SELECTION)))
	(gimp-layer-add-mask stroke-layer stroke-mask)	
	
;;;;finish the script
    (gimp-image-remove-channel img alpha-selection)
    (gimp-image-remove-channel img outer-selection)
    (gimp-image-remove-channel img inner-selection)
    (gimp-image-remove-channel img mask-selection)
	(gimp-selection-none img)
	(gimp-image-set-active-layer img layer)

	(gimp-displays-flush)
	(gimp-image-undo-group-end img)
	(gimp-context-pop)

 )
)

(script-fu-register "script-fu-layer-stroke"        		    
  "Stroke..."
  "Strokes a image with [alpha] bkg or selection with a color, gradient or pattern."
  "Graechan"
  "Graechan - http://gimpchat.com"
  "Feb 2013"
  "RGB*"
  SF-IMAGE      "image"      0
  SF-DRAWABLE   "drawable"   0
  SF-OPTION "Stroke Fill Type" '("Color" "Gradient" "Pattern")
  SF-COLOR		_"Color"				'(0 0 0)
  SF-ADJUSTMENT	"Opacity"				'(100 0 100 1 10 1 0)
  SF-ENUM "Blending Mode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
  SF-ADJUSTMENT	"Size"					'(6 1 999 1 10 0 1)
  SF-ADJUSTMENT	"Position (0 = inside, 100 = outside)"	'(50 0 100 10 10 0 0)
  SF-COLOR "Foreground Color" '(127 255 255)
  SF-COLOR "Background Color" '(127 255 127)
  SF-ENUM "Blend Mode" '("BlendMode" "BLEND-CUSTOM")
  SF-GRADIENT "Custom Gradient" "Sunrise"
  SF-ADJUSTMENT "Angle" '(30 0 360 1 15 0 0)
  SF-ADJUSTMENT "Scale" '(1.00 0.05 5 0.05 0.1 2 0)
  SF-ENUM "Gradient Style" '("GradientType" "gradient-linear")
  SF-OPTION "Repeat" '("None" "Sawtooth Wave" "Triangular Wave")
  SF-PATTERN "Pattern" "Pine?")

(script-fu-menu-register "script-fu-layer-stroke" "<Image>/ICCII FX")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Vignette script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define (script-fu-layer-vignette img layer
                               vignette-shape
							   size
							   vignette-opacity
							   type ; Color(0) Gradient(1) Pattern(2)
				               color
				               opacity
				               mode
				               fg-color ;
                               bg-color ;
                               blend-mode ;
                               gradient ;
				               angle ;
                               scale ;
                               style ;
                               repeat ;
				               pattern ;	
							   )							  
    
	(gimp-image-undo-group-start img)
	
 (let* (
            (width (car (gimp-image-width img)))
			(height (car (gimp-image-height img)))
			(alpha (car (gimp-drawable-has-alpha layer)))
			(layer-name (car (gimp-drawable-get-name layer)))
			(name-string (string-append (car (gimp-drawable-get-name layer)) "-Vignette"))
			(sel (car (gimp-selection-is-empty img)))
			(original-selection-channel 0)			
			(vignette-layer 0)
			(vignette-mask 0)
			(vignette-selection 0)
			(result-layer 0)
			(vig-x width)
            (vig-y height)
            (feather 120)            			
        )

	(gimp-context-push)
    (gimp-context-set-foreground '(0 0 0))
	(gimp-context-set-background '(255 255 255))
	
	(if (= alpha FALSE) (gimp-layer-add-alpha layer))

;;;;MASK-APPLY the vignette
    (gimp-selection-none img)
    (if (> width 640) (set! vig-x 640))
	(if (> height 520) (set! vig-y 520))
	(if (< width 640) (set! feather (/ width 5.33)))
	(if (< height 520) (set! feather (/ height 4.33)))
	(set! vignette-layer (car (gimp-layer-new img vig-x vig-y  RGBA-IMAGE "Vignette" vignette-opacity LAYER-MODE-NORMAL)))
	(gimp-image-add-layer img vignette-layer 0)
	(if (= vignette-shape 1) (gimp-ellipse-select img 0 0 vig-x vig-y 0 TRUE FALSE 10))
	(if (= vignette-shape 0) (gimp-round-rect-select img 0 0 vig-x vig-y 50 50 2 TRUE FALSE 0 0))
	(gimp-selection-shrink img size)
	(gimp-selection-feather img feather)
	(gimp-selection-invert img)	
	(gimp-image-set-active-layer img vignette-layer)
	(gimp-context-set-foreground '(0 0 0))
	(gimp-context-set-background '(255 255 255))
	(gimp-context-set-gradient "FG to Transparent")
	(gimp-edit-blend vignette-layer BLEND-CUSTOM LAYER-MODE-NORMAL   GRADIENT-RADIAL 100 0 REPEAT-NONE TRUE FALSE 3 0.2 TRUE (/ vig-x 2) (/ vig-y 2) vig-x vig-y)
	(gimp-selection-none img)
	(gimp-layer-scale vignette-layer width height FALSE)	
	
	(gimp-selection-layer-alpha vignette-layer)
;;;;create vignette-selection (gimp-selection-load vignette-selection)    
	(set! vignette-selection (car (gimp-selection-save img)))
	(gimp-drawable-fill vignette-layer FILL-BACKGROUND)
	(gimp-selection-none img)
	
	(set! result-layer (car
               (cond
                   ((= type 0)
                   (script-fu-layer-effects-color-overlay
                   img vignette-layer color opacity mode))
                   ((= type 1)
                   (script-fu-layer-effects-gradient-overlay
                   img vignette-layer fg-color bg-color blend-mode gradient
                   angle scale opacity mode style repeat))
                   ((= type 2)
                   (script-fu-layer-effects-pattern-overlay
                   img vignette-layer pattern opacity mode))
               ) ; end of cond
               )) ; end of set! and car
	
	(set! vignette-layer (car (gimp-image-merge-down img result-layer 0)))
    (gimp-layer-set-opacity vignette-layer vignette-opacity)	
	
;;;;create the vignette-mask	
	(gimp-selection-load vignette-selection)
	(set! vignette-mask (car (gimp-layer-create-mask vignette-layer ADD-MASK-SELECTION)))
	(gimp-layer-add-mask vignette-layer vignette-mask)
	(gimp-selection-none img)
	(gimp-image-remove-channel img vignette-selection)
	(gimp-image-set-active-layer img layer)
	
	(gimp-displays-flush)
	(gimp-image-undo-group-end img)
	(gimp-context-pop)
	
 )
)

(script-fu-register "script-fu-layer-vignette"        		    
  "Add Vignette"
  "Can MASK-APPLY a Vignette to the Image using Color, Gradient, or Pattern"
  "Graechan"
  "Graechan - http://gimpchat.com"
  "2013"
  "RGB*"
  SF-IMAGE      "image"      0
  SF-DRAWABLE   "drawable"   0
  SF-OPTION "Vignette Shape" '("Rectangular" "Ellipse")
  SF-ADJUSTMENT "Vignette Size" '(50 0 200 1 10 0 0)
  SF-ADJUSTMENT "Vignette Opacity" '(80 0 100 1 10 0 0)
  SF-OPTION "Vignette Fill Type" '("Color" "Gradient" "Pattern")
  SF-COLOR		_"Color"				'(0 0 0)
  SF-ADJUSTMENT	"Opacity"				'(100 0 100 1 10 1 0)
  SF-ENUM "Blending Mode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
  SF-COLOR "Foreground Color" '(127 255 255)
  SF-COLOR "Background Color" '(127 255 127)
  SF-ENUM "Blend Mode" '("BlendMode" "BLEND-CUSTOM")
  SF-GRADIENT "Custom Gradient" "Sunrise"
  SF-ADJUSTMENT "Angle" '(30 0 360 1 15 0 0)
  SF-ADJUSTMENT "Scale" '(1.00 0.05 5 0.05 0.1 2 0)
  SF-ENUM "Gradient Style" '("GradientType" "gradient-linear")
  SF-OPTION "Repeat" '("None" "Sawtooth Wave" "Triangular Wave")
  SF-PATTERN "Pattern" "Pine?"
)

(script-fu-menu-register "script-fu-layer-vignette" "<Image>/ICCII FX")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Layer Style sample script ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (script-fu-layer-effects-styles-sample1
    img ;
    layer ;
    angle ;
    bev-depth ;
	bev-blur ;
	pattern ;
	gradient
	grad-opacity
	sat-off
	sat-opacity
	size
	vignette-opacity
	color
)

    (let* (
            (old-bg (car (gimp-context-get-background)))
          )

            (gimp-image-undo-group-start img)
			(script-fu-layer-effects-bevel-and-emboss img layer 2 angle bev-depth bev-blur '(255 255 255) 75 0 '( 0 0 0) 75 0)
			(script-fu-layer-effects-gradient-overlay img layer "Red" "Blue" 3 gradient angle 1.0 grad-opacity 0 0 0)
            (script-fu-layer-effects-pattern-overlay img layer pattern 100 0)
			(script-fu-layer-effects-satin img layer "Black" sat-opacity 0 19 sat-off 14 7 TRUE FALSE)
			(script-fu-layer-vignette img layer 0 size vignette-opacity 0 color 100 0 '(127 255 255) '(127 255 127) 0 "Sunrise" 30 1.00 0 0 "Pine?")
            (gimp-image-undo-group-end img)
            (gimp-displays-flush)
    )
)
(script-fu-register
    "script-fu-layer-effects-styles-sample1"
    "<Image>/ICCII FX/Style Sample1..."
    "Layer Style sample script."
    "Iccii "
    "Iccii"
    "Aug, 2001"
    "RGBA"
    SF-IMAGE "Image" 0
    SF-DRAWABLE "Drawable" 0
    SF-ADJUSTMENT "Angle (Degree)" '(30 0 360 1 10 0 0)
	SF-ADJUSTMENT "Bevel Depth " '(5 0 100 1 5 0 0) 
    SF-ADJUSTMENT "Bevel Blur" '(5 0 100 1 5 0 0)
    SF-PATTERN "Pattern" "Pine?"
	SF-GRADIENT   "Background Gradient" "Tropical Colors"
	SF-ADJUSTMENT "Gradient Opacity" '(60 0 100 1 10 0 0)
	SF-ADJUSTMENT	"Satin Offset dist"	'(11 0 100 1 5 0 0)
    SF-ADJUSTMENT "Satin Opacity" '(60 0 100 1 5 0 0)
	SF-ADJUSTMENT "Vignette Size" '(50 0 200 1 10 0 0)
    SF-ADJUSTMENT "Vignette Opacity" '(80 0 100 1 10 0 0)
	SF-COLOR	  "Vignette Color"				'(0 0 0)
)

(define (script-fu-layer-effects-styles-sample2 
                               img 
                               layer
							   overlay-color
							   overlay-opacity							   
							   in-color
							   glow-color
							   in-pos
							   in-off-rad
							   in-blur
							   in-opacity
                               ds-pos
							   ds-off-rad
							   ds-blur
							   bev-pos
							   bev-depth
							   bev-blur
							   sat-off
							   sat-opacity
							   border-size
							   border-blur
							   border-color
							   stroke-size
							   stroke-color
							   )
	
	(gimp-image-undo-group-start img)		
	(gimp-context-push)

;;;;begin the style script
	(script-fu-layer-effects-outer-glow img layer glow-color 10 10 75 0)
	(script-fu-layer-stroke img layer 0 stroke-color 100 0 stroke-size 100 '(127 255 255) '(127 255 127) 0 "Sunrise" 30 1.00 0 0 "Pine?")
	(script-fu-layer-effects-color-overlay img layer overlay-color overlay-opacity 0)
	(script-fu-layer-effects-inner-shadow  img layer in-color in-pos in-off-rad 0 in-blur in-opacity 0)
	(script-fu-layer-effects-drop-shadow img layer "Black" ds-pos ds-off-rad 0 ds-blur 75 0)
	(script-fu-layer-effects-bevel-and-emboss  img layer 1 bev-pos bev-depth bev-blur "White" 75 0 "Black" 75 0)
	(script-fu-layer-effects-add-border img layer 0 border-size 1 100 border-blur 0 border-color "Black" "White" 0 "Sunrise" 30 1.00 0 0 "Pine?" TRUE)
	(script-fu-layer-effects-satin img layer "Black" sat-opacity 0 19 sat-off 14 1 TRUE FALSE)
			
;;;;end off style script
	(gimp-displays-flush)
	(gimp-image-undo-group-end img)
	(gimp-context-pop)
	
)

(script-fu-register         		    
  "script-fu-layer-effects-styles-sample2"
    "<Image>/ICCII FX/Style Sample2..."
    "Layer Style sample script."
  "Graechan"
  "Graechan - http://gimpchat.com"
  "2012"
  "RGBA"
  SF-IMAGE      "image"      0
  SF-DRAWABLE   "drawable"   0
  SF-COLOR      "Overlay Color"         '(0 255 0)
  SF-ADJUSTMENT "Overlay Opacity" '(100 0 100 1 5 0 0) ;SF-ENUM "LayerMode" '("LayerModeEffects" "LAYER-MODE-NORMAL")
  SF-COLOR      "Inner Shadow Color"         "White"
  SF-COLOR      "Glow Color" '(255 255 191) 
  SF-ADJUSTMENT "Inner Position (deg)" '(90 0 360 1 5 0 0)
  SF-ADJUSTMENT "Inner Offset Radius" '(15 0 100 1 5 0 0)
  SF-ADJUSTMENT "Inner Blur Radius" '(20 0 100 1 5 0 0)
  SF-ADJUSTMENT "Inner Opacity" '(50 0 100 1 5 0 0)
  SF-ADJUSTMENT "Shadow Position (deg)" '(30 0 360 1 5 0 0)
  SF-ADJUSTMENT "Shadow Offset Radius" '(30 0 100 1 5 0 0)
  SF-ADJUSTMENT "Shadow Blur Radius" '(30 0 100 1 5 0 0)
  SF-ADJUSTMENT "Bevel Lighting (deg)" '(30 0 360 1 10 0 0)
  SF-ADJUSTMENT "Bevel Depth " '(5 0 100 1 5 0 0) 
  SF-ADJUSTMENT "Bevel Blur" '(5 0 100 1 5 0 0)
  SF-ADJUSTMENT	"Satin Offset dist"	'(11 0 100 1 5 0 0)
  SF-ADJUSTMENT "Satin Opacity" '(60 0 100 1 5 0 0)
  SF-ADJUSTMENT "Border Size" '(5 3 100 1 5 0 0)
  SF-ADJUSTMENT "Border Blur" '(0 0 100 1 10 0 0)
  SF-COLOR      "Border Color" "Black"
  SF-ADJUSTMENT "Stroke Size" '(5 3 100 1 5 0 0)
  SF-COLOR      "Stroke Color" "Black"
  
)

(define (script-fu-text-creator 
                                      img-width
                                      img-height
                                      text
									  letter-spacing
									  line-spacing
									  color 
                                      font-in 
                                      font-size
                                      bkg-type 
                                      pattern
                                      bkg-color
									  gradient)
									  
  (let* ((width img-width)
         (height img-height)
         (offx 0)
         (offy 0)
         (image (car (gimp-image-new img-width img-height RGB)))
         (border (/ font-size 3))
		 (font (if (> (string-length font-in) 0) font-in (car (gimp-context-get-font))))
         (layer (car (gimp-text-fontname image -1 0 0 text border TRUE font-size PIXELS font)))
         (text-width (car (gimp-drawable-width layer)))
         (text-height (car (gimp-drawable-height layer)))
		 (final-width 0)
		 (final-height 0)
		 (bkg-layer 0))
		 
    (gimp-context-push)
	(gimp-context-set-foreground '(0 0 0))
	(gimp-context-set-background '(255 255 255))
	
;;;;Adjust the text on line
	(gimp-text-layer-set-justification layer 2)
	(gimp-text-layer-set-letter-spacing layer letter-spacing)
	(gimp-text-layer-set-line-spacing layer line-spacing)
	(set! text-width (car (gimp-drawable-width layer)))
    (set! text-height (car (gimp-drawable-height layer)))
	
;;;;set the new Image size
	(if (> text-width img-width) (set! width text-width))           
    (if (> text-height img-height) (set! height text-height))
	(set! final-width width)
	(set! final-height height)

;;;;resize the image	
	(gimp-image-resize image width height 0 0)

;;;;centre the text layer	
    (set! offx (/ (- width text-width) 2))
    (set! offy (/ (- height text-height) 2))    
    (gimp-layer-set-offsets layer offx offy)	

;;;;set the text clolor    
    (gimp-context-set-foreground color)
	(gimp-selection-layer-alpha layer)
	(gimp-edit-fill layer FILL-FOREGROUND)
	(gimp-selection-none image)

;;;;create the background layer    
	(if (< bkg-type 3) (begin
	(set! bkg-layer (car (gimp-layer-new image width height RGBA-IMAGE "Background" 100 LAYER-MODE-NORMAL)))
    (gimp-image-add-layer image bkg-layer (+ (car (gimp-image-get-layer-position image layer)) 1))
	(gimp-context-set-pattern pattern)
	(gimp-context-set-background bkg-color)
	(gimp-context-set-gradient gradient)
	(if (= bkg-type 1) (gimp-drawable-fill bkg-layer FILL-PATTERN))		
    (if (= bkg-type 0) (gimp-drawable-fill bkg-layer FILL-BACKGROUND))	
    (if (= bkg-type 2) (gimp-edit-blend bkg-layer BLEND-CUSTOM LAYER-MODE-NORMAL  GRADIENT-LINEAR 100 0 REPEAT-NONE FALSE FALSE 3 0.2 TRUE 0 0 width height))));; GRADIENT-LINEAR ; GRADIENT-CONICAL-SYMMETRIC
              
    (gimp-image-set-active-layer image layer)
	(gimp-layer-resize-to-image-size layer)
    
	(gimp-context-pop)
    (gimp-display-new image)
	
    )
  )
  
(script-fu-register "script-fu-text-creator"
  "*Text Creator*"
  "Create an image with a text layer over a pattern layer"
  "Graechan"
  "Graechan - http://gimpchat.com"
  "Mar 2013"
  ""
  SF-ADJUSTMENT "Image width (pixels)" '(250 1 1000 1 10 0 1)
  SF-ADJUSTMENT "Image height(pixels)" '(250 1 1000 1 10 0 1)
  SF-TEXT       "Text"    "Iccii\nLayer Effects"
  SF-ADJUSTMENT "Letter Spacing" '(0 -100 100 1 5 0 0)
  SF-ADJUSTMENT "Line Spacing" '(0 -100 100 1 5 0 0)
  SF-COLOR      "Text color"         "Black"
  SF-FONT       "Font"               "Futura HV BT"
  SF-ADJUSTMENT "Font size (pixels)" '(230 6 500 1 1 0 1)
  SF-OPTION "Background Type" '("color" "Pattern" "Gradient" "None")
  SF-PATTERN    "Pattern"            "Pink Marble"
  SF-COLOR      "Background color"         "Gray"
  SF-GRADIENT   "Background Gradient" "Abstract 3"
  
  )
(script-fu-menu-register "script-fu-text-creator" "<Image>/ICCII FX")
