(define kp_gegl_menu_root "<Image>/Script-Fu/GEGL")

(define (kp_gegl_operation img layer) 
  (let ((copy (car (gimp-layer-copy layer TRUE))))
    (gimp-image-insert-layer img copy 0 -1)
	(list copy)
  )  
)

(define (kjp24_geglfu_waterpixels img layer size smoothness regularization fill)
  (let ((copy (car (kp_gegl_operation img layer))))
    (gegl-waterpixels copy size smoothness regularization fill)
    (gimp-displays-flush)
  )
)
(script-fu-register
  "kjp24_geglfu_waterpixels"
  _"GEGL Waterpixels on a layer copy"
  "GEGL Waterpixels on a layer copy"
  ""
  ""
  ""
  "*"
  SF-IMAGE        "The Image"     0
  SF-DRAWABLE     "The Layer"     0
  SF-ADJUSTMENT   "Size" '(32 8 1000 1 10 0 1)
  SF-ADJUSTMENT   "Smoothness" '(1.0 0 100.0 1.0 0 2 0)
  SF-ADJUSTMENT   "Regularization" '(0 0 50 1 10 0 1)
  SF-OPTION       "Superpixels Color" '("average" "random")
)
(script-fu-menu-register "kjp24_geglfu_waterpixels" kp_gegl_menu_root)

(define (kjp24_geglfu_slic img layer cluster_size compactness iterations)
  (let ((copy (car (kp_gegl_operation img layer))))
    (gegl-slic copy cluster_size compactness iterations)
    (gimp-displays-flush)
  )
)
(script-fu-register
  "kjp24_geglfu_slic"
  _"GEGL SLIC on a layer copy"
  "GEGL SLIC on a layer copy"
  ""
  ""
  ""
  "*"
  SF-IMAGE        "The Image"     0
  SF-DRAWABLE     "The Layer"     0
  SF-ADJUSTMENT   "Size" '(32 2 1024 1 10 0 1)
  SF-ADJUSTMENT   "Compactness" '(20 1 40 1 10 0 1)
  SF-ADJUSTMENT   "Iterations" '(1 1 30 1 10 0 1)
)
(script-fu-menu-register "kjp24_geglfu_slic" kp_gegl_menu_root)

(define (kjp24_geglfu_emboss img layer type azimuth elevation depth)
  (let ((copy (car (kp_gegl_operation img layer))))
    (gegl-emboss copy type azimuth elevation depth)
    (gimp-displays-flush)
  )
)
(script-fu-register
  "kjp24_geglfu_emboss"
  _"GEGL Emboss on a layer copy"
  "GEGL Emboss on a layer copy"
  ""
  ""
  ""
  "*"
  SF-IMAGE        "The Image"     0
  SF-DRAWABLE     "The Layer"     0
  SF-OPTION       "Type" '("Emboss" "Bumpmap")
  SF-ADJUSTMENT   "Azimuth" '(30 0 360 1 10 2 0)
  SF-ADJUSTMENT   "Elevation" '(45 0 180 1 10 2 0)
  SF-ADJUSTMENT   "Depth" '(20 1 100 1 10 0 1)
)
(script-fu-menu-register "kjp24_geglfu_emboss" kp_gegl_menu_root)
