(define (suomy-fu-high-pass img layer std-dev contrast)
  (let ((copy (car (gimp-layer-copy layer TRUE))))
    (gimp-image-insert-layer img copy 0 -1)
    (gimp-layer-set-mode copy GRAIN-MERGE-MODE)
    (gegl-high-pass copy std-dev contrast)
    (gimp-displays-flush)
    )
  )
(script-fu-register
  "suomy-fu-high-pass"
  _"High pass on a layer copy"
  "High pass on a layer copy"
  ""
  ""
  ""
  "*"
  SF-IMAGE        "The Image"     0
  SF-DRAWABLE     "The Layer"     0
  SF-ADJUSTMENT   "Std Deviation" '(14.0 1.0 100.0 1.0 0 2 0)
  SF-ADJUSTMENT   "Contrast"      '(4.0 1.0 100.0 1.0 0 2 0)
  )
(script-fu-menu-register "suomy-fu-high-pass"
                         "<Image>/Filters/Suomy")
