;script-fu hevan-rename-layers
;author : Hevan53

(define (script-fu-hevan-rename-layers inImage inDrawable inLayersVis inMult
                                       inPref inSepStr inBaseNames inSuf
                                       inNumberingType inStartNumber inNumberingWay inNumberingPos)

  (define (gimp-message-and-quit message)
    (let ( (old-handler (car (gimp-message-get-handler))) );get your handler type
      (gimp-message-set-handler MESSAGE-BOX)
      (gimp-message message)
      (gimp-message-set-handler old-handler);set handler to your handler type
      (quit)))

  ;get the layers that will be renamed
  (define  (available-layers num-base-names)
    (let* ( (parent (car (gimp-item-get-parent inDrawable)))
            (layers-ids (if (= -1 parent)
                          (cadr (gimp-image-get-layers inImage))
                          (cadr (gimp-item-get-children parent))))
            (p (car (gimp-image-get-item-position inImage inDrawable)))
            (p+ (+ p 1))
            (n (if (= inMult 0) p+ (min (* num-base-names inMult) p+)));number of available layers (temporary number if layers-vis= 0 or 1)
            (layers-vis (- inLayersVis 1));layers-vis= 0 (invisibles) or 1 (visibles) or -1 (invisibles and visibles)
            (list-available-layers '()) );list of available layers to be renamed
      (case layers-vis
        ((0 1) (let ( (n-real 0) );n-real : number of availables layers if layers-vis= 0 or 1
                 (do ( (i 0 (+ i 1)) )
                   ((or (= n n-real) (= i p+)) (set! n n-real))
                   (let* ( (layer (vector-ref layers-ids (- p i)))
                           (vis (car (gimp-item-get-visible layer))) )
                     (if (= vis layers-vis)
                       (begin
                         (set! list-available-layers (cons layer list-available-layers))
                         (set! n-real (+ n-real 1)))))))
               (if (= n 0)
                 (gimp-message-and-quit "No available layers to rename.")
                 (set! list-available-layers (reverse list-available-layers))))
        ((-1) (set! layers-ids (vector->list layers-ids))
              (set! list-available-layers (member inDrawable (reverse (list-tail layers-ids (- p+ n)))))))
      (list n (list->vector list-available-layers))))

  (if (= (car (gimp-item-is-layer-mask inDrawable)) TRUE)
    (set! inDrawable (car (gimp-layer-from-mask inDrawable))))

  (let* ( (list-base-names (strbreakup inBaseNames inSepStr))
          (num-base-names (length list-base-names))
          (result-al (available-layers num-base-names))
          (num-layers (car result-al));number of layers to be renamed
          (str-num-layers (number->string num-layers))
          (layers-ids (cadr result-al));layer array containing layers that will be renamed
          ;function giving a name :
          (name (lambda ()
                  (let ( (str (list-ref list-base-names j)) )
                    (if (string=? str "§") (car (gimp-item-get-name layer)) str))))
          (num-tot-digits (string-length (number->string (+ num-layers inStartNumber -1))));used for "invariable number of digits"
          ;function giving the numeration :
          (number (case inNumberingType
                    ((0) (lambda () ""))
                    ((1 2) (lambda ()
                             (let ( (num
                                      (number->string
                                        (if (= inNumberingWay 0)
                                          (+ i inStartNumber)
                                          (+ inStartNumber num-layers (- i) -1)))) )
                               (if (= inNumberingType 1)
                                 (string-append (make-string (- num-tot-digits (string-length num)) #\0) num)
                                 num))))))
          (layer 0)
          (i 0) (j 0) );i is used to get a layer in layers-ids, j is used to get a name in list-base-names

    (gimp-image-undo-group-start inImage)
    (while (< i num-layers)
      (if (= j num-base-names) (set! j 0))
      (set! layer (vector-ref layers-ids i))
      (gimp-item-set-name layer (case inNumberingPos
                                  ((0) (string-append inPref (name) inSuf (number)))
                                  ((1) (string-append inPref (name) (number) inSuf))
                                  ((2) (string-append inPref (number) (name) inSuf))
                                  ((3) (string-append (number) inPref (name) inSuf))))
      (gimp-progress-set-text (string-append "Renamed layers : " (number->string (+ i 1)) "/" str-num-layers))
      (gimp-progress-update (/ (+ i 1) num-layers))
      (set! i (+ i 1))
      (set! j (+ j 1)))
    (gimp-image-undo-group-end inImage)
    (gimp-displays-flush);this is not for the display because the script just renamed layers, but this is to activate the undo history

  )
)

(script-fu-register
        "script-fu-hevan-rename-layers"
        "Rename layers..."
        ""
        "Hevan53"
        "Hevan53"
        "2010-2011"
        "*"

        SF-IMAGE "Image" 0
        SF-DRAWABLE "Drawable" 0
        SF-OPTION "Renamable layers visibility" '("Both" "Invisibles" "Visibles")
        SF-ADJUSTMENT "Name(s) multiplicator\n(0 = all layers)" '(0 0 10000 1 1 0 1)
        SF-STRING "Prefix" ""
        SF-STRING "Names separator" "/"
        SF-STRING "Base name(s)" ""
        SF-STRING "Suffix" ""
        SF-OPTION "Numbering type" '("none" "invariable number of digits" "classic")
        SF-ADJUSTMENT "Start number" '(1 0 10000 1 1 0 1)
        SF-OPTION "Numbering way" '("bottom to top" "top to bottom")
        SF-OPTION "Numbering position" '("after suffix" "between base name and suffix"  "between prefix and base name" "before prefix")
)

(script-fu-menu-register "script-fu-hevan-rename-layers" "<Image>/Tools/"
)
