; The GIMP -- an img manipulation program
; Copyright (C) 1995 Spencer Kimball and Peter Mattis
; -----------------------------------------------------------------------
; The GIMP script-fu  old-photo-bakumatu.scm  for GIMP2.8
; Copyright (C) 2015 <tamagoro7@outlook.jp>
; --------------------------------------------------------------------
; mods for Gimp 2.10 - MrQ 
; (rand) added to plasma call - deprecated menu format updated - rich

(define (script-fu-old-photo-bakumatu image drawable)
 (let* ((width (car (gimp-drawable-width drawable)))
        (height (car (gimp-drawable-height drawable)))
        (img (car (gimp-image-new width height RGB)))
        (base (car (gimp-layer-new img width height RGBA-IMAGE "Background" 100 LAYER-MODE-NORMAL-LEGACY)))
        (dirt-layer (car (gimp-layer-new img width height RGBA-IMAGE "Dirt" 40 LAYER-MODE-OVERLAY-LEGACY)))
        (scratch-layer (car (gimp-layer-new img width height RGBA-IMAGE "White wound" 30 LAYER-MODE-SCREEN-LEGACY)))
        (channel (car (gimp-channel-new img width height "channel" 0 '(0 0 0))))
        (border (floor (/ width 8)))
        (sharpe (floor (/ width 30)))
        (copy-layer1)
        (copy-layer2)
        (merge-layer)
        (scratch-copy)
        (floating-sel)
        (selection)
        (brightness)
        )

	;; Start processing
	(gimp-context-push)
	(gimp-image-undo-group-start image)
	(gimp-image-undo-disable img)
	(gimp-selection-none image)
	(gimp-edit-copy drawable)

	;; Background layer creation and decolorization
	(gimp-image-add-layer img base -1)
	(gimp-floating-sel-anchor (car (gimp-edit-paste base FALSE)))
	(gimp-desaturate-full base 1)

	;; Image display
	(gimp-display-new img)

	;; Pretreatment
	(set! copy-layer1 (car (gimp-layer-copy base 1)))
	(set! copy-layer2 (car (gimp-layer-copy base 1)))
	(gimp-image-add-layer img copy-layer1 -1)
	(gimp-image-add-layer img copy-layer2 -1)
	(plug-in-gauss-iir2 1 img copy-layer2 10 10)
	(gimp-layer-set-mode copy-layer2 LAYER-MODE-GRAIN-EXTRACT-LEGACY)
	(set! merge-layer (car (gimp-image-merge-down img copy-layer2 1)))
	(gimp-layer-set-mode merge-layer LAYER-MODE-GRAIN-MERGE-LEGACY)
	(set! base (car (gimp-image-merge-down img merge-layer 1)))
	(plug-in-gauss-iir2 1 img base 1 1)
	(plug-in-sharpen 1 img base 20)

	;; Contrast and noise and coloring
	(gimp-brightness-contrast base 0 60)
	(gimp-brightness-contrast base 0 -60)
	(plug-in-rgb-noise 1 img base FALSE FALSE 0.05 0.05 0.05 0.00)
	(gimp-colorize base 40 20 10)

	;; Create selection of image border
	(if (< width height) (set! border (floor (/ height 8))) )
	(gimp-selection-all img)
 	(gimp-selection-shrink img (floor (/ border 2)))
 	(gimp-selection-feather img border)
 	(gimp-selection-invert img)
 	(set! selection (car (gimp-selection-save img)))

	;; Copy and paste
	(gimp-edit-copy base)
	(set! floating-sel (car (gimp-edit-paste base FALSE)))
	(gimp-invert floating-sel)
	(gimp-hue-saturation floating-sel 0 180 0 0)
	(gimp-layer-set-mode floating-sel LAYER-MODE-OVERLAY-LEGACY)
	(gimp-floating-sel-anchor floating-sel)

	;; Repetition
	(gimp-selection-all img)
 	(gimp-selection-shrink img (floor (/ border 10)))
 	(gimp-selection-feather img (floor (/ border 5)))
 	(gimp-selection-invert img)
	(gimp-edit-copy base)
	(set! floating-sel (car (gimp-edit-paste base FALSE)))
	(gimp-invert floating-sel)
	(gimp-hue-saturation floating-sel 0 180 0 0)
	(gimp-layer-set-mode floating-sel LAYER-MODE-OVERLAY-LEGACY)
	(gimp-layer-set-opacity floating-sel 25)
	(gimp-floating-sel-anchor floating-sel)

	;; Radial blend
	(gimp-context-set-default-colors)
	(gimp-blend base 0 5 2 25 0 0 TRUE FALSE 0 0 TRUE (/ width 2) (/ height 2) width height)

	;; Create dirt layer
	(gimp-image-add-layer img dirt-layer -1)
	(gimp-drawable-fill dirt-layer FILL-FOREGROUND)
	(gimp-image-add-channel img channel 0)
;    (plug-in-plasma 1 img channel (srand (realtime)) 5.0)
	(plug-in-plasma 1 img channel (random 12345) 5.0)
	(if (< width height) (set! sharpe (floor (/ height 30))) )
	(if (> sharpe 60) (set! sharpe 60) )
	(plug-in-sharpen 1 img channel sharpe)
	(gimp-selection-load selection)
	(gimp-brightness-contrast channel -60 0)
 	(gimp-selection-load channel)
	(gimp-edit-fill dirt-layer FILL-WHITE)
	(gimp-selection-none img)

	;; Create a bruise layer
	(gimp-image-add-layer img scratch-layer -1)
	(gimp-drawable-fill scratch-layer FILL-FOREGROUND)
	(if (> width height)
;        (plug-in-solid-noise 1 img channel FALSE FALSE (srand (realtime)) 15 6.0 5.0)
;	     (plug-in-solid-noise 1 img channel FALSE FALSE (srand (realtime)) 15 5.0 6.0))
	    (plug-in-solid-noise 1 img channel FALSE FALSE (random 12345) 15 6.0 5.0)
	    (plug-in-solid-noise 1 img channel FALSE FALSE (random 12345) 15 5.0 6.0))
	(plug-in-edge 1 img channel 1.0 2 0)
	(plug-in-normalize 1 img channel)
	(gimp-levels channel 0 115 200 1.0 0 255)
	(plug-in-sharpen 1 img channel sharpe)
	(gimp-selection-load channel)
	(gimp-edit-fill scratch-layer FILL-WHITE)
	(gimp-selection-none img)

	;; Create a black scratch layer
	(set! scratch-copy (car (gimp-layer-copy scratch-layer 1)))
	(gimp-image-add-layer img scratch-copy -1)
	(gimp-invert scratch-copy)
	(gimp-flip scratch-copy 0)
	(gimp-flip scratch-copy 1)
	(gimp-layer-set-mode scratch-copy LAYER-MODE-BURN-LEGACY)
	(gimp-layer-set-opacity scratch-copy 15)
	(gimp-layer-set-name scratch-copy "Black wound")

	;; Create contrast adjustment layer
	(set! brightness (car (gimp-layer-copy base 1)))
	(gimp-image-add-layer img brightness 3)
	(gimp-layer-set-mode brightness LAYER-MODE-OVERLAY-LEGACY)
	(gimp-layer-set-opacity brightness 20)
	(gimp-layer-set-name brightness "Contrast adjustment")

	;; Post processing
	(gimp-image-remove-channel img selection)
	(gimp-image-remove-channel img channel)
	(gimp-image-undo-enable img)
 	(gimp-image-undo-group-end image)
	(gimp-context-pop)
	(gimp-displays-flush)
 )
)

(script-fu-register
  "script-fu-old-photo-bakumatu"
  "photo-bakumatu "
  "Edo period old photograph effect"
  "Tamagoro <tamagoro7@outlook.jp>"
  "Tamaro"
  "2015/09"
  "RGB*"
  SF-IMAGE       "Image"		0
  SF-DRAWABLE    "Drawable"		0
  
)
(script-fu-menu-register "script-fu-old-photo-bakumatu"   "<Image>/Filters/Artistic/Bakumatu Photo (Edo Period)")
