#!/usr/bin/env python
# -*- coding: utf-8 -*-

#################
## User Config ##
#################
ACTIVE_DIR=r"/Users/your-name-here/Library/Application Support/GIMP/2.10/fonts" #<<<-----SET ME<<<----- (Directory to hold active sets, select Writable in Preferences)
INSTALL_DIR=r"/Users/your-name-here/Library/Application Support/GIMP/2.10/fonts_alt"#<<<-----SET ME<<<----- (Directory where you place your sets - in subdirectories)

EXTENTIONS = [".ttf", ".TTF", ".ttc", ".TTC", ".pfb", ".PFB", ".ps", ".PS", ".fon", ".FON"] # Valid font extentions

################
## End Config ##
################

## Do NOT edit below this line unless you know what you're doing!
"""
GIMP Font Manager
By: Sean Bogie

Version 2.01
Version 2.02 by MareroQ - add autorefresh and context menu
"""

ARCH_EXTENTIONS = []

import pygtk
pygtk.require('2.0')
import gtk
import shutil
import os
try:
    import zipfile
    ARCH_EXTENTIONS.append( ".zip" )
except ImportError:
    zipfile = None
try:
    from gimpfu import *
    import gimp
except ImportError:
    def main():
        do_fontmanager()

PROC_NAME = "python_fu_font_manager"

class fontManager:
    
    dialog = None

    def listDirs( self, path ):
        dirs=[]
        for i in os.listdir( path ):
            if os.path.isdir( os.path.join( path, i ) ):
                dirs.append( i )
        return dirs
    def listArchives( self, path ):
        archs=[]
        for i in os.listdir( path ):
            if os.path.splitext( i )[1] in ARCH_EXTENTIONS:
                if os.path.isfile( os.path.join( path, i ) ):
                    archs.append( i )
        return archs

    def listFiles( self, path ):
        files=[]
        if os.path.isfile( path ):
            if zipfile and zipfile.is_zipfile( path ):
                z = zipfile.ZipFile( path )
                return z.namelist()
        for i in os.listdir( path ):
            if os.path.splitext( i )[1] in EXTENTIONS:
                if os.path.isfile( os.path.join( path, i ) ):
                    files.append( i )
        return files

    def getActive( self ):
        try:
            f=open( os.path.join( INSTALL_DIR, "active.txt" ) )
        except IOError:
            return []
        line=f.readline()
        a=line.split( "," )
        f.close()
        return a[:-1]

    def dialog_delete( self, widget, event, data=None ):
        return True

    def makedialog( self ):
        self.dialog = gtk.Dialog( "Please Wait...", self.win,
            gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT )
        self.dialog.connect( "delete_event", self.dialog_delete )
        self.dialog.set_size_request( 200, 100 )
        
        self.statuslabel = gtk.Label( "Status:" )
        self.dialog.vbox.pack_start( self.statuslabel, False, False, 0 )
        
        self.progressbar = gtk.ProgressBar()
        self.dialog.vbox.pack_start( self.progressbar, False, True, 0 )

    def showdialog( self ):
        self.statuslabel.show()
        self.progressbar.show()
        self.dialog.show()

    def hidedialog( self ):
        self.statuslabel.hide()
        self.progressbar.hide()
        self.dialog.hide()

    def do_copy( self, add, add_arch, remove ):
        count = 0.0
        total = 0
        for name in add_arch:
            if zipfile and zipfile.is_zipfile( name ):
                z = zipfile.ZipFile( name )
                total += len( z.namelist() )
        total += len( add ) + len( remove )
        if not self.dialog:
            self.makedialog()
        self.showdialog()
        self.progressbar.set_fraction( 0 )
        self.statuslabel.set_text( "Status: Removing old files..." )
        for f in remove:
            gtk.main_iteration()
            try:
                os.remove( f )
            except:
                continue
            finally:
                count += 1.0
                self.progressbar.set_fraction( count / total )
        self.statuslabel.set_text( "Status: Copying new files..." )
        for f in add:
            gtk.main_iteration()
            try:
                shutil.copy( f, ACTIVE_DIR )
            except:
                continue
            finally:
                count += 1.0
                self.progressbar.set_fraction( count / total )
        for arch in add_arch:
            if zipfile and zipfile.is_zipfile( arch ):
                z = zipfile.ZipFile( arch )
                for i in z.namelist():
                    gtk.main_iteration()
                    try:
                        f = open( os.path.join( ACTIVE_DIR, i ), "wb" )
                        f.write( z.read( i ) )
                    except:
                        continue
                    finally:
                        f.close()
                        count += 1.0
                        self.progressbar.set_fraction( count / total )
                z.close()
        gtk.main_iteration()
        self.statuslabel.set_text( "Status: Refreshing font list..." )
        gtk.main_iteration()
        try:
            gimp.pdb.gimp_fonts_refresh()
        except:
            pass
        self.hidedialog()

    def ok_clicked( self, widget, data=None ):
        active = []
        for i in self.checkboxes:
            if i.get_active():
                active.append( i.get_label() )
        oldActive = self.getActive()

        add = []
        add_arch = []
        for i in active:
            if not i in oldActive:
                if os.path.isfile( os.path.join( INSTALL_DIR, i ) ):
                    add_arch.append( os.path.join( INSTALL_DIR, i ) )
                else:
                    for j in self.listFiles( os.path.join( INSTALL_DIR, i ) ):
                        add.append( os.path.join( INSTALL_DIR, i, j ) )
        
        remove = []
        for i in oldActive:
            if not i in active:
                for j in self.listFiles( os.path.join( INSTALL_DIR, i ) ):
                    remove.append( os.path.join( ACTIVE_DIR, j ) )

        self.do_copy( add, add_arch, remove )

        try:
            f=open( os.path.join( INSTALL_DIR, "active.txt" ), "w" )
        except IOError:
            return -1
        try:
            for i in active:
                f.write( i + "," )
        except Exception:
            return -1
        finally:
            f.close()

    def destroy( self, widget, data=None ):
        gtk.main_quit()

    def __init__( self ):

        self.win = gtk.Dialog()
        self.win.connect( "destroy", self.destroy )
        self.win.set_title( "Fonts manager" )
        self.win.set_border_width( 10 )
        self.win.set_size_request( 200, 400 )
        
    
        scroll_box = gtk.ScrolledWindow()
        scroll_box.set_border_width( 10 )
        scroll_box.set_policy( gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC )
        self.win.vbox.pack_start( scroll_box, True, True, 0 )
        scroll_box.show()

        vbox = gtk.VBox()
        self.checkboxes=[]
        dirs = self.listDirs( INSTALL_DIR )
        dirs.extend( self.listArchives( INSTALL_DIR ) )
        dirs.sort()
        for i in dirs:
            self.checkboxes.append( gtk.CheckButton( os.path.split( i )[1] ) )
        active = self.getActive()
        for i in self.checkboxes:
            vbox.pack_start( i, False, False, 1 )
            if i.get_label() in active:
                i.set_active( True )
            i.show()
        scroll_box.add_with_viewport( vbox )
        vbox.show()

        cancelButton = gtk.Button( stock=gtk.STOCK_CLOSE )
        cancelButton.connect_object( "clicked", gtk.Widget.destroy, self.win )
        self.win.action_area.pack_start( cancelButton, True, True, 0 )
        cancelButton.show()

        okButton = gtk.Button( stock=gtk.STOCK_OK )
        okButton.connect( "clicked", self.ok_clicked )
        self.win.action_area.pack_start( okButton, True, True, 0 )
        okButton.show()

        self.win.show()

    def main(self):
        gtk.main()

def do_fontmanager():
    mgr = fontManager()
    mgr.main()

try:
    register(
        PROC_NAME,
        N_("Gimp font manager in context menu"),
        "Enable and/or disable sets of fonts",
        "Sean Bogie",
        "Sean Bogie",
        "2008",
        N_("_Font manager..."),
        "",
        [],
        [],
        do_fontmanager,
        menu="<Fonts>")
except:
    pdb.gimp-fonts-refresh

main()
