/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class PainterlyPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Document _document;

    public PainterlyPanel(Document doc) {
        super(null);
        this.setLayout(null);
        this._document = doc;
        this._document.addStateChangeListener(new StateChangeListener(){

            @Override
            public void stateChanged() {
                PainterlyPanel.this.setSize(PainterlyPanel.this.getPreferredSize());
                PainterlyPanel.this.repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D gX = (Graphics2D)g;
        super.paintComponent(g);
        gX.setBackground(Color.LIGHT_GRAY);
        gX.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this._document.getTargetImage() != null) {
            gX.drawImage(this._document.getTargetImage(), 0, 0, this._document.getTargetImage().getWidth(), this._document.getTargetImage().getHeight(), null);
        } else {
            gX.setColor(Color.white);
            gX.fillRect(0, 0, 640, 480);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._document.getTargetImage() != null) {
            return new Dimension(this._document.getTargetImage().getWidth(), this._document.getTargetImage().getHeight());
        }
        return new Dimension(640, 480);
    }
}

