#!/usr/bin/env python
# -*- coding: utf-8 -*-

# GIMP plugin to remove tables before OCR
# (c) Ofnuts 2020
#
#   History:
#
#   v0.0: 2020-10-02 First published version
#   v0.1: 2020-10-02 Use area of existing selection if any

#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import os, sys

from gimpfu import *

def boundingBoxArea(points):
    allX=points[0::2]
    allY=points[1::2]
    return (max(allX)-min(allX))*(max(allY)-min(allY))

def removeGrid(image,drawable,growBefore,areaThreshold,growAfter):
    pdb.gimp_image_undo_group_start(image)
    try:
        # If there is a selection, we use its size as the area threshold
        if not pdb.gimp_selection_is_empty(image):
             _,_,_,areaThreshold,_,_=pdb.gimp_drawable_histogram(drawable, HISTOGRAM_VALUE, 0., 1.)
        pdb.gimp_image_select_color(image,CHANNEL_OP_REPLACE, drawable,gimp.get_foreground())
        pdb.gimp_selection_grow(image,growBefore)
        pdb.plug_in_sel2path(image,None)
        fullPath=image.vectors[0]
        filteredPath=gimp.Vectors(image,'Grid')
        for s in fullPath.strokes:
            points,closed=s.points
            if boundingBoxArea(points)<areaThreshold:
                continue
            gimp.VectorsBezierStroke(filteredPath,points,closed)
        pdb.gimp_image_add_vectors(image, filteredPath, 0)
        pdb.gimp_image_select_item(image, CHANNEL_OP_REPLACE,filteredPath)
        pdb.gimp_selection_grow(image,growAfter)
        pdb.gimp_edit_bucket_fill(drawable, BG_BUCKET_FILL, NORMAL_MODE, 100,0,False,0,0)
        pdb.gimp_selection_none(image)
        pdb.gimp_image_remove_vectors(image,fullPath)
        pdb.gimp_image_remove_vectors(image,filteredPath)
        
    except Exception as e:
        print e.args[0]
        pdb.gimp_message(e.args[0])
    pdb.gimp_image_undo_group_end(image)
    pdb.gimp_displays_flush()
    return;


### Registration
whoiam='\n'+os.path.abspath(sys.argv[0])
desc='Remove table/grid around text'

register(
	'ofn-remove-grid',
	desc+whoiam,
	desc,
	'Ofnuts',
	'Ofnuts',
	'2020',
	desc,
	'*',
	[
		(PF_IMAGE, 'image', 'Input image', None),
		(PF_DRAWABLE, 'layer', 'Input layer',None),
		(PF_SPINNER, 'growBefore', 'Grow selection before',0,(0,100,1)),
		(PF_INT, 'areaThreshold', 'Area Threshold',10000),
		(PF_SPINNER, 'growAfter', 'Grow selection after',1,(0,100,1)),
	],
	[],
	removeGrid,
	menu='<Image>/Filters/Enhance',
)


main()
