#!/usr/bin/env python
#
from gimpfu import *

def png_it(image, layer, outputFolder):

    gimp.progress_init("Saving to '" + outputFolder + "'...")

    offsetx = (950 - image.width) / 2 
    offsety = (950 - image.height) / 2
    
    pdb.gimp_layer_add_alpha(layer)
    pdb.gimp_edit_clear(layer)
    
    pdb.gimp_image_resize(image, 950, 950 ,offsetx, offsety)
    pdb.gimp_layer_resize_to_image_size(layer)
    
    try:
 
        gimp.pdb.file_png_save(image, layer,outputFolder + "/" + layer.name + ".png","raw_filename",0,9,0,0,0,0,0)
        
        gimp.pdb.gimp_image_clean_all(image)

    except Exception as err:
        gimp.message("Unexpected error: " + str(err))
    
register(
    "python_fu_png_it",
    "Export to files",
    "Scale - export  to png file",
    "RG",
    "Open source",
    "2013",
    "<Image>/Tools/png_it",
    "*",
    [
        (PF_DIRNAME, "outputFolder", "Output directory", ""),
    ],
    [],
    png_it)

main()
