#!/usr/bin/env python

# render_map Rel 2
# This script runs steps described here -> https://www.cartographersguild.com/showthread.php?t=1142
# Created by Tin Tran http://gimplearn.net
# Comments directed to http://gimplearn.com or http://gimp-forum.net or http://gimpchat.com or http://gimpscripts.com
#
# License: GPLv3
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# To view a copy of the GNU General Public License
# visit: http://www.gnu.org/licenses/gpl.html
#
#
# ------------
#| Change Log |
# ------------
# Rel 1: Initial release.
# Rel 2: Added some more scripted steps to improve ocean.
import random
#import string
#import Image
from gimpfu import *
#from array import array
#import sys


def python_tt_render_map(image, layer):
	pdb.gimp_image_undo_group_start(image)
	pdb.gimp_context_push()
	
	seed =  random.randrange(100000,10000000) #ocean and land
	seed2 = random.randrange(100000,10000000) #grass texture
	land_start = pdb.gimp_image_get_layer_by_name(image,"Land Start")
	pdb.gimp_layer_set_opacity(land_start,100)
	land = pdb.gimp_layer_new_from_drawable(land_start,image)
	pdb.gimp_image_insert_layer(image,land,None,0)
	#remove red dot on Land layer
	#pdb.gimp_image_select_color(image,CHANNEL_OP_REPLACE,land,(255,0,0))
	#pdb.gimp_context_set_foreground((0,0,0))
	#pdb.gimp_edit_fill(land,FOREGROUND_FILL)
	pdb.gimp_selection_none(image)
	pdb.gimp_item_set_name(land,"Land")
	#gauss blur land
	pdb.plug_in_gauss(image,land,50,50,1)
	#land_noise
	land_noise = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Land Noise",100,OVERLAY_MODE)
	pdb.gimp_image_insert_layer(image,land_noise,None,0)
	pdb.plug_in_solid_noise(image,land_noise,False,False,seed,15,16,16)
	#land_clip
	land_clip = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Land Clip",100,LIGHTEN_ONLY_MODE)
	pdb.gimp_image_insert_layer(image,land_clip,None,0)
	pdb.gimp_edit_fill(land_clip,WHITE_FILL)
	pdb.gimp_levels(land_clip,HISTOGRAM_VALUE,0,255,1.0,0,71)
	pdb.gimp_by_color_select_full(land_clip,(71,71,71),0,CHANNEL_OP_REPLACE,True,False,0,0,True,True,SELECT_CRITERION_COMPOSITE)
	pdb.gimp_selection_invert(image)
	land_mask_mask = pdb.gimp_selection_save(image)
	pdb.gimp_item_set_name(land_mask_mask,"Land Mask")
	pdb.gimp_selection_none(image)
	#ocean bump layer
	pdb.gimp_levels(land_clip,HISTOGRAM_VALUE,0,255,1.0,0,0)
	ocean_bump = pdb.gimp_layer_new_from_visible(image,image,"Ocean bump")
	pdb.gimp_image_insert_layer(image,ocean_bump,None,0)
	pdb.gimp_item_set_visible(ocean_bump,False)
	
	
	#land_mask
	land_mask = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Land Mask",100,NORMAL_MODE)
	pdb.gimp_image_insert_layer(image,land_mask,None,0)
	pdb.gimp_selection_none(image)
	pdb.gimp_context_set_foreground((0,0,0))
	pdb.gimp_edit_fill(land_mask,FOREGROUND_FILL)
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,land_mask_mask)
	pdb.gimp_edit_fill(land_mask,WHITE_FILL)
	pdb.gimp_selection_none(image)
	#CREATE SEA
	sea_shape = pdb.gimp_layer_new_from_drawable(land_mask,image)
	pdb.gimp_image_insert_layer(image,sea_shape,None,0)
	pdb.gimp_item_set_name(sea_shape,"Sea Shape")
	#gauss blur sea
	pdb.plug_in_gauss(image,sea_shape,500,500,1)
	#sea_noise
	sea_noise = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Sea Noise",100,OVERLAY_MODE)
	pdb.gimp_image_insert_layer(image,sea_noise,None,0)
	pdb.plug_in_solid_noise(image,sea_noise,False,False,seed,15,3,3)
	#merge it down with sea shape
	sea_shape = pdb.gimp_image_merge_down(image,sea_noise,EXPAND_AS_NECESSARY)
	#duplicate sea shape and name it sea
	sea = pdb.gimp_layer_new_from_drawable(sea_shape,image)
	pdb.gimp_image_insert_layer(image,sea,None,0)
	pdb.gimp_item_set_name(sea,"Sea")
	
	sea_bumps = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Sea Bumps",100,OVERLAY_MODE)
	pdb.gimp_image_insert_layer(image,sea_bumps,None,0)
	pdb.gimp_context_set_foreground((128,128,128))
	pdb.gimp_edit_fill(sea_bumps,FOREGROUND_FILL)
	pdb.plug_in_bump_map(image,sea_bumps,ocean_bump,120,45,18,0,0,0,0,True,False,0)
	
	#6. Make a copy "Ocean bump layer" move it above "Sea" layer OVERLAY MODE to darken sea. maybe opacity 50%
	sea_bumps2 = pdb.gimp_layer_new_from_drawable(ocean_bump,image)
	pdb.gimp_image_insert_layer(image,sea_bumps2,None,0)
	pdb.gimp_item_set_name(sea_bumps2,"Sea Bumps 2 to darken ocean")
	pdb.gimp_layer_set_mode(sea_bumps2,OVERLAY_MODE)
	pdb.gimp_layer_set_opacity(sea_bumps2,50)
	pdb.gimp_item_set_visible(sea_bumps2,True)
	
	# selects mask invert it to use as sea MASK
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,land_mask_mask)
	pdb.gimp_selection_invert(image)
	sea_mask = pdb.gimp_layer_create_mask(sea,ADD_SELECTION_MASK)
	pdb.gimp_layer_add_mask(sea,sea_mask)
	pdb.gimp_layer_remove_mask(sea,MASK_APPLY)
	#normalize sea layer
	pdb.plug_in_normalize(image,sea)
	#select non-transparent and invert it, fill with white
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,sea)
	pdb.gimp_selection_invert(image)
	non_empty,x1,y1,x2,y2 = pdb.gimp_selection_bounds(image)
	if non_empty: #Only fill if there is a selection otherwise it'll fill our whole image which we don't want.
		pdb.gimp_edit_fill(sea,WHITE_FILL)
	
	pdb.gimp_selection_none(image)
	pdb.plug_in_gauss(image,sea,20,20,1)
	#gradient map with water color
	pdb.gimp_context_set_foreground((37,50,95)) #dark water color
	pdb.gimp_context_set_background((93,125,174)) #2nd lightest water color)
	pdb.plug_in_gradmap(image,sea)
	
	#seashore
	seashore = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Seashore",100,NORMAL_MODE)
	pdb.gimp_image_insert_layer(image,seashore,None,0)
	pdb.gimp_context_set_foreground((241,244,253))
	pdb.gimp_edit_fill(seashore,FOREGROUND_FILL)
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,land_mask_mask)
	seashore_mask = pdb.gimp_layer_create_mask(seashore,ADD_SELECTION_MASK)
	pdb.gimp_selection_none(image)
	pdb.gimp_layer_add_mask(seashore,seashore_mask)
	pdb.plug_in_gauss(image,seashore_mask,10,10,1)
	pdb.plug_in_displace(image,seashore_mask,20,-20,1,1,land_noise,land_noise,2)
	pdb.plug_in_displace(image,seashore_mask,-20,20,1,1,land_noise,land_noise,2)
	pdb.gimp_layer_set_opacity(seashore,50)
	#OCEAN COMPLETE
	#CREATE GRASS
	grass = pdb.gimp_layer_new_from_drawable(sea_shape,image)
	pdb.gimp_image_insert_layer(image,grass,None,0)
	pdb.gimp_item_set_name(grass,"Grass")
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,land_mask_mask)
	grass_mask = pdb.gimp_layer_create_mask(grass,ADD_SELECTION_MASK)
	pdb.gimp_layer_add_mask(grass,grass_mask)
	pdb.gimp_selection_none(image)
	#gradient map with grass color
	pdb.gimp_context_set_foreground((149,149,89)) #high ground color
	pdb.gimp_context_set_background((76,83,41)) #ditch color
	pdb.plug_in_gradmap(image,grass)
	#grass_texture
	grass_texture = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Grass Texture",100,OVERLAY_MODE)
	pdb.gimp_image_insert_layer(image,grass_texture,None,0)
	pdb.plug_in_solid_noise(image,grass_texture,False,False,seed2,15,3,3)
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,land_mask_mask)
	grass_texture_mask = pdb.gimp_layer_create_mask(grass_texture,ADD_SELECTION_MASK)
	pdb.gimp_layer_add_mask(grass_texture,grass_texture_mask)
	pdb.gimp_selection_none(image)
	#grass_bump_map and hide it
	grass_bump_map = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Grass Bump Map",100,NORMAL_MODE)
	pdb.gimp_image_insert_layer(image,grass_bump_map,None,0)
	pdb.plug_in_solid_noise(image,grass_bump_map,False,True,seed2,15,16,16)
	pdb.gimp_item_set_visible(grass_bump_map,False)
	#grass bumps
	grass_bumps = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Grass Bumps",100,OVERLAY_MODE)
	pdb.gimp_image_insert_layer(image,grass_bumps,None,0)
	pdb.gimp_context_set_foreground((128,128,128))
	pdb.gimp_edit_fill(grass_bumps,FOREGROUND_FILL)
	pdb.plug_in_bump_map(image,grass_bumps,grass_bump_map,120,45,3,0,0,0,0,True,False,2)
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,land_mask_mask)
	grass_bumps_mask = pdb.gimp_layer_create_mask(grass_bumps,ADD_SELECTION_MASK)
	pdb.gimp_layer_add_mask(grass_bumps,grass_bumps_mask)
	pdb.gimp_selection_none(image)
	pdb.gimp_layer_set_opacity(grass_bumps,60) #adjust to taste
	#dirt 
	dirt = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Dirt",100,NORMAL_MODE)
	pdb.gimp_image_insert_layer(image,dirt,None,0)
	pdb.gimp_context_set_foreground((128,107,80))
	pdb.gimp_edit_fill(dirt,FOREGROUND_FILL)
	pdb.plug_in_hsv_noise(image,dirt,4,11,10,22)
	pdb.plug_in_bump_map(image,dirt,dirt,120,45,7,0,0,0,0,True,False,2)
	
	#land mask copy
	land_mask_copy = pdb.gimp_layer_new_from_drawable(land_mask,image)
	pdb.gimp_image_insert_layer(image,land_mask_copy,None,0)
	pdb.plug_in_gauss(image,land_mask_copy,50,50,1)
	#dirt noise
	dirt_noise = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Dirt Noise",100,DIFFERENCE_MODE)
	pdb.gimp_image_insert_layer(image,dirt_noise,None,0)
	pdb.plug_in_solid_noise(image,dirt_noise,False,False,seed2,15,16,16)
	#merge down
	land_mask_copy = pdb.gimp_image_merge_down(image,dirt_noise,EXPAND_AS_NECESSARY)
	pdb.gimp_invert(land_mask_copy)
	pdb.gimp_levels(land_mask_copy,HISTOGRAM_VALUE,174,193,2.29,0,255)
	
	#add mask for dirt
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,land_mask_mask)
	dirt_mask = pdb.gimp_layer_create_mask(dirt,ADD_SELECTION_MASK)
	pdb.gimp_layer_add_mask(dirt,dirt_mask)
	pdb.gimp_selection_none(image)
	pdb.gimp_layer_remove_mask(dirt,MASK_APPLY)
	
	#add white mask
	dirt_mask = pdb.gimp_layer_create_mask(dirt,ADD_WHITE_MASK)
	pdb.gimp_layer_add_mask(dirt,dirt_mask)
	pdb.gimp_selection_all(image)
	pdb.gimp_edit_copy(land_mask_copy)
	floating_sel = pdb.gimp_edit_paste(dirt_mask,True)
	pdb.gimp_floating_sel_anchor(floating_sel)
	pdb.gimp_image_remove_layer(image,land_mask_copy)
	#blur and spread dirt
	pdb.plug_in_gauss(image,dirt_mask,10,10,1)
	pdb.plug_in_spread(image,dirt_mask,10,10)
	pdb.gimp_layer_set_opacity(dirt,83.5)
	
	#Mountains
	mountains_start = pdb.gimp_image_get_layer_by_name(image,"Mountains Start")
	pdb.gimp_layer_set_opacity(mountains_start,100)
	mountains = pdb.gimp_layer_new_from_drawable(mountains_start,image)
	pdb.gimp_image_insert_layer(image,mountains,None,0)
	pdb.gimp_selection_none(image)
	pdb.gimp_item_set_name(mountains,"Mountains")
	pdb.plug_in_gauss(image,mountains,50,50,1)
	
	#mountain_noise
	mountain_noise = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Mountain Noise",100,MULTIPLY_MODE)
	pdb.gimp_image_insert_layer(image,mountain_noise,None,0)
	pdb.plug_in_solid_noise(image,mountain_noise,False,False,seed,8,15,15)
	#moutain_clip
	mountain_clip = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Mountain Clip",100,LIGHTEN_ONLY_MODE)
	pdb.gimp_image_insert_layer(image,mountain_clip,None,0)
	pdb.gimp_edit_fill(mountain_clip,WHITE_FILL)
	pdb.gimp_levels(mountain_clip,HISTOGRAM_VALUE,0,255,1.0,0,71)
	pdb.gimp_by_color_select_full(mountain_clip,(71,71,71),0,CHANNEL_OP_REPLACE,True,False,0,0,True,True,SELECT_CRITERION_COMPOSITE)
	pdb.gimp_selection_invert(image)
	mountain_mask_mask = pdb.gimp_selection_save(image)
	pdb.gimp_item_set_name(mountain_mask_mask,"Mountain Mask")
	#mountain_mask
	mountain_mask = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Mountain Mask",100,NORMAL_MODE)
	pdb.gimp_image_insert_layer(image,mountain_mask,None,0)
	pdb.gimp_selection_none(image)
	pdb.gimp_context_set_foreground((0,0,0))
	pdb.gimp_edit_fill(mountain_mask,FOREGROUND_FILL)
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,mountain_mask_mask)
	pdb.gimp_edit_fill(mountain_mask,WHITE_FILL)
	pdb.gimp_selection_none(image)
	pdb.gimp_item_set_visible(mountain_mask,False)
	
	mountain_visible = pdb.gimp_layer_new_from_visible(image,image,"Mountain Visible")
	pdb.gimp_image_insert_layer(image,mountain_visible,None,0)
	pdb.plug_in_normalize(image,mountain_visible)
	pdb.gimp_item_set_name(mountain_visible,"Mountain Colour")
	mountain_color = mountain_visible
	#mountain bump map
	mountains_bump_map = pdb.gimp_layer_new_from_drawable(mountain_color,image)
	pdb.gimp_image_insert_layer(image,mountains_bump_map,None,0)
	pdb.gimp_item_set_name(mountains_bump_map,"Mountain Bump Map")
	pdb.gimp_item_set_visible(mountains_bump_map, False)
	#gradient map the mountain color
	pdb.gimp_context_set_foreground((75,62,43)) #dark water color
	pdb.gimp_context_set_background((167,143,107)) #2nd lightest water color)
	pdb.plug_in_gradmap(image,mountain_color)
	pdb.plug_in_normalize(image,mountain_color)
	#add mountain mask to mountain color
	pdb.gimp_image_select_item(image,CHANNEL_OP_REPLACE,mountain_mask_mask)
	mountain_color_mask = pdb.gimp_layer_create_mask(mountain_color,ADD_SELECTION_MASK)
	pdb.gimp_layer_add_mask(mountain_color,mountain_color_mask)
	pdb.gimp_selection_none(image)
	pdb.plug_in_gauss(image,mountain_color_mask,10,10,1)
	pdb.plug_in_spread(image,mountain_color_mask,10,10)
	#Mountains Bump
	mountain_bumps = pdb.gimp_layer_new(image,image.width,image.height,RGBA_IMAGE,"Mountain Bumps",100,OVERLAY_MODE)
	pdb.gimp_image_insert_layer(image,mountain_bumps,None,0)
	pdb.gimp_context_set_foreground((128,128,128))
	pdb.gimp_edit_fill(mountain_bumps,FOREGROUND_FILL)
	pdb.plug_in_bump_map(image,mountain_bumps,mountains_bump_map,120,40.52,11,0,0,0,0,True,False,2)
	#dumplicate mountains bumps layer
	mountain_bumps_copy = pdb.gimp_layer_new_from_drawable(mountain_bumps,image)
	pdb.gimp_image_insert_layer(image,mountain_bumps_copy,None,0)
	
	#hide all the other working layers
	pdb.gimp_item_set_visible(mountain_clip, False)
	pdb.gimp_item_set_visible(mountain_noise, False)
	pdb.gimp_item_set_visible(mountains, False)
	
	
	#UNCOMMENT BELOW WHEN DONE
	pdb.gimp_context_pop()
	pdb.gimp_image_undo_group_end(image)
	pdb.gimp_displays_flush()
    #return

register(
	"python_fu_tt_render_map",                           
	"Render D&D Map",
	"Render D&D Map",
	"Tin Tran",
	"Tin Tran",
	"July 2017",
	"<Image>/Python-Fu/Render Map...",             #Menu path
	"RGB*, GRAY*", 
	[
	#(PF_SPINNER, "blur_radius", "Guasian Blur Radius:", 33, (0, 12800, 0.1)),  # alias PF_ADJUSTMENT
	],
	[],
	python_tt_render_map)

main()
