#!/usr/bin/env python
#
from gimpfu import *
import os.path

def jpg_to_png(image, layer, outputFolder):

    gimp.progress_init("Saving to '" + outputFolder + "'...")
    
    try:
        # remove the extension
        layer_name = layer_name = pdb.gimp_item_get_name(layer)
        layer_name = layer_name.replace(".jpg", ".png")
        layer_name = layer_name.replace(".JPG", ".png")
        layer_name = layer_name.replace(".jpeg", ".png")
        layer_name = layer_name.replace(".JPEG", ".png")
        # Save as png
        gimp.pdb.file_png_save(image, layer,outputFolder + "/" + layer_name,"raw_filename",0,9,0,0,0,0,0)
        gimp.pdb.gimp_image_clean_all(image)

    except Exception as err:
        gimp.message("Unexpected error: " + str(err))
    
register(
    "python_fu_test_save_to_png",
    "Save to files",
    "Save the current layer into a png file",
    "RG",
    "Open source",
    "2013",
    "<Image>/Tools/jpg to png",
    "*",
    [
        (PF_DIRNAME, "outputFolder", "Output directory", ""),
    ],
    [],
    jpg_to_png)

main()
