﻿#!/usr/bin/env python

###################################################
##### Group Change Font - GIMP plugin
##### (c) Vesa Kivimäki 2012
##### released under GNU General Public License v2
###################################################

# Updated Ofnuts May 2017, workaround since it seem you cannot have
# a GroupLayer as a parameter to the plugin.

from gimpfu import *

def doGroup(group,recursive,font,size):

    textLayers=[l for l in group.layers if pdb.gimp_item_is_text_layer(l)]
    groupLayers=[l for l in group.layers if isinstance(l,gimp.GroupLayer)]
    
    for textLayer in textLayers:
        if font:
            pdb.gimp_text_layer_set_font(textLayer, font)
        if size:
            pdb.gimp_text_layer_set_font_size(textLayer, size, 0)
    if recursive:
        for group in groupLayers:
            doGroup(group,recursive,font,size)

def group_chfont(image,font, size, cfont, csize, recursive):    
    font=font if cfont else None
    size=size if csize else None
    drawable=image.active_layer
    if isinstance(drawable,gimp.GroupLayer):
        pdb.gimp_image_undo_group_start(image)
        doGroup(drawable,recursive,font,size)
        pdb.gimp_image_undo_group_end(image)
    else:
        gimp.message('Active layer is not a group')

register(
        "group_chfont",
        "Change font and size of all text layers in a group",
        "Change font and size of all text layers in a group",
        "dd",
        "dd",
        "2012",
        "Change font...", 
        "RGB*, GRAY*",
        [
            (PF_IMAGE, 'image', 'Input image', None),
            (PF_FONT, "font", "Font", "Sans"),
            (PF_SPINNER, "size", "Font size", 10, (1, 8192, 1)),
            (PF_TOGGLE, "cfont", "Change font", True),
            (PF_TOGGLE, "csize", "Change size", False),
            (PF_TOGGLE, "rec", "Recurse nested groups", True)
        ],
        [],
        group_chfont,
       	menu='<Image>/Group/',
)

main()
